<?php

namespace pagopa.efil\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Accertamento StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Accertamento
 * @subpackage Structs
 */
class Accertamento extends AbstractStructBase
{
    /**
     * The Codice
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Codice;
    /**
     * The ImportoInCentesimi
     * @var int
     */
    public $ImportoInCentesimi;
    /**
     * Constructor method for Accertamento
     * @uses Accertamento::setCodice()
     * @uses Accertamento::setImportoInCentesimi()
     * @param string $codice
     * @param int $importoInCentesimi
     */
    public function __construct($codice = null, $importoInCentesimi = null)
    {
        $this
            ->setCodice($codice)
            ->setImportoInCentesimi($importoInCentesimi);
    }
    /**
     * Get Codice value
     * @return string|null
     */
    public function getCodice()
    {
        return $this->Codice;
    }
    /**
     * Set Codice value
     * @param string $codice
     * @return \pagopa.efil\StructType\Accertamento
     */
    public function setCodice($codice = null)
    {
        // validation for constraint: string
        if (!is_null($codice) && !is_string($codice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codice, true), gettype($codice)), __LINE__);
        }
        $this->Codice = $codice;
        return $this;
    }
    /**
     * Get ImportoInCentesimi value
     * @return int|null
     */
    public function getImportoInCentesimi()
    {
        return $this->ImportoInCentesimi;
    }
    /**
     * Set ImportoInCentesimi value
     * @param int $importoInCentesimi
     * @return \pagopa.efil\StructType\Accertamento
     */
    public function setImportoInCentesimi($importoInCentesimi = null)
    {
        // validation for constraint: int
        if (!is_null($importoInCentesimi) && !(is_int($importoInCentesimi) || ctype_digit($importoInCentesimi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($importoInCentesimi, true), gettype($importoInCentesimi)), __LINE__);
        }
        $this->ImportoInCentesimi = $importoInCentesimi;
        return $this;
    }
}
