<?php

namespace pagopa.efil\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rimuovi ServiceType
 * @subpackage Services
 */
class Rimuovi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RimuoviPosizione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \pagopa.efil\StructType\RimuoviPosizione $parameters
     * @return \pagopa.efil\StructType\RimuoviPosizioneResponse|bool
     */
    public function RimuoviPosizione(\pagopa.efil\StructType\RimuoviPosizione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RimuoviPosizione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \pagopa.efil\StructType\RimuoviPosizioneResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
