<?php

namespace pagopa.efil\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RipartizioneDiImportoInAccertamento StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RipartizioneDiImportoInAccertamento
 * @subpackage Structs
 */
class RipartizioneDiImportoInAccertamento extends AbstractStructBase
{
    /**
     * The Codice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Codice;
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The ImportoInCentesimi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ImportoInCentesimi;
    /**
     * The PeriodoDiRiferimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PeriodoDiRiferimento;
    /**
     * Constructor method for RipartizioneDiImportoInAccertamento
     * @uses RipartizioneDiImportoInAccertamento::setCodice()
     * @uses RipartizioneDiImportoInAccertamento::setDescrizione()
     * @uses RipartizioneDiImportoInAccertamento::setImportoInCentesimi()
     * @uses RipartizioneDiImportoInAccertamento::setPeriodoDiRiferimento()
     * @param string $codice
     * @param string $descrizione
     * @param int $importoInCentesimi
     * @param string $periodoDiRiferimento
     */
    public function __construct($codice = null, $descrizione = null, $importoInCentesimi = null, $periodoDiRiferimento = null)
    {
        $this
            ->setCodice($codice)
            ->setDescrizione($descrizione)
            ->setImportoInCentesimi($importoInCentesimi)
            ->setPeriodoDiRiferimento($periodoDiRiferimento);
    }
    /**
     * Get Codice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodice()
    {
        return isset($this->Codice) ? $this->Codice : null;
    }
    /**
     * Set Codice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codice
     * @return \pagopa.efil\StructType\RipartizioneDiImportoInAccertamento
     */
    public function setCodice($codice = null)
    {
        // validation for constraint: string
        if (!is_null($codice) && !is_string($codice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codice, true), gettype($codice)), __LINE__);
        }
        if (is_null($codice) || (is_array($codice) && empty($codice))) {
            unset($this->Codice);
        } else {
            $this->Codice = $codice;
        }
        return $this;
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \pagopa.efil\StructType\RipartizioneDiImportoInAccertamento
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get ImportoInCentesimi value
     * @return int|null
     */
    public function getImportoInCentesimi()
    {
        return $this->ImportoInCentesimi;
    }
    /**
     * Set ImportoInCentesimi value
     * @param int $importoInCentesimi
     * @return \pagopa.efil\StructType\RipartizioneDiImportoInAccertamento
     */
    public function setImportoInCentesimi($importoInCentesimi = null)
    {
        // validation for constraint: int
        if (!is_null($importoInCentesimi) && !(is_int($importoInCentesimi) || ctype_digit($importoInCentesimi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($importoInCentesimi, true), gettype($importoInCentesimi)), __LINE__);
        }
        $this->ImportoInCentesimi = $importoInCentesimi;
        return $this;
    }
    /**
     * Get PeriodoDiRiferimento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodoDiRiferimento()
    {
        return isset($this->PeriodoDiRiferimento) ? $this->PeriodoDiRiferimento : null;
    }
    /**
     * Set PeriodoDiRiferimento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodoDiRiferimento
     * @return \pagopa.efil\StructType\RipartizioneDiImportoInAccertamento
     */
    public function setPeriodoDiRiferimento($periodoDiRiferimento = null)
    {
        // validation for constraint: string
        if (!is_null($periodoDiRiferimento) && !is_string($periodoDiRiferimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodoDiRiferimento, true), gettype($periodoDiRiferimento)), __LINE__);
        }
        if (is_null($periodoDiRiferimento) || (is_array($periodoDiRiferimento) && empty($periodoDiRiferimento))) {
            unset($this->PeriodoDiRiferimento);
        } else {
            $this->PeriodoDiRiferimento = $periodoDiRiferimento;
        }
        return $this;
    }
}
