<?php

namespace pagopa.efil\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RichiestaRettificaPosizione StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RichiestaRettificaPosizione
 * @subpackage Structs
 */
class RichiestaRettificaPosizione extends FeedAuthenticatedRequestBase
{
    /**
     * The Causale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Causale;
    /**
     * The CodiceEnte
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodiceEnte;
    /**
     * The CodiceIdentificativo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodiceIdentificativo;
    /**
     * The DataScandenza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataScandenza;
    /**
     * The ImportoInCentesimi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ImportoInCentesimi;
    /**
     * The RipartizioniDiImporto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \pagopa.efil\ArrayType\ArrayOfRipartizioneDiImportoInAccertamento
     */
    public $RipartizioniDiImporto;
    /**
     * Constructor method for RichiestaRettificaPosizione
     * @uses RichiestaRettificaPosizione::setCausale()
     * @uses RichiestaRettificaPosizione::setCodiceEnte()
     * @uses RichiestaRettificaPosizione::setCodiceIdentificativo()
     * @uses RichiestaRettificaPosizione::setDataScandenza()
     * @uses RichiestaRettificaPosizione::setImportoInCentesimi()
     * @uses RichiestaRettificaPosizione::setRipartizioniDiImporto()
     * @param string $causale
     * @param string $codiceEnte
     * @param string $codiceIdentificativo
     * @param string $dataScandenza
     * @param int $importoInCentesimi
     * @param \pagopa.efil\ArrayType\ArrayOfRipartizioneDiImportoInAccertamento $ripartizioniDiImporto
     */
    public function __construct($causale = null, $codiceEnte = null, $codiceIdentificativo = null, $dataScandenza = null, $importoInCentesimi = null, \pagopa.efil\ArrayType\ArrayOfRipartizioneDiImportoInAccertamento $ripartizioniDiImporto = null)
    {
        $this
            ->setCausale($causale)
            ->setCodiceEnte($codiceEnte)
            ->setCodiceIdentificativo($codiceIdentificativo)
            ->setDataScandenza($dataScandenza)
            ->setImportoInCentesimi($importoInCentesimi)
            ->setRipartizioniDiImporto($ripartizioniDiImporto);
    }
    /**
     * Get Causale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCausale()
    {
        return isset($this->Causale) ? $this->Causale : null;
    }
    /**
     * Set Causale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $causale
     * @return \pagopa.efil\StructType\RichiestaRettificaPosizione
     */
    public function setCausale($causale = null)
    {
        // validation for constraint: string
        if (!is_null($causale) && !is_string($causale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($causale, true), gettype($causale)), __LINE__);
        }
        if (is_null($causale) || (is_array($causale) && empty($causale))) {
            unset($this->Causale);
        } else {
            $this->Causale = $causale;
        }
        return $this;
    }
    /**
     * Get CodiceEnte value
     * @return string|null
     */
    public function getCodiceEnte()
    {
        return $this->CodiceEnte;
    }
    /**
     * Set CodiceEnte value
     * @param string $codiceEnte
     * @return \pagopa.efil\StructType\RichiestaRettificaPosizione
     */
    public function setCodiceEnte($codiceEnte = null)
    {
        // validation for constraint: string
        if (!is_null($codiceEnte) && !is_string($codiceEnte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceEnte, true), gettype($codiceEnte)), __LINE__);
        }
        $this->CodiceEnte = $codiceEnte;
        return $this;
    }
    /**
     * Get CodiceIdentificativo value
     * @return string|null
     */
    public function getCodiceIdentificativo()
    {
        return $this->CodiceIdentificativo;
    }
    /**
     * Set CodiceIdentificativo value
     * @param string $codiceIdentificativo
     * @return \pagopa.efil\StructType\RichiestaRettificaPosizione
     */
    public function setCodiceIdentificativo($codiceIdentificativo = null)
    {
        // validation for constraint: string
        if (!is_null($codiceIdentificativo) && !is_string($codiceIdentificativo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceIdentificativo, true), gettype($codiceIdentificativo)), __LINE__);
        }
        $this->CodiceIdentificativo = $codiceIdentificativo;
        return $this;
    }
    /**
     * Get DataScandenza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataScandenza()
    {
        return isset($this->DataScandenza) ? $this->DataScandenza : null;
    }
    /**
     * Set DataScandenza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataScandenza
     * @return \pagopa.efil\StructType\RichiestaRettificaPosizione
     */
    public function setDataScandenza($dataScandenza = null)
    {
        // validation for constraint: string
        if (!is_null($dataScandenza) && !is_string($dataScandenza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataScandenza, true), gettype($dataScandenza)), __LINE__);
        }
        if (is_null($dataScandenza) || (is_array($dataScandenza) && empty($dataScandenza))) {
            unset($this->DataScandenza);
        } else {
            $this->DataScandenza = $dataScandenza;
        }
        return $this;
    }
    /**
     * Get ImportoInCentesimi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getImportoInCentesimi()
    {
        return isset($this->ImportoInCentesimi) ? $this->ImportoInCentesimi : null;
    }
    /**
     * Set ImportoInCentesimi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $importoInCentesimi
     * @return \pagopa.efil\StructType\RichiestaRettificaPosizione
     */
    public function setImportoInCentesimi($importoInCentesimi = null)
    {
        // validation for constraint: int
        if (!is_null($importoInCentesimi) && !(is_int($importoInCentesimi) || ctype_digit($importoInCentesimi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($importoInCentesimi, true), gettype($importoInCentesimi)), __LINE__);
        }
        if (is_null($importoInCentesimi) || (is_array($importoInCentesimi) && empty($importoInCentesimi))) {
            unset($this->ImportoInCentesimi);
        } else {
            $this->ImportoInCentesimi = $importoInCentesimi;
        }
        return $this;
    }
    /**
     * Get RipartizioniDiImporto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \pagopa.efil\ArrayType\ArrayOfRipartizioneDiImportoInAccertamento|null
     */
    public function getRipartizioniDiImporto()
    {
        return isset($this->RipartizioniDiImporto) ? $this->RipartizioniDiImporto : null;
    }
    /**
     * Set RipartizioniDiImporto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \pagopa.efil\ArrayType\ArrayOfRipartizioneDiImportoInAccertamento $ripartizioniDiImporto
     * @return \pagopa.efil\StructType\RichiestaRettificaPosizione
     */
    public function setRipartizioniDiImporto(\pagopa.efil\ArrayType\ArrayOfRipartizioneDiImportoInAccertamento $ripartizioniDiImporto = null)
    {
        if (is_null($ripartizioniDiImporto) || (is_array($ripartizioniDiImporto) && empty($ripartizioniDiImporto))) {
            unset($this->RipartizioniDiImporto);
        } else {
            $this->RipartizioniDiImporto = $ripartizioniDiImporto;
        }
        return $this;
    }
}
