<?php

namespace pagopa.efil\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Posizione StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Posizione
 * @subpackage Structs
 */
class Posizione extends AbstractStructBase
{
    /**
     * The Accertamenti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \pagopa.efil\ArrayType\ArrayOfAccertamento
     */
    public $Accertamenti;
    /**
     * The Causale
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Causale;
    /**
     * The CodiceRiferimentoCreditore
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodiceRiferimentoCreditore;
    /**
     * The Creditore
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \pagopa.efil\StructType\Creditore
     */
    public $Creditore;
    /**
     * The DataScadenza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataScadenza;
    /**
     * The Debitore
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \pagopa.efil\StructType\Debitore
     */
    public $Debitore;
    /**
     * The IdentificativoPosizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentificativoPosizione;
    /**
     * The ImportoInCentesimi
     * @var int
     */
    public $ImportoInCentesimi;
    /**
     * The ParametriPosizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \pagopa.efil\ArrayType\ArrayOfParametroPosizione
     */
    public $ParametriPosizione;
    /**
     * The Servizio
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \pagopa.efil\StructType\Servizio
     */
    public $Servizio;
    /**
     * The TipoRiferimentoCreditore
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TipoRiferimentoCreditore;
    /**
     * Constructor method for Posizione
     * @uses Posizione::setAccertamenti()
     * @uses Posizione::setCausale()
     * @uses Posizione::setCodiceRiferimentoCreditore()
     * @uses Posizione::setCreditore()
     * @uses Posizione::setDataScadenza()
     * @uses Posizione::setDebitore()
     * @uses Posizione::setIdentificativoPosizione()
     * @uses Posizione::setImportoInCentesimi()
     * @uses Posizione::setParametriPosizione()
     * @uses Posizione::setServizio()
     * @uses Posizione::setTipoRiferimentoCreditore()
     * @param \pagopa.efil\ArrayType\ArrayOfAccertamento $accertamenti
     * @param string $causale
     * @param string $codiceRiferimentoCreditore
     * @param \pagopa.efil\StructType\Creditore $creditore
     * @param string $dataScadenza
     * @param \pagopa.efil\StructType\Debitore $debitore
     * @param string $identificativoPosizione
     * @param int $importoInCentesimi
     * @param \pagopa.efil\ArrayType\ArrayOfParametroPosizione $parametriPosizione
     * @param \pagopa.efil\StructType\Servizio $servizio
     * @param string $tipoRiferimentoCreditore
     */
    public function __construct(\pagopa.efil\ArrayType\ArrayOfAccertamento $accertamenti = null, $causale = null, $codiceRiferimentoCreditore = null, \pagopa.efil\StructType\Creditore $creditore = null, $dataScadenza = null, \pagopa.efil\StructType\Debitore $debitore = null, $identificativoPosizione = null, $importoInCentesimi = null, \pagopa.efil\ArrayType\ArrayOfParametroPosizione $parametriPosizione = null, \pagopa.efil\StructType\Servizio $servizio = null, $tipoRiferimentoCreditore = null)
    {
        $this
            ->setAccertamenti($accertamenti)
            ->setCausale($causale)
            ->setCodiceRiferimentoCreditore($codiceRiferimentoCreditore)
            ->setCreditore($creditore)
            ->setDataScadenza($dataScadenza)
            ->setDebitore($debitore)
            ->setIdentificativoPosizione($identificativoPosizione)
            ->setImportoInCentesimi($importoInCentesimi)
            ->setParametriPosizione($parametriPosizione)
            ->setServizio($servizio)
            ->setTipoRiferimentoCreditore($tipoRiferimentoCreditore);
    }
    /**
     * Get Accertamenti value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \pagopa.efil\ArrayType\ArrayOfAccertamento|null
     */
    public function getAccertamenti()
    {
        return isset($this->Accertamenti) ? $this->Accertamenti : null;
    }
    /**
     * Set Accertamenti value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \pagopa.efil\ArrayType\ArrayOfAccertamento $accertamenti
     * @return \pagopa.efil\StructType\Posizione
     */
    public function setAccertamenti(\pagopa.efil\ArrayType\ArrayOfAccertamento $accertamenti = null)
    {
        if (is_null($accertamenti) || (is_array($accertamenti) && empty($accertamenti))) {
            unset($this->Accertamenti);
        } else {
            $this->Accertamenti = $accertamenti;
        }
        return $this;
    }
    /**
     * Get Causale value
     * @return string|null
     */
    public function getCausale()
    {
        return $this->Causale;
    }
    /**
     * Set Causale value
     * @param string $causale
     * @return \pagopa.efil\StructType\Posizione
     */
    public function setCausale($causale = null)
    {
        // validation for constraint: string
        if (!is_null($causale) && !is_string($causale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($causale, true), gettype($causale)), __LINE__);
        }
        $this->Causale = $causale;
        return $this;
    }
    /**
     * Get CodiceRiferimentoCreditore value
     * @return string|null
     */
    public function getCodiceRiferimentoCreditore()
    {
        return $this->CodiceRiferimentoCreditore;
    }
    /**
     * Set CodiceRiferimentoCreditore value
     * @param string $codiceRiferimentoCreditore
     * @return \pagopa.efil\StructType\Posizione
     */
    public function setCodiceRiferimentoCreditore($codiceRiferimentoCreditore = null)
    {
        // validation for constraint: string
        if (!is_null($codiceRiferimentoCreditore) && !is_string($codiceRiferimentoCreditore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceRiferimentoCreditore, true), gettype($codiceRiferimentoCreditore)), __LINE__);
        }
        $this->CodiceRiferimentoCreditore = $codiceRiferimentoCreditore;
        return $this;
    }
    /**
     * Get Creditore value
     * @return \pagopa.efil\StructType\Creditore|null
     */
    public function getCreditore()
    {
        return $this->Creditore;
    }
    /**
     * Set Creditore value
     * @param \pagopa.efil\StructType\Creditore $creditore
     * @return \pagopa.efil\StructType\Posizione
     */
    public function setCreditore(\pagopa.efil\StructType\Creditore $creditore = null)
    {
        $this->Creditore = $creditore;
        return $this;
    }
    /**
     * Get DataScadenza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataScadenza()
    {
        return isset($this->DataScadenza) ? $this->DataScadenza : null;
    }
    /**
     * Set DataScadenza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataScadenza
     * @return \pagopa.efil\StructType\Posizione
     */
    public function setDataScadenza($dataScadenza = null)
    {
        // validation for constraint: string
        if (!is_null($dataScadenza) && !is_string($dataScadenza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataScadenza, true), gettype($dataScadenza)), __LINE__);
        }
        if (is_null($dataScadenza) || (is_array($dataScadenza) && empty($dataScadenza))) {
            unset($this->DataScadenza);
        } else {
            $this->DataScadenza = $dataScadenza;
        }
        return $this;
    }
    /**
     * Get Debitore value
     * @return \pagopa.efil\StructType\Debitore|null
     */
    public function getDebitore()
    {
        return $this->Debitore;
    }
    /**
     * Set Debitore value
     * @param \pagopa.efil\StructType\Debitore $debitore
     * @return \pagopa.efil\StructType\Posizione
     */
    public function setDebitore(\pagopa.efil\StructType\Debitore $debitore = null)
    {
        $this->Debitore = $debitore;
        return $this;
    }
    /**
     * Get IdentificativoPosizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificativoPosizione()
    {
        return isset($this->IdentificativoPosizione) ? $this->IdentificativoPosizione : null;
    }
    /**
     * Set IdentificativoPosizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificativoPosizione
     * @return \pagopa.efil\StructType\Posizione
     */
    public function setIdentificativoPosizione($identificativoPosizione = null)
    {
        // validation for constraint: string
        if (!is_null($identificativoPosizione) && !is_string($identificativoPosizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificativoPosizione, true), gettype($identificativoPosizione)), __LINE__);
        }
        if (is_null($identificativoPosizione) || (is_array($identificativoPosizione) && empty($identificativoPosizione))) {
            unset($this->IdentificativoPosizione);
        } else {
            $this->IdentificativoPosizione = $identificativoPosizione;
        }
        return $this;
    }
    /**
     * Get ImportoInCentesimi value
     * @return int|null
     */
    public function getImportoInCentesimi()
    {
        return $this->ImportoInCentesimi;
    }
    /**
     * Set ImportoInCentesimi value
     * @param int $importoInCentesimi
     * @return \pagopa.efil\StructType\Posizione
     */
    public function setImportoInCentesimi($importoInCentesimi = null)
    {
        // validation for constraint: int
        if (!is_null($importoInCentesimi) && !(is_int($importoInCentesimi) || ctype_digit($importoInCentesimi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($importoInCentesimi, true), gettype($importoInCentesimi)), __LINE__);
        }
        $this->ImportoInCentesimi = $importoInCentesimi;
        return $this;
    }
    /**
     * Get ParametriPosizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \pagopa.efil\ArrayType\ArrayOfParametroPosizione|null
     */
    public function getParametriPosizione()
    {
        return isset($this->ParametriPosizione) ? $this->ParametriPosizione : null;
    }
    /**
     * Set ParametriPosizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \pagopa.efil\ArrayType\ArrayOfParametroPosizione $parametriPosizione
     * @return \pagopa.efil\StructType\Posizione
     */
    public function setParametriPosizione(\pagopa.efil\ArrayType\ArrayOfParametroPosizione $parametriPosizione = null)
    {
        if (is_null($parametriPosizione) || (is_array($parametriPosizione) && empty($parametriPosizione))) {
            unset($this->ParametriPosizione);
        } else {
            $this->ParametriPosizione = $parametriPosizione;
        }
        return $this;
    }
    /**
     * Get Servizio value
     * @return \pagopa.efil\StructType\Servizio|null
     */
    public function getServizio()
    {
        return $this->Servizio;
    }
    /**
     * Set Servizio value
     * @param \pagopa.efil\StructType\Servizio $servizio
     * @return \pagopa.efil\StructType\Posizione
     */
    public function setServizio(\pagopa.efil\StructType\Servizio $servizio = null)
    {
        $this->Servizio = $servizio;
        return $this;
    }
    /**
     * Get TipoRiferimentoCreditore value
     * @return string|null
     */
    public function getTipoRiferimentoCreditore()
    {
        return $this->TipoRiferimentoCreditore;
    }
    /**
     * Set TipoRiferimentoCreditore value
     * @param string $tipoRiferimentoCreditore
     * @return \pagopa.efil\StructType\Posizione
     */
    public function setTipoRiferimentoCreditore($tipoRiferimentoCreditore = null)
    {
        // validation for constraint: string
        if (!is_null($tipoRiferimentoCreditore) && !is_string($tipoRiferimentoCreditore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoRiferimentoCreditore, true), gettype($tipoRiferimentoCreditore)), __LINE__);
        }
        $this->TipoRiferimentoCreditore = $tipoRiferimentoCreditore;
        return $this;
    }
}
