<?php

namespace pagopa.efil\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Debitore StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Debitore
 * @subpackage Structs
 */
class Debitore extends AbstractStructBase
{
    /**
     * The Cellulare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cellulare;
    /**
     * The Civico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Civico;
    /**
     * The CodiceAvviamentoPostale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceAvviamentoPostale;
    /**
     * The CodiceFiscalePartitaIva
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodiceFiscalePartitaIva;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Indirizzo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Indirizzo;
    /**
     * The Localita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Localita;
    /**
     * The Nazione
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \pagopa.efil\StructType\Nazione
     */
    public $Nazione;
    /**
     * The Nominativo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Nominativo;
    /**
     * The Provincia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provincia;
    /**
     * The TipoPagatore
     * @var string
     */
    public $TipoPagatore;
    /**
     * Constructor method for Debitore
     * @uses Debitore::setCellulare()
     * @uses Debitore::setCivico()
     * @uses Debitore::setCodiceAvviamentoPostale()
     * @uses Debitore::setCodiceFiscalePartitaIva()
     * @uses Debitore::setEmail()
     * @uses Debitore::setIndirizzo()
     * @uses Debitore::setLocalita()
     * @uses Debitore::setNazione()
     * @uses Debitore::setNominativo()
     * @uses Debitore::setProvincia()
     * @uses Debitore::setTipoPagatore()
     * @param string $cellulare
     * @param string $civico
     * @param string $codiceAvviamentoPostale
     * @param string $codiceFiscalePartitaIva
     * @param string $email
     * @param string $indirizzo
     * @param string $localita
     * @param \pagopa.efil\StructType\Nazione $nazione
     * @param string $nominativo
     * @param string $provincia
     * @param string $tipoPagatore
     */
    public function __construct($cellulare = null, $civico = null, $codiceAvviamentoPostale = null, $codiceFiscalePartitaIva = null, $email = null, $indirizzo = null, $localita = null, \pagopa.efil\StructType\Nazione $nazione = null, $nominativo = null, $provincia = null, $tipoPagatore = null)
    {
        $this
            ->setCellulare($cellulare)
            ->setCivico($civico)
            ->setCodiceAvviamentoPostale($codiceAvviamentoPostale)
            ->setCodiceFiscalePartitaIva($codiceFiscalePartitaIva)
            ->setEmail($email)
            ->setIndirizzo($indirizzo)
            ->setLocalita($localita)
            ->setNazione($nazione)
            ->setNominativo($nominativo)
            ->setProvincia($provincia)
            ->setTipoPagatore($tipoPagatore);
    }
    /**
     * Get Cellulare value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCellulare()
    {
        return isset($this->Cellulare) ? $this->Cellulare : null;
    }
    /**
     * Set Cellulare value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cellulare
     * @return \pagopa.efil\StructType\Debitore
     */
    public function setCellulare($cellulare = null)
    {
        // validation for constraint: string
        if (!is_null($cellulare) && !is_string($cellulare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cellulare, true), gettype($cellulare)), __LINE__);
        }
        if (is_null($cellulare) || (is_array($cellulare) && empty($cellulare))) {
            unset($this->Cellulare);
        } else {
            $this->Cellulare = $cellulare;
        }
        return $this;
    }
    /**
     * Get Civico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCivico()
    {
        return isset($this->Civico) ? $this->Civico : null;
    }
    /**
     * Set Civico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $civico
     * @return \pagopa.efil\StructType\Debitore
     */
    public function setCivico($civico = null)
    {
        // validation for constraint: string
        if (!is_null($civico) && !is_string($civico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($civico, true), gettype($civico)), __LINE__);
        }
        if (is_null($civico) || (is_array($civico) && empty($civico))) {
            unset($this->Civico);
        } else {
            $this->Civico = $civico;
        }
        return $this;
    }
    /**
     * Get CodiceAvviamentoPostale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceAvviamentoPostale()
    {
        return isset($this->CodiceAvviamentoPostale) ? $this->CodiceAvviamentoPostale : null;
    }
    /**
     * Set CodiceAvviamentoPostale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceAvviamentoPostale
     * @return \pagopa.efil\StructType\Debitore
     */
    public function setCodiceAvviamentoPostale($codiceAvviamentoPostale = null)
    {
        // validation for constraint: string
        if (!is_null($codiceAvviamentoPostale) && !is_string($codiceAvviamentoPostale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceAvviamentoPostale, true), gettype($codiceAvviamentoPostale)), __LINE__);
        }
        if (is_null($codiceAvviamentoPostale) || (is_array($codiceAvviamentoPostale) && empty($codiceAvviamentoPostale))) {
            unset($this->CodiceAvviamentoPostale);
        } else {
            $this->CodiceAvviamentoPostale = $codiceAvviamentoPostale;
        }
        return $this;
    }
    /**
     * Get CodiceFiscalePartitaIva value
     * @return string|null
     */
    public function getCodiceFiscalePartitaIva()
    {
        return $this->CodiceFiscalePartitaIva;
    }
    /**
     * Set CodiceFiscalePartitaIva value
     * @param string $codiceFiscalePartitaIva
     * @return \pagopa.efil\StructType\Debitore
     */
    public function setCodiceFiscalePartitaIva($codiceFiscalePartitaIva = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscalePartitaIva) && !is_string($codiceFiscalePartitaIva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceFiscalePartitaIva, true), gettype($codiceFiscalePartitaIva)), __LINE__);
        }
        $this->CodiceFiscalePartitaIva = $codiceFiscalePartitaIva;
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \pagopa.efil\StructType\Debitore
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Indirizzo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndirizzo()
    {
        return isset($this->Indirizzo) ? $this->Indirizzo : null;
    }
    /**
     * Set Indirizzo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $indirizzo
     * @return \pagopa.efil\StructType\Debitore
     */
    public function setIndirizzo($indirizzo = null)
    {
        // validation for constraint: string
        if (!is_null($indirizzo) && !is_string($indirizzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indirizzo, true), gettype($indirizzo)), __LINE__);
        }
        if (is_null($indirizzo) || (is_array($indirizzo) && empty($indirizzo))) {
            unset($this->Indirizzo);
        } else {
            $this->Indirizzo = $indirizzo;
        }
        return $this;
    }
    /**
     * Get Localita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalita()
    {
        return isset($this->Localita) ? $this->Localita : null;
    }
    /**
     * Set Localita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localita
     * @return \pagopa.efil\StructType\Debitore
     */
    public function setLocalita($localita = null)
    {
        // validation for constraint: string
        if (!is_null($localita) && !is_string($localita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localita, true), gettype($localita)), __LINE__);
        }
        if (is_null($localita) || (is_array($localita) && empty($localita))) {
            unset($this->Localita);
        } else {
            $this->Localita = $localita;
        }
        return $this;
    }
    /**
     * Get Nazione value
     * @return \pagopa.efil\StructType\Nazione|null
     */
    public function getNazione()
    {
        return $this->Nazione;
    }
    /**
     * Set Nazione value
     * @param \pagopa.efil\StructType\Nazione $nazione
     * @return \pagopa.efil\StructType\Debitore
     */
    public function setNazione(\pagopa.efil\StructType\Nazione $nazione = null)
    {
        $this->Nazione = $nazione;
        return $this;
    }
    /**
     * Get Nominativo value
     * @return string|null
     */
    public function getNominativo()
    {
        return $this->Nominativo;
    }
    /**
     * Set Nominativo value
     * @param string $nominativo
     * @return \pagopa.efil\StructType\Debitore
     */
    public function setNominativo($nominativo = null)
    {
        // validation for constraint: string
        if (!is_null($nominativo) && !is_string($nominativo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nominativo, true), gettype($nominativo)), __LINE__);
        }
        $this->Nominativo = $nominativo;
        return $this;
    }
    /**
     * Get Provincia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvincia()
    {
        return isset($this->Provincia) ? $this->Provincia : null;
    }
    /**
     * Set Provincia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provincia
     * @return \pagopa.efil\StructType\Debitore
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        if (is_null($provincia) || (is_array($provincia) && empty($provincia))) {
            unset($this->Provincia);
        } else {
            $this->Provincia = $provincia;
        }
        return $this;
    }
    /**
     * Get TipoPagatore value
     * @return string|null
     */
    public function getTipoPagatore()
    {
        return $this->TipoPagatore;
    }
    /**
     * Set TipoPagatore value
     * @uses \pagopa.efil\EnumType\TipoPagatore::valueIsValid()
     * @uses \pagopa.efil\EnumType\TipoPagatore::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoPagatore
     * @return \pagopa.efil\StructType\Debitore
     */
    public function setTipoPagatore($tipoPagatore = null)
    {
        // validation for constraint: enumeration
        if (!\pagopa.efil\EnumType\TipoPagatore::valueIsValid($tipoPagatore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \pagopa.efil\EnumType\TipoPagatore', is_array($tipoPagatore) ? implode(', ', $tipoPagatore) : var_export($tipoPagatore, true), implode(', ', \pagopa.efil\EnumType\TipoPagatore::getValidValues())), __LINE__);
        }
        $this->TipoPagatore = $tipoPagatore;
        return $this;
    }
}
