<?php

namespace pagopa.efil\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatiPagamento StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DatiPagamento
 * @subpackage Structs
 */
class DatiPagamento extends AbstractStructBase
{
    /**
     * The CodiceEsitoSingoloPagamento
     * @var int
     */
    public $CodiceEsitoSingoloPagamento;
    /**
     * The DataPagamento
     * @var string
     */
    public $DataPagamento;
    /**
     * The DataRegolamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataRegolamento;
    /**
     * The DenominazioneAttestante
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DenominazioneAttestante;
    /**
     * The IdentificativoAttestante
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IdentificativoAttestante;
    /**
     * The IdentificativoFlusso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentificativoFlusso;
    /**
     * The IdentificativoIntermediario
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IdentificativoIntermediario;
    /**
     * The IdentificativoUnivocoRiscossione
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IdentificativoUnivocoRiscossione;
    /**
     * The ImportoPagatoInCentesimi
     * @var int
     */
    public $ImportoPagatoInCentesimi;
    /**
     * The ModalitaDiPagamento
     * @var int
     */
    public $ModalitaDiPagamento;
    /**
     * The RicevutaTelematica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RicevutaTelematica;
    /**
     * Constructor method for DatiPagamento
     * @uses DatiPagamento::setCodiceEsitoSingoloPagamento()
     * @uses DatiPagamento::setDataPagamento()
     * @uses DatiPagamento::setDataRegolamento()
     * @uses DatiPagamento::setDenominazioneAttestante()
     * @uses DatiPagamento::setIdentificativoAttestante()
     * @uses DatiPagamento::setIdentificativoFlusso()
     * @uses DatiPagamento::setIdentificativoIntermediario()
     * @uses DatiPagamento::setIdentificativoUnivocoRiscossione()
     * @uses DatiPagamento::setImportoPagatoInCentesimi()
     * @uses DatiPagamento::setModalitaDiPagamento()
     * @uses DatiPagamento::setRicevutaTelematica()
     * @param int $codiceEsitoSingoloPagamento
     * @param string $dataPagamento
     * @param string $dataRegolamento
     * @param string $denominazioneAttestante
     * @param string $identificativoAttestante
     * @param string $identificativoFlusso
     * @param string $identificativoIntermediario
     * @param string $identificativoUnivocoRiscossione
     * @param int $importoPagatoInCentesimi
     * @param int $modalitaDiPagamento
     * @param string $ricevutaTelematica
     */
    public function __construct($codiceEsitoSingoloPagamento = null, $dataPagamento = null, $dataRegolamento = null, $denominazioneAttestante = null, $identificativoAttestante = null, $identificativoFlusso = null, $identificativoIntermediario = null, $identificativoUnivocoRiscossione = null, $importoPagatoInCentesimi = null, $modalitaDiPagamento = null, $ricevutaTelematica = null)
    {
        $this
            ->setCodiceEsitoSingoloPagamento($codiceEsitoSingoloPagamento)
            ->setDataPagamento($dataPagamento)
            ->setDataRegolamento($dataRegolamento)
            ->setDenominazioneAttestante($denominazioneAttestante)
            ->setIdentificativoAttestante($identificativoAttestante)
            ->setIdentificativoFlusso($identificativoFlusso)
            ->setIdentificativoIntermediario($identificativoIntermediario)
            ->setIdentificativoUnivocoRiscossione($identificativoUnivocoRiscossione)
            ->setImportoPagatoInCentesimi($importoPagatoInCentesimi)
            ->setModalitaDiPagamento($modalitaDiPagamento)
            ->setRicevutaTelematica($ricevutaTelematica);
    }
    /**
     * Get CodiceEsitoSingoloPagamento value
     * @return int|null
     */
    public function getCodiceEsitoSingoloPagamento()
    {
        return $this->CodiceEsitoSingoloPagamento;
    }
    /**
     * Set CodiceEsitoSingoloPagamento value
     * @param int $codiceEsitoSingoloPagamento
     * @return \pagopa.efil\StructType\DatiPagamento
     */
    public function setCodiceEsitoSingoloPagamento($codiceEsitoSingoloPagamento = null)
    {
        // validation for constraint: int
        if (!is_null($codiceEsitoSingoloPagamento) && !(is_int($codiceEsitoSingoloPagamento) || ctype_digit($codiceEsitoSingoloPagamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codiceEsitoSingoloPagamento, true), gettype($codiceEsitoSingoloPagamento)), __LINE__);
        }
        $this->CodiceEsitoSingoloPagamento = $codiceEsitoSingoloPagamento;
        return $this;
    }
    /**
     * Get DataPagamento value
     * @return string|null
     */
    public function getDataPagamento()
    {
        return $this->DataPagamento;
    }
    /**
     * Set DataPagamento value
     * @param string $dataPagamento
     * @return \pagopa.efil\StructType\DatiPagamento
     */
    public function setDataPagamento($dataPagamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataPagamento) && !is_string($dataPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataPagamento, true), gettype($dataPagamento)), __LINE__);
        }
        $this->DataPagamento = $dataPagamento;
        return $this;
    }
    /**
     * Get DataRegolamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataRegolamento()
    {
        return isset($this->DataRegolamento) ? $this->DataRegolamento : null;
    }
    /**
     * Set DataRegolamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataRegolamento
     * @return \pagopa.efil\StructType\DatiPagamento
     */
    public function setDataRegolamento($dataRegolamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataRegolamento) && !is_string($dataRegolamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRegolamento, true), gettype($dataRegolamento)), __LINE__);
        }
        if (is_null($dataRegolamento) || (is_array($dataRegolamento) && empty($dataRegolamento))) {
            unset($this->DataRegolamento);
        } else {
            $this->DataRegolamento = $dataRegolamento;
        }
        return $this;
    }
    /**
     * Get DenominazioneAttestante value
     * @return string|null
     */
    public function getDenominazioneAttestante()
    {
        return $this->DenominazioneAttestante;
    }
    /**
     * Set DenominazioneAttestante value
     * @param string $denominazioneAttestante
     * @return \pagopa.efil\StructType\DatiPagamento
     */
    public function setDenominazioneAttestante($denominazioneAttestante = null)
    {
        // validation for constraint: string
        if (!is_null($denominazioneAttestante) && !is_string($denominazioneAttestante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($denominazioneAttestante, true), gettype($denominazioneAttestante)), __LINE__);
        }
        $this->DenominazioneAttestante = $denominazioneAttestante;
        return $this;
    }
    /**
     * Get IdentificativoAttestante value
     * @return string|null
     */
    public function getIdentificativoAttestante()
    {
        return $this->IdentificativoAttestante;
    }
    /**
     * Set IdentificativoAttestante value
     * @param string $identificativoAttestante
     * @return \pagopa.efil\StructType\DatiPagamento
     */
    public function setIdentificativoAttestante($identificativoAttestante = null)
    {
        // validation for constraint: string
        if (!is_null($identificativoAttestante) && !is_string($identificativoAttestante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificativoAttestante, true), gettype($identificativoAttestante)), __LINE__);
        }
        $this->IdentificativoAttestante = $identificativoAttestante;
        return $this;
    }
    /**
     * Get IdentificativoFlusso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificativoFlusso()
    {
        return isset($this->IdentificativoFlusso) ? $this->IdentificativoFlusso : null;
    }
    /**
     * Set IdentificativoFlusso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificativoFlusso
     * @return \pagopa.efil\StructType\DatiPagamento
     */
    public function setIdentificativoFlusso($identificativoFlusso = null)
    {
        // validation for constraint: string
        if (!is_null($identificativoFlusso) && !is_string($identificativoFlusso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificativoFlusso, true), gettype($identificativoFlusso)), __LINE__);
        }
        if (is_null($identificativoFlusso) || (is_array($identificativoFlusso) && empty($identificativoFlusso))) {
            unset($this->IdentificativoFlusso);
        } else {
            $this->IdentificativoFlusso = $identificativoFlusso;
        }
        return $this;
    }
    /**
     * Get IdentificativoIntermediario value
     * @return string|null
     */
    public function getIdentificativoIntermediario()
    {
        return $this->IdentificativoIntermediario;
    }
    /**
     * Set IdentificativoIntermediario value
     * @param string $identificativoIntermediario
     * @return \pagopa.efil\StructType\DatiPagamento
     */
    public function setIdentificativoIntermediario($identificativoIntermediario = null)
    {
        // validation for constraint: string
        if (!is_null($identificativoIntermediario) && !is_string($identificativoIntermediario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificativoIntermediario, true), gettype($identificativoIntermediario)), __LINE__);
        }
        $this->IdentificativoIntermediario = $identificativoIntermediario;
        return $this;
    }
    /**
     * Get IdentificativoUnivocoRiscossione value
     * @return string|null
     */
    public function getIdentificativoUnivocoRiscossione()
    {
        return $this->IdentificativoUnivocoRiscossione;
    }
    /**
     * Set IdentificativoUnivocoRiscossione value
     * @param string $identificativoUnivocoRiscossione
     * @return \pagopa.efil\StructType\DatiPagamento
     */
    public function setIdentificativoUnivocoRiscossione($identificativoUnivocoRiscossione = null)
    {
        // validation for constraint: string
        if (!is_null($identificativoUnivocoRiscossione) && !is_string($identificativoUnivocoRiscossione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificativoUnivocoRiscossione, true), gettype($identificativoUnivocoRiscossione)), __LINE__);
        }
        $this->IdentificativoUnivocoRiscossione = $identificativoUnivocoRiscossione;
        return $this;
    }
    /**
     * Get ImportoPagatoInCentesimi value
     * @return int|null
     */
    public function getImportoPagatoInCentesimi()
    {
        return $this->ImportoPagatoInCentesimi;
    }
    /**
     * Set ImportoPagatoInCentesimi value
     * @param int $importoPagatoInCentesimi
     * @return \pagopa.efil\StructType\DatiPagamento
     */
    public function setImportoPagatoInCentesimi($importoPagatoInCentesimi = null)
    {
        // validation for constraint: int
        if (!is_null($importoPagatoInCentesimi) && !(is_int($importoPagatoInCentesimi) || ctype_digit($importoPagatoInCentesimi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($importoPagatoInCentesimi, true), gettype($importoPagatoInCentesimi)), __LINE__);
        }
        $this->ImportoPagatoInCentesimi = $importoPagatoInCentesimi;
        return $this;
    }
    /**
     * Get ModalitaDiPagamento value
     * @return int|null
     */
    public function getModalitaDiPagamento()
    {
        return $this->ModalitaDiPagamento;
    }
    /**
     * Set ModalitaDiPagamento value
     * @param int $modalitaDiPagamento
     * @return \pagopa.efil\StructType\DatiPagamento
     */
    public function setModalitaDiPagamento($modalitaDiPagamento = null)
    {
        // validation for constraint: int
        if (!is_null($modalitaDiPagamento) && !(is_int($modalitaDiPagamento) || ctype_digit($modalitaDiPagamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modalitaDiPagamento, true), gettype($modalitaDiPagamento)), __LINE__);
        }
        $this->ModalitaDiPagamento = $modalitaDiPagamento;
        return $this;
    }
    /**
     * Get RicevutaTelematica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRicevutaTelematica()
    {
        return isset($this->RicevutaTelematica) ? $this->RicevutaTelematica : null;
    }
    /**
     * Set RicevutaTelematica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ricevutaTelematica
     * @return \pagopa.efil\StructType\DatiPagamento
     */
    public function setRicevutaTelematica($ricevutaTelematica = null)
    {
        // validation for constraint: string
        if (!is_null($ricevutaTelematica) && !is_string($ricevutaTelematica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ricevutaTelematica, true), gettype($ricevutaTelematica)), __LINE__);
        }
        if (is_null($ricevutaTelematica) || (is_array($ricevutaTelematica) && empty($ricevutaTelematica))) {
            unset($this->RicevutaTelematica);
        } else {
            $this->RicevutaTelematica = $ricevutaTelematica;
        }
        return $this;
    }
}
