<?php

namespace pagopa.efil\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Carica ServiceType
 * @subpackage Services
 */
class Carica extends AbstractSoapClientBase
{
    /**
     * Sets the IdApplicazione SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $idApplicazione
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderIdApplicazione($idApplicazione, $nameSpace = 'http://e-fil.eu/PnP/PlugAndPayFeed', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'IdApplicazione', $idApplicazione, $mustUnderstand, $actor);
    }
    /**
     * Sets the UserName SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $userName
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserName($userName, $nameSpace = 'http://e-fil.eu/PnP/PlugAndPayFeed', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserName', $userName, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CaricaPosizione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \pagopa.efil\StructType\CaricaPosizione $parameters
     * @return \pagopa.efil\StructType\CaricaPosizioneResponse|bool
     */
    public function CaricaPosizione(\pagopa.efil\StructType\CaricaPosizione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CaricaPosizione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CaricaPosizioneConEsitoArricchito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \pagopa.efil\StructType\CaricaPosizioneConEsitoArricchito $parameters
     * @return \pagopa.efil\StructType\CaricaPosizioneConEsitoArricchitoResponse|bool
     */
    public function CaricaPosizioneConEsitoArricchito(\pagopa.efil\StructType\CaricaPosizioneConEsitoArricchito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CaricaPosizioneConEsitoArricchito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CaricaPosizioni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \pagopa.efil\StructType\CaricaPosizioni $parameters
     * @return \pagopa.efil\StructType\CaricaPosizioniResponse|bool
     */
    public function CaricaPosizioni(\pagopa.efil\StructType\CaricaPosizioni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CaricaPosizioni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CaricaPosizionePagata
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: IdApplicazione, UserName
     * - SOAPHeaderNamespaces: http://e-fil.eu/PnP/PlugAndPayFeed, http://e-fil.eu/PnP/PlugAndPayFeed
     * - SOAPHeaderTypes: string, string
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \pagopa.efil\StructType\PosizionePagata $posizionePagata
     * @return \pagopa.efil\StructType\RispostaCaricaPosizionePagataMessageBody|bool
     */
    public function CaricaPosizionePagata(\pagopa.efil\StructType\PosizionePagata $posizionePagata)
    {
        try {
            $this->setResult($this->getSoapClient()->CaricaPosizionePagata($posizionePagata));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \pagopa.efil\StructType\CaricaPosizioneConEsitoArricchitoResponse|\pagopa.efil\StructType\CaricaPosizioneResponse|\pagopa.efil\StructType\CaricaPosizioniResponse|\pagopa.efil\StructType\RispostaCaricaPosizionePagataMessageBody
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
