<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Heart ServiceType
 * @subpackage Services
 */
class Heart extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HeartBeat
     * Meta information extracted from the WSDL
     * - documentation: Checks whether the service is alive.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HeartBeat $parameters
     * @return \StructType\HeartBeatResponse|bool
     */
    public function HeartBeat(\StructType\HeartBeat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HeartBeat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HeartBeatResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
