<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://services-qa.8tech.co.uk/lms/lms.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://services-qa.8tech.co.uk/lms/lms.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Heart ServiceType
 */
$heart = new \ServiceType\Heart($options);
/**
 * Sample call for HeartBeat operation/method
 */
if ($heart->HeartBeat(new \StructType\HeartBeat()) !== false) {
    print_r($heart->getResult());
} else {
    print_r($heart->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddLead operation/method
 */
if ($add->AddLead(new \StructType\AddLead()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddLeadI4U operation/method
 */
if ($add->AddLeadI4U(new \StructType\AddLeadI4U()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddLeadToDataHub operation/method
 */
if ($add->AddLeadToDataHub(new \StructType\AddLeadToDataHub()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddLeadToDealerwebByPassDataHub operation/method
 */
if ($add->AddLeadToDealerwebByPassDataHub(new \StructType\AddLeadToDealerwebByPassDataHub()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
