<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddLead
     * Meta information extracted from the WSDL
     * - documentation: Adds a customer lead to Dealerweb based on the supplied parameters.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLead $parameters
     * @return \StructType\AddLeadResponse|bool
     */
    public function AddLead(\StructType\AddLead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddLead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddLeadI4U
     * Meta information extracted from the WSDL
     * - documentation: Adds a customer lead to I4U based on the supplied data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLeadI4U $parameters
     * @return \StructType\AddLeadI4UResponse|bool
     */
    public function AddLeadI4U(\StructType\AddLeadI4U $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddLeadI4U($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddLeadToDataHub
     * Meta information extracted from the WSDL
     * - documentation: Adds a customer lead to Dealerweb based on the supplied parameters.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLeadToDataHub $parameters
     * @return \StructType\AddLeadToDataHubResponse|bool
     */
    public function AddLeadToDataHub(\StructType\AddLeadToDataHub $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddLeadToDataHub($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddLeadToDealerwebByPassDataHub
     * Meta information extracted from the WSDL
     * - documentation: Adds a customer lead to Dealerweb based on the supplied parameters.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLeadToDealerwebByPassDataHub $parameters
     * @return \StructType\AddLeadToDealerwebByPassDataHubResponse|bool
     */
    public function AddLeadToDealerwebByPassDataHub(\StructType\AddLeadToDealerwebByPassDataHub $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddLeadToDealerwebByPassDataHub($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddLeadI4UResponse|\StructType\AddLeadResponse|\StructType\AddLeadToDataHubResponse|\StructType\AddLeadToDealerwebByPassDataHubResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
