<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserPropertyBase StructType
 * @subpackage Structs
 */
abstract class UserPropertyBase extends Entity
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $EndDate;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $BirthDate;
    /**
     * The LastReviewDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $LastReviewDate;
    /**
     * The RequiresConfirmation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $RequiresConfirmation;
    /**
     * The AutoPublishCalender
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AutoPublishCalender;
    /**
     * The CanViewAllUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CanViewAllUsers;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $IsActive;
    /**
     * The IsLoginEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsLoginEnabled;
    /**
     * The IsInternal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsInternal;
    /**
     * The HasWebServiceAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasWebServiceAccess;
    /**
     * The IsInstructor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableBoolean
     */
    public $IsInstructor;
    /**
     * The MustChangePassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MustChangePassword;
    /**
     * The EmailFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EmailFormat;
    /**
     * The OptDate1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $OptDate1;
    /**
     * The OptDate2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $OptDate2;
    /**
     * The OptYesNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OptYesNo;
    /**
     * The OptMoney
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $OptMoney;
    /**
     * The OptInteger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $OptInteger;
    /**
     * The OptFloat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDouble
     */
    public $OptFloat;
    /**
     * The ActivityAttempts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfActivityAttempt
     */
    public $ActivityAttempts;
    /**
     * The ActivityRegistrations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfActivityRegistration
     */
    public $ActivityRegistrations;
    /**
     * The AcquiredSkills
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfUserAcquiredSkill
     */
    public $AcquiredSkills;
    /**
     * The RequiredActivities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfUserRequiredActivity
     */
    public $RequiredActivities;
    /**
     * The RequiredSkills
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfUserRequiredSkill
     */
    public $RequiredSkills;
    /**
     * The RequiredCompetencies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfUserRequiredCompetency
     */
    public $RequiredCompetencies;
    /**
     * The MemberDomains
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfDomainUser
     */
    public $MemberDomains;
    /**
     * The AcquiredCertifications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfUserAcquiredCertification
     */
    public $AcquiredCertifications;
    /**
     * The MemberJobs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfJobUser
     */
    public $MemberJobs;
    /**
     * The MemberOrganizations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfOrganizationUser
     */
    public $MemberOrganizations;
    /**
     * The Manager
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfPersonRelation
     */
    public $Manager;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The FirstNamePronounciation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstNamePronounciation;
    /**
     * The LastNamePronounciation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastNamePronounciation;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The NameTitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameTitle;
    /**
     * The NameSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameSuffix;
    /**
     * The JobTitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobTitle;
    /**
     * The UserNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserNumber;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The NtAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NtAccount;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * The CompanyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyCode;
    /**
     * The UserCodeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserCodeId;
    /**
     * The UserCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UserCode
     */
    public $UserCode;
    /**
     * The UserStatusId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserStatusId;
    /**
     * The UserStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UserStatus
     */
    public $UserStatus;
    /**
     * The PassportPUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PassportPUID;
    /**
     * The ManagerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManagerId;
    /**
     * The DefaultApproverId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultApproverId;
    /**
     * The DefaultApprover
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $DefaultApprover;
    /**
     * The ApproverId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApproverId;
    /**
     * The Approver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $Approver;
    /**
     * The DomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainId;
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Domain
     */
    public $Domain;
    /**
     * The DomainCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainCode;
    /**
     * The SecurityRoleId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecurityRoleId;
    /**
     * The SecurityRole
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var SecurityRole
     */
    public $SecurityRole;
    /**
     * The LanguagePreferenceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LanguagePreferenceId;
    /**
     * The LanguagePreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UserLanguage
     */
    public $LanguagePreference;
    /**
     * The CurrencyPreferenceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyPreferenceId;
    /**
     * The CurrencyPreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Currency
     */
    public $CurrencyPreference;
    /**
     * The TimeZonePreferenceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeZonePreferenceId;
    /**
     * The TimeZonePreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TimeZone
     */
    public $TimeZonePreference;
    /**
     * The AddressCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressCity;
    /**
     * The AddressCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressCountry;
    /**
     * The AddressFax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressFax;
    /**
     * The AddressPhone1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressPhone1;
    /**
     * The AddressPhone2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressPhone2;
    /**
     * The AddressState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressState;
    /**
     * The AddressStreet1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStreet1;
    /**
     * The AddressStreet2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStreet2;
    /**
     * The AddressPostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressPostalCode;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The WebexUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebexUserID;
    /**
     * The WebexPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebexPassword;
    /**
     * The ImageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageID;
    /**
     * The OptText1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText1;
    /**
     * The OptText2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText2;
    /**
     * The OptText3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText3;
    /**
     * The OptText4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText4;
    /**
     * The OptMemo1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptMemo1;
    /**
     * The OptCurrencyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptCurrencyId;
    /**
     * The OptCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Currency
     */
    public $OptCurrency;
    /**
     * The ApproverLevel1Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApproverLevel1Id;
    /**
     * The ApproverLevel1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $ApproverLevel1;
    /**
     * The ApproverLevel2Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApproverLevel2Id;
    /**
     * The ApproverLevel2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $ApproverLevel2;
    /**
     * The ApproverLevel3Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApproverLevel3Id;
    /**
     * The ApproverLevel3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $ApproverLevel3;
    /**
     * The ApproverLevel4Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApproverLevel4Id;
    /**
     * The ApproverLevel4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $ApproverLevel4;
    /**
     * The AgencySubElementCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencySubElementCode;
    /**
     * Constructor method for UserPropertyBase
     * @uses UserPropertyBase::setStartDate()
     * @uses UserPropertyBase::setEndDate()
     * @uses UserPropertyBase::setBirthDate()
     * @uses UserPropertyBase::setLastReviewDate()
     * @uses UserPropertyBase::setRequiresConfirmation()
     * @uses UserPropertyBase::setAutoPublishCalender()
     * @uses UserPropertyBase::setCanViewAllUsers()
     * @uses UserPropertyBase::setIsActive()
     * @uses UserPropertyBase::setIsLoginEnabled()
     * @uses UserPropertyBase::setIsInternal()
     * @uses UserPropertyBase::setHasWebServiceAccess()
     * @uses UserPropertyBase::setIsInstructor()
     * @uses UserPropertyBase::setMustChangePassword()
     * @uses UserPropertyBase::setEmailFormat()
     * @uses UserPropertyBase::setOptDate1()
     * @uses UserPropertyBase::setOptDate2()
     * @uses UserPropertyBase::setOptYesNo()
     * @uses UserPropertyBase::setOptMoney()
     * @uses UserPropertyBase::setOptInteger()
     * @uses UserPropertyBase::setOptFloat()
     * @uses UserPropertyBase::setActivityAttempts()
     * @uses UserPropertyBase::setActivityRegistrations()
     * @uses UserPropertyBase::setAcquiredSkills()
     * @uses UserPropertyBase::setRequiredActivities()
     * @uses UserPropertyBase::setRequiredSkills()
     * @uses UserPropertyBase::setRequiredCompetencies()
     * @uses UserPropertyBase::setMemberDomains()
     * @uses UserPropertyBase::setAcquiredCertifications()
     * @uses UserPropertyBase::setMemberJobs()
     * @uses UserPropertyBase::setMemberOrganizations()
     * @uses UserPropertyBase::setManager()
     * @uses UserPropertyBase::setId()
     * @uses UserPropertyBase::setFirstName()
     * @uses UserPropertyBase::setLastName()
     * @uses UserPropertyBase::setFirstNamePronounciation()
     * @uses UserPropertyBase::setLastNamePronounciation()
     * @uses UserPropertyBase::setMiddleName()
     * @uses UserPropertyBase::setNameTitle()
     * @uses UserPropertyBase::setNameSuffix()
     * @uses UserPropertyBase::setJobTitle()
     * @uses UserPropertyBase::setUserNumber()
     * @uses UserPropertyBase::setUsername()
     * @uses UserPropertyBase::setPassword()
     * @uses UserPropertyBase::setNtAccount()
     * @uses UserPropertyBase::setNote()
     * @uses UserPropertyBase::setCompanyCode()
     * @uses UserPropertyBase::setUserCodeId()
     * @uses UserPropertyBase::setUserCode()
     * @uses UserPropertyBase::setUserStatusId()
     * @uses UserPropertyBase::setUserStatus()
     * @uses UserPropertyBase::setPassportPUID()
     * @uses UserPropertyBase::setManagerId()
     * @uses UserPropertyBase::setDefaultApproverId()
     * @uses UserPropertyBase::setDefaultApprover()
     * @uses UserPropertyBase::setApproverId()
     * @uses UserPropertyBase::setApprover()
     * @uses UserPropertyBase::setDomainId()
     * @uses UserPropertyBase::setDomain()
     * @uses UserPropertyBase::setDomainCode()
     * @uses UserPropertyBase::setSecurityRoleId()
     * @uses UserPropertyBase::setSecurityRole()
     * @uses UserPropertyBase::setLanguagePreferenceId()
     * @uses UserPropertyBase::setLanguagePreference()
     * @uses UserPropertyBase::setCurrencyPreferenceId()
     * @uses UserPropertyBase::setCurrencyPreference()
     * @uses UserPropertyBase::setTimeZonePreferenceId()
     * @uses UserPropertyBase::setTimeZonePreference()
     * @uses UserPropertyBase::setAddressCity()
     * @uses UserPropertyBase::setAddressCountry()
     * @uses UserPropertyBase::setAddressFax()
     * @uses UserPropertyBase::setAddressPhone1()
     * @uses UserPropertyBase::setAddressPhone2()
     * @uses UserPropertyBase::setAddressState()
     * @uses UserPropertyBase::setAddressStreet1()
     * @uses UserPropertyBase::setAddressStreet2()
     * @uses UserPropertyBase::setAddressPostalCode()
     * @uses UserPropertyBase::setEmail()
     * @uses UserPropertyBase::setUrl()
     * @uses UserPropertyBase::setWebexUserID()
     * @uses UserPropertyBase::setWebexPassword()
     * @uses UserPropertyBase::setImageID()
     * @uses UserPropertyBase::setOptText1()
     * @uses UserPropertyBase::setOptText2()
     * @uses UserPropertyBase::setOptText3()
     * @uses UserPropertyBase::setOptText4()
     * @uses UserPropertyBase::setOptMemo1()
     * @uses UserPropertyBase::setOptCurrencyId()
     * @uses UserPropertyBase::setOptCurrency()
     * @uses UserPropertyBase::setApproverLevel1Id()
     * @uses UserPropertyBase::setApproverLevel1()
     * @uses UserPropertyBase::setApproverLevel2Id()
     * @uses UserPropertyBase::setApproverLevel2()
     * @uses UserPropertyBase::setApproverLevel3Id()
     * @uses UserPropertyBase::setApproverLevel3()
     * @uses UserPropertyBase::setApproverLevel4Id()
     * @uses UserPropertyBase::setApproverLevel4()
     * @uses UserPropertyBase::setAgencySubElementCode()
     * @param NullableDateTime $startDate
     * @param NullableDateTime $endDate
     * @param NullableDateTime $birthDate
     * @param NullableDateTime $lastReviewDate
     * @param NullableInt32 $requiresConfirmation
     * @param bool $autoPublishCalender
     * @param bool $canViewAllUsers
     * @param NullableInt32 $isActive
     * @param bool $isLoginEnabled
     * @param bool $isInternal
     * @param bool $hasWebServiceAccess
     * @param NullableBoolean $isInstructor
     * @param bool $mustChangePassword
     * @param int $emailFormat
     * @param NullableDateTime $optDate1
     * @param NullableDateTime $optDate2
     * @param bool $optYesNo
     * @param NullableDecimal $optMoney
     * @param NullableInt32 $optInteger
     * @param NullableDouble $optFloat
     * @param ArrayOfActivityAttempt $activityAttempts
     * @param ArrayOfActivityRegistration $activityRegistrations
     * @param ArrayOfUserAcquiredSkill $acquiredSkills
     * @param ArrayOfUserRequiredActivity $requiredActivities
     * @param ArrayOfUserRequiredSkill $requiredSkills
     * @param ArrayOfUserRequiredCompetency $requiredCompetencies
     * @param ArrayOfDomainUser $memberDomains
     * @param ArrayOfUserAcquiredCertification $acquiredCertifications
     * @param ArrayOfJobUser $memberJobs
     * @param ArrayOfOrganizationUser $memberOrganizations
     * @param ArrayOfPersonRelation $manager
     * @param string $id
     * @param string $firstName
     * @param string $lastName
     * @param string $firstNamePronounciation
     * @param string $lastNamePronounciation
     * @param string $middleName
     * @param string $nameTitle
     * @param string $nameSuffix
     * @param string $jobTitle
     * @param string $userNumber
     * @param string $username
     * @param string $password
     * @param string $ntAccount
     * @param string $note
     * @param string $companyCode
     * @param string $userCodeId
     * @param UserCode $userCode
     * @param string $userStatusId
     * @param UserStatus $userStatus
     * @param string $passportPUID
     * @param string $managerId
     * @param string $defaultApproverId
     * @param User $defaultApprover
     * @param string $approverId
     * @param User $approver
     * @param string $domainId
     * @param Domain $domain
     * @param string $domainCode
     * @param string $securityRoleId
     * @param SecurityRole $securityRole
     * @param string $languagePreferenceId
     * @param UserLanguage $languagePreference
     * @param string $currencyPreferenceId
     * @param Currency $currencyPreference
     * @param string $timeZonePreferenceId
     * @param TimeZone $timeZonePreference
     * @param string $addressCity
     * @param string $addressCountry
     * @param string $addressFax
     * @param string $addressPhone1
     * @param string $addressPhone2
     * @param string $addressState
     * @param string $addressStreet1
     * @param string $addressStreet2
     * @param string $addressPostalCode
     * @param string $email
     * @param string $url
     * @param string $webexUserID
     * @param string $webexPassword
     * @param string $imageID
     * @param string $optText1
     * @param string $optText2
     * @param string $optText3
     * @param string $optText4
     * @param string $optMemo1
     * @param string $optCurrencyId
     * @param Currency $optCurrency
     * @param string $approverLevel1Id
     * @param User $approverLevel1
     * @param string $approverLevel2Id
     * @param User $approverLevel2
     * @param string $approverLevel3Id
     * @param User $approverLevel3
     * @param string $approverLevel4Id
     * @param User $approverLevel4
     * @param string $agencySubElementCode
     */
    public function __construct(NullableDateTime $startDate = null, NullableDateTime $endDate = null, NullableDateTime $birthDate = null, NullableDateTime $lastReviewDate = null, NullableInt32 $requiresConfirmation = null, $autoPublishCalender = null, $canViewAllUsers = null, NullableInt32 $isActive = null, $isLoginEnabled = null, $isInternal = null, $hasWebServiceAccess = null, NullableBoolean $isInstructor = null, $mustChangePassword = null, $emailFormat = null, NullableDateTime $optDate1 = null, NullableDateTime $optDate2 = null, $optYesNo = null, NullableDecimal $optMoney = null, NullableInt32 $optInteger = null, NullableDouble $optFloat = null, ArrayOfActivityAttempt $activityAttempts = null, ArrayOfActivityRegistration $activityRegistrations = null, ArrayOfUserAcquiredSkill $acquiredSkills = null, ArrayOfUserRequiredActivity $requiredActivities = null, ArrayOfUserRequiredSkill $requiredSkills = null, ArrayOfUserRequiredCompetency $requiredCompetencies = null, ArrayOfDomainUser $memberDomains = null, ArrayOfUserAcquiredCertification $acquiredCertifications = null, ArrayOfJobUser $memberJobs = null, ArrayOfOrganizationUser $memberOrganizations = null, ArrayOfPersonRelation $manager = null, $id = null, $firstName = null, $lastName = null, $firstNamePronounciation = null, $lastNamePronounciation = null, $middleName = null, $nameTitle = null, $nameSuffix = null, $jobTitle = null, $userNumber = null, $username = null, $password = null, $ntAccount = null, $note = null, $companyCode = null, $userCodeId = null, UserCode $userCode = null, $userStatusId = null, UserStatus $userStatus = null, $passportPUID = null, $managerId = null, $defaultApproverId = null, User $defaultApprover = null, $approverId = null, User $approver = null, $domainId = null, Domain $domain = null, $domainCode = null, $securityRoleId = null, SecurityRole $securityRole = null, $languagePreferenceId = null, UserLanguage $languagePreference = null, $currencyPreferenceId = null, Currency $currencyPreference = null, $timeZonePreferenceId = null, TimeZone $timeZonePreference = null, $addressCity = null, $addressCountry = null, $addressFax = null, $addressPhone1 = null, $addressPhone2 = null, $addressState = null, $addressStreet1 = null, $addressStreet2 = null, $addressPostalCode = null, $email = null, $url = null, $webexUserID = null, $webexPassword = null, $imageID = null, $optText1 = null, $optText2 = null, $optText3 = null, $optText4 = null, $optMemo1 = null, $optCurrencyId = null, Currency $optCurrency = null, $approverLevel1Id = null, User $approverLevel1 = null, $approverLevel2Id = null, User $approverLevel2 = null, $approverLevel3Id = null, User $approverLevel3 = null, $approverLevel4Id = null, User $approverLevel4 = null, $agencySubElementCode = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setBirthDate($birthDate)
            ->setLastReviewDate($lastReviewDate)
            ->setRequiresConfirmation($requiresConfirmation)
            ->setAutoPublishCalender($autoPublishCalender)
            ->setCanViewAllUsers($canViewAllUsers)
            ->setIsActive($isActive)
            ->setIsLoginEnabled($isLoginEnabled)
            ->setIsInternal($isInternal)
            ->setHasWebServiceAccess($hasWebServiceAccess)
            ->setIsInstructor($isInstructor)
            ->setMustChangePassword($mustChangePassword)
            ->setEmailFormat($emailFormat)
            ->setOptDate1($optDate1)
            ->setOptDate2($optDate2)
            ->setOptYesNo($optYesNo)
            ->setOptMoney($optMoney)
            ->setOptInteger($optInteger)
            ->setOptFloat($optFloat)
            ->setActivityAttempts($activityAttempts)
            ->setActivityRegistrations($activityRegistrations)
            ->setAcquiredSkills($acquiredSkills)
            ->setRequiredActivities($requiredActivities)
            ->setRequiredSkills($requiredSkills)
            ->setRequiredCompetencies($requiredCompetencies)
            ->setMemberDomains($memberDomains)
            ->setAcquiredCertifications($acquiredCertifications)
            ->setMemberJobs($memberJobs)
            ->setMemberOrganizations($memberOrganizations)
            ->setManager($manager)
            ->setId($id)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setFirstNamePronounciation($firstNamePronounciation)
            ->setLastNamePronounciation($lastNamePronounciation)
            ->setMiddleName($middleName)
            ->setNameTitle($nameTitle)
            ->setNameSuffix($nameSuffix)
            ->setJobTitle($jobTitle)
            ->setUserNumber($userNumber)
            ->setUsername($username)
            ->setPassword($password)
            ->setNtAccount($ntAccount)
            ->setNote($note)
            ->setCompanyCode($companyCode)
            ->setUserCodeId($userCodeId)
            ->setUserCode($userCode)
            ->setUserStatusId($userStatusId)
            ->setUserStatus($userStatus)
            ->setPassportPUID($passportPUID)
            ->setManagerId($managerId)
            ->setDefaultApproverId($defaultApproverId)
            ->setDefaultApprover($defaultApprover)
            ->setApproverId($approverId)
            ->setApprover($approver)
            ->setDomainId($domainId)
            ->setDomain($domain)
            ->setDomainCode($domainCode)
            ->setSecurityRoleId($securityRoleId)
            ->setSecurityRole($securityRole)
            ->setLanguagePreferenceId($languagePreferenceId)
            ->setLanguagePreference($languagePreference)
            ->setCurrencyPreferenceId($currencyPreferenceId)
            ->setCurrencyPreference($currencyPreference)
            ->setTimeZonePreferenceId($timeZonePreferenceId)
            ->setTimeZonePreference($timeZonePreference)
            ->setAddressCity($addressCity)
            ->setAddressCountry($addressCountry)
            ->setAddressFax($addressFax)
            ->setAddressPhone1($addressPhone1)
            ->setAddressPhone2($addressPhone2)
            ->setAddressState($addressState)
            ->setAddressStreet1($addressStreet1)
            ->setAddressStreet2($addressStreet2)
            ->setAddressPostalCode($addressPostalCode)
            ->setEmail($email)
            ->setUrl($url)
            ->setWebexUserID($webexUserID)
            ->setWebexPassword($webexPassword)
            ->setImageID($imageID)
            ->setOptText1($optText1)
            ->setOptText2($optText2)
            ->setOptText3($optText3)
            ->setOptText4($optText4)
            ->setOptMemo1($optMemo1)
            ->setOptCurrencyId($optCurrencyId)
            ->setOptCurrency($optCurrency)
            ->setApproverLevel1Id($approverLevel1Id)
            ->setApproverLevel1($approverLevel1)
            ->setApproverLevel2Id($approverLevel2Id)
            ->setApproverLevel2($approverLevel2)
            ->setApproverLevel3Id($approverLevel3Id)
            ->setApproverLevel3($approverLevel3)
            ->setApproverLevel4Id($approverLevel4Id)
            ->setApproverLevel4($approverLevel4)
            ->setAgencySubElementCode($agencySubElementCode);
    }
    /**
     * Get StartDate value
     * @return NullableDateTime
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param NullableDateTime $startDate
     * @return UserPropertyBase
     */
    public function setStartDate(NullableDateTime $startDate = null)
    {
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return NullableDateTime
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param NullableDateTime $endDate
     * @return UserPropertyBase
     */
    public function setEndDate(NullableDateTime $endDate = null)
    {
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return NullableDateTime
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param NullableDateTime $birthDate
     * @return UserPropertyBase
     */
    public function setBirthDate(NullableDateTime $birthDate = null)
    {
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get LastReviewDate value
     * @return NullableDateTime
     */
    public function getLastReviewDate()
    {
        return $this->LastReviewDate;
    }
    /**
     * Set LastReviewDate value
     * @param NullableDateTime $lastReviewDate
     * @return UserPropertyBase
     */
    public function setLastReviewDate(NullableDateTime $lastReviewDate = null)
    {
        $this->LastReviewDate = $lastReviewDate;
        return $this;
    }
    /**
     * Get RequiresConfirmation value
     * @return NullableInt32
     */
    public function getRequiresConfirmation()
    {
        return $this->RequiresConfirmation;
    }
    /**
     * Set RequiresConfirmation value
     * @param NullableInt32 $requiresConfirmation
     * @return UserPropertyBase
     */
    public function setRequiresConfirmation(NullableInt32 $requiresConfirmation = null)
    {
        $this->RequiresConfirmation = $requiresConfirmation;
        return $this;
    }
    /**
     * Get AutoPublishCalender value
     * @return bool
     */
    public function getAutoPublishCalender()
    {
        return $this->AutoPublishCalender;
    }
    /**
     * Set AutoPublishCalender value
     * @param bool $autoPublishCalender
     * @return UserPropertyBase
     */
    public function setAutoPublishCalender($autoPublishCalender = null)
    {
        $this->AutoPublishCalender = $autoPublishCalender;
        return $this;
    }
    /**
     * Get CanViewAllUsers value
     * @return bool
     */
    public function getCanViewAllUsers()
    {
        return $this->CanViewAllUsers;
    }
    /**
     * Set CanViewAllUsers value
     * @param bool $canViewAllUsers
     * @return UserPropertyBase
     */
    public function setCanViewAllUsers($canViewAllUsers = null)
    {
        $this->CanViewAllUsers = $canViewAllUsers;
        return $this;
    }
    /**
     * Get IsActive value
     * @return NullableInt32
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param NullableInt32 $isActive
     * @return UserPropertyBase
     */
    public function setIsActive(NullableInt32 $isActive = null)
    {
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsLoginEnabled value
     * @return bool
     */
    public function getIsLoginEnabled()
    {
        return $this->IsLoginEnabled;
    }
    /**
     * Set IsLoginEnabled value
     * @param bool $isLoginEnabled
     * @return UserPropertyBase
     */
    public function setIsLoginEnabled($isLoginEnabled = null)
    {
        $this->IsLoginEnabled = $isLoginEnabled;
        return $this;
    }
    /**
     * Get IsInternal value
     * @return bool
     */
    public function getIsInternal()
    {
        return $this->IsInternal;
    }
    /**
     * Set IsInternal value
     * @param bool $isInternal
     * @return UserPropertyBase
     */
    public function setIsInternal($isInternal = null)
    {
        $this->IsInternal = $isInternal;
        return $this;
    }
    /**
     * Get HasWebServiceAccess value
     * @return bool
     */
    public function getHasWebServiceAccess()
    {
        return $this->HasWebServiceAccess;
    }
    /**
     * Set HasWebServiceAccess value
     * @param bool $hasWebServiceAccess
     * @return UserPropertyBase
     */
    public function setHasWebServiceAccess($hasWebServiceAccess = null)
    {
        $this->HasWebServiceAccess = $hasWebServiceAccess;
        return $this;
    }
    /**
     * Get IsInstructor value
     * @return NullableBoolean
     */
    public function getIsInstructor()
    {
        return $this->IsInstructor;
    }
    /**
     * Set IsInstructor value
     * @param NullableBoolean $isInstructor
     * @return UserPropertyBase
     */
    public function setIsInstructor(NullableBoolean $isInstructor = null)
    {
        $this->IsInstructor = $isInstructor;
        return $this;
    }
    /**
     * Get MustChangePassword value
     * @return bool
     */
    public function getMustChangePassword()
    {
        return $this->MustChangePassword;
    }
    /**
     * Set MustChangePassword value
     * @param bool $mustChangePassword
     * @return UserPropertyBase
     */
    public function setMustChangePassword($mustChangePassword = null)
    {
        $this->MustChangePassword = $mustChangePassword;
        return $this;
    }
    /**
     * Get EmailFormat value
     * @return int
     */
    public function getEmailFormat()
    {
        return $this->EmailFormat;
    }
    /**
     * Set EmailFormat value
     * @param int $emailFormat
     * @return UserPropertyBase
     */
    public function setEmailFormat($emailFormat = null)
    {
        // validation for constraint: int
        if (!is_null($emailFormat) && !is_numeric($emailFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($emailFormat)), __LINE__);
        }
        $this->EmailFormat = $emailFormat;
        return $this;
    }
    /**
     * Get OptDate1 value
     * @return NullableDateTime
     */
    public function getOptDate1()
    {
        return $this->OptDate1;
    }
    /**
     * Set OptDate1 value
     * @param NullableDateTime $optDate1
     * @return UserPropertyBase
     */
    public function setOptDate1(NullableDateTime $optDate1 = null)
    {
        $this->OptDate1 = $optDate1;
        return $this;
    }
    /**
     * Get OptDate2 value
     * @return NullableDateTime
     */
    public function getOptDate2()
    {
        return $this->OptDate2;
    }
    /**
     * Set OptDate2 value
     * @param NullableDateTime $optDate2
     * @return UserPropertyBase
     */
    public function setOptDate2(NullableDateTime $optDate2 = null)
    {
        $this->OptDate2 = $optDate2;
        return $this;
    }
    /**
     * Get OptYesNo value
     * @return bool
     */
    public function getOptYesNo()
    {
        return $this->OptYesNo;
    }
    /**
     * Set OptYesNo value
     * @param bool $optYesNo
     * @return UserPropertyBase
     */
    public function setOptYesNo($optYesNo = null)
    {
        $this->OptYesNo = $optYesNo;
        return $this;
    }
    /**
     * Get OptMoney value
     * @return NullableDecimal
     */
    public function getOptMoney()
    {
        return $this->OptMoney;
    }
    /**
     * Set OptMoney value
     * @param NullableDecimal $optMoney
     * @return UserPropertyBase
     */
    public function setOptMoney(NullableDecimal $optMoney = null)
    {
        $this->OptMoney = $optMoney;
        return $this;
    }
    /**
     * Get OptInteger value
     * @return NullableInt32
     */
    public function getOptInteger()
    {
        return $this->OptInteger;
    }
    /**
     * Set OptInteger value
     * @param NullableInt32 $optInteger
     * @return UserPropertyBase
     */
    public function setOptInteger(NullableInt32 $optInteger = null)
    {
        $this->OptInteger = $optInteger;
        return $this;
    }
    /**
     * Get OptFloat value
     * @return NullableDouble
     */
    public function getOptFloat()
    {
        return $this->OptFloat;
    }
    /**
     * Set OptFloat value
     * @param NullableDouble $optFloat
     * @return UserPropertyBase
     */
    public function setOptFloat(NullableDouble $optFloat = null)
    {
        $this->OptFloat = $optFloat;
        return $this;
    }
    /**
     * Get ActivityAttempts value
     * @return ArrayOfActivityAttempt
     */
    public function getActivityAttempts()
    {
        return $this->ActivityAttempts;
    }
    /**
     * Set ActivityAttempts value
     * @param ArrayOfActivityAttempt $activityAttempts
     * @return UserPropertyBase
     */
    public function setActivityAttempts(ArrayOfActivityAttempt $activityAttempts = null)
    {
        $this->ActivityAttempts = $activityAttempts;
        return $this;
    }
    /**
     * Get ActivityRegistrations value
     * @return ArrayOfActivityRegistration
     */
    public function getActivityRegistrations()
    {
        return $this->ActivityRegistrations;
    }
    /**
     * Set ActivityRegistrations value
     * @param ArrayOfActivityRegistration $activityRegistrations
     * @return UserPropertyBase
     */
    public function setActivityRegistrations(ArrayOfActivityRegistration $activityRegistrations = null)
    {
        $this->ActivityRegistrations = $activityRegistrations;
        return $this;
    }
    /**
     * Get AcquiredSkills value
     * @return ArrayOfUserAcquiredSkill
     */
    public function getAcquiredSkills()
    {
        return $this->AcquiredSkills;
    }
    /**
     * Set AcquiredSkills value
     * @param ArrayOfUserAcquiredSkill $acquiredSkills
     * @return UserPropertyBase
     */
    public function setAcquiredSkills(ArrayOfUserAcquiredSkill $acquiredSkills = null)
    {
        $this->AcquiredSkills = $acquiredSkills;
        return $this;
    }
    /**
     * Get RequiredActivities value
     * @return ArrayOfUserRequiredActivity
     */
    public function getRequiredActivities()
    {
        return $this->RequiredActivities;
    }
    /**
     * Set RequiredActivities value
     * @param ArrayOfUserRequiredActivity $requiredActivities
     * @return UserPropertyBase
     */
    public function setRequiredActivities(ArrayOfUserRequiredActivity $requiredActivities = null)
    {
        $this->RequiredActivities = $requiredActivities;
        return $this;
    }
    /**
     * Get RequiredSkills value
     * @return ArrayOfUserRequiredSkill
     */
    public function getRequiredSkills()
    {
        return $this->RequiredSkills;
    }
    /**
     * Set RequiredSkills value
     * @param ArrayOfUserRequiredSkill $requiredSkills
     * @return UserPropertyBase
     */
    public function setRequiredSkills(ArrayOfUserRequiredSkill $requiredSkills = null)
    {
        $this->RequiredSkills = $requiredSkills;
        return $this;
    }
    /**
     * Get RequiredCompetencies value
     * @return ArrayOfUserRequiredCompetency
     */
    public function getRequiredCompetencies()
    {
        return $this->RequiredCompetencies;
    }
    /**
     * Set RequiredCompetencies value
     * @param ArrayOfUserRequiredCompetency $requiredCompetencies
     * @return UserPropertyBase
     */
    public function setRequiredCompetencies(ArrayOfUserRequiredCompetency $requiredCompetencies = null)
    {
        $this->RequiredCompetencies = $requiredCompetencies;
        return $this;
    }
    /**
     * Get MemberDomains value
     * @return ArrayOfDomainUser
     */
    public function getMemberDomains()
    {
        return $this->MemberDomains;
    }
    /**
     * Set MemberDomains value
     * @param ArrayOfDomainUser $memberDomains
     * @return UserPropertyBase
     */
    public function setMemberDomains(ArrayOfDomainUser $memberDomains = null)
    {
        $this->MemberDomains = $memberDomains;
        return $this;
    }
    /**
     * Get AcquiredCertifications value
     * @return ArrayOfUserAcquiredCertification
     */
    public function getAcquiredCertifications()
    {
        return $this->AcquiredCertifications;
    }
    /**
     * Set AcquiredCertifications value
     * @param ArrayOfUserAcquiredCertification $acquiredCertifications
     * @return UserPropertyBase
     */
    public function setAcquiredCertifications(ArrayOfUserAcquiredCertification $acquiredCertifications = null)
    {
        $this->AcquiredCertifications = $acquiredCertifications;
        return $this;
    }
    /**
     * Get MemberJobs value
     * @return ArrayOfJobUser
     */
    public function getMemberJobs()
    {
        return $this->MemberJobs;
    }
    /**
     * Set MemberJobs value
     * @param ArrayOfJobUser $memberJobs
     * @return UserPropertyBase
     */
    public function setMemberJobs(ArrayOfJobUser $memberJobs = null)
    {
        $this->MemberJobs = $memberJobs;
        return $this;
    }
    /**
     * Get MemberOrganizations value
     * @return ArrayOfOrganizationUser
     */
    public function getMemberOrganizations()
    {
        return $this->MemberOrganizations;
    }
    /**
     * Set MemberOrganizations value
     * @param ArrayOfOrganizationUser $memberOrganizations
     * @return UserPropertyBase
     */
    public function setMemberOrganizations(ArrayOfOrganizationUser $memberOrganizations = null)
    {
        $this->MemberOrganizations = $memberOrganizations;
        return $this;
    }
    /**
     * Get Manager value
     * @return ArrayOfPersonRelation
     */
    public function getManager()
    {
        return $this->Manager;
    }
    /**
     * Set Manager value
     * @param ArrayOfPersonRelation $manager
     * @return UserPropertyBase
     */
    public function setManager(ArrayOfPersonRelation $manager = null)
    {
        $this->Manager = $manager;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return UserPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return UserPropertyBase
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return UserPropertyBase
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get FirstNamePronounciation value
     * @return string|null
     */
    public function getFirstNamePronounciation()
    {
        return $this->FirstNamePronounciation;
    }
    /**
     * Set FirstNamePronounciation value
     * @param string $firstNamePronounciation
     * @return UserPropertyBase
     */
    public function setFirstNamePronounciation($firstNamePronounciation = null)
    {
        // validation for constraint: string
        if (!is_null($firstNamePronounciation) && !is_string($firstNamePronounciation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstNamePronounciation)), __LINE__);
        }
        $this->FirstNamePronounciation = $firstNamePronounciation;
        return $this;
    }
    /**
     * Get LastNamePronounciation value
     * @return string|null
     */
    public function getLastNamePronounciation()
    {
        return $this->LastNamePronounciation;
    }
    /**
     * Set LastNamePronounciation value
     * @param string $lastNamePronounciation
     * @return UserPropertyBase
     */
    public function setLastNamePronounciation($lastNamePronounciation = null)
    {
        // validation for constraint: string
        if (!is_null($lastNamePronounciation) && !is_string($lastNamePronounciation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastNamePronounciation)), __LINE__);
        }
        $this->LastNamePronounciation = $lastNamePronounciation;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return UserPropertyBase
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get NameTitle value
     * @return string|null
     */
    public function getNameTitle()
    {
        return $this->NameTitle;
    }
    /**
     * Set NameTitle value
     * @param string $nameTitle
     * @return UserPropertyBase
     */
    public function setNameTitle($nameTitle = null)
    {
        // validation for constraint: string
        if (!is_null($nameTitle) && !is_string($nameTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameTitle)), __LINE__);
        }
        $this->NameTitle = $nameTitle;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return string|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * Set NameSuffix value
     * @param string $nameSuffix
     * @return UserPropertyBase
     */
    public function setNameSuffix($nameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($nameSuffix) && !is_string($nameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameSuffix)), __LINE__);
        }
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Get JobTitle value
     * @return string|null
     */
    public function getJobTitle()
    {
        return $this->JobTitle;
    }
    /**
     * Set JobTitle value
     * @param string $jobTitle
     * @return UserPropertyBase
     */
    public function setJobTitle($jobTitle = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitle) && !is_string($jobTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jobTitle)), __LINE__);
        }
        $this->JobTitle = $jobTitle;
        return $this;
    }
    /**
     * Get UserNumber value
     * @return string|null
     */
    public function getUserNumber()
    {
        return $this->UserNumber;
    }
    /**
     * Set UserNumber value
     * @param string $userNumber
     * @return UserPropertyBase
     */
    public function setUserNumber($userNumber = null)
    {
        // validation for constraint: string
        if (!is_null($userNumber) && !is_string($userNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userNumber)), __LINE__);
        }
        $this->UserNumber = $userNumber;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return UserPropertyBase
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return UserPropertyBase
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get NtAccount value
     * @return string|null
     */
    public function getNtAccount()
    {
        return $this->NtAccount;
    }
    /**
     * Set NtAccount value
     * @param string $ntAccount
     * @return UserPropertyBase
     */
    public function setNtAccount($ntAccount = null)
    {
        // validation for constraint: string
        if (!is_null($ntAccount) && !is_string($ntAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ntAccount)), __LINE__);
        }
        $this->NtAccount = $ntAccount;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return UserPropertyBase
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get CompanyCode value
     * @return string|null
     */
    public function getCompanyCode()
    {
        return $this->CompanyCode;
    }
    /**
     * Set CompanyCode value
     * @param string $companyCode
     * @return UserPropertyBase
     */
    public function setCompanyCode($companyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCode) && !is_string($companyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyCode)), __LINE__);
        }
        $this->CompanyCode = $companyCode;
        return $this;
    }
    /**
     * Get UserCodeId value
     * @return string|null
     */
    public function getUserCodeId()
    {
        return $this->UserCodeId;
    }
    /**
     * Set UserCodeId value
     * @param string $userCodeId
     * @return UserPropertyBase
     */
    public function setUserCodeId($userCodeId = null)
    {
        // validation for constraint: string
        if (!is_null($userCodeId) && !is_string($userCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userCodeId)), __LINE__);
        }
        $this->UserCodeId = $userCodeId;
        return $this;
    }
    /**
     * Get UserCode value
     * @return UserCode|null
     */
    public function getUserCode()
    {
        return $this->UserCode;
    }
    /**
     * Set UserCode value
     * @param UserCode $userCode
     * @return UserPropertyBase
     */
    public function setUserCode(UserCode $userCode = null)
    {
        $this->UserCode = $userCode;
        return $this;
    }
    /**
     * Get UserStatusId value
     * @return string|null
     */
    public function getUserStatusId()
    {
        return $this->UserStatusId;
    }
    /**
     * Set UserStatusId value
     * @param string $userStatusId
     * @return UserPropertyBase
     */
    public function setUserStatusId($userStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($userStatusId) && !is_string($userStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userStatusId)), __LINE__);
        }
        $this->UserStatusId = $userStatusId;
        return $this;
    }
    /**
     * Get UserStatus value
     * @return UserStatus|null
     */
    public function getUserStatus()
    {
        return $this->UserStatus;
    }
    /**
     * Set UserStatus value
     * @param UserStatus $userStatus
     * @return UserPropertyBase
     */
    public function setUserStatus(UserStatus $userStatus = null)
    {
        $this->UserStatus = $userStatus;
        return $this;
    }
    /**
     * Get PassportPUID value
     * @return string|null
     */
    public function getPassportPUID()
    {
        return $this->PassportPUID;
    }
    /**
     * Set PassportPUID value
     * @param string $passportPUID
     * @return UserPropertyBase
     */
    public function setPassportPUID($passportPUID = null)
    {
        // validation for constraint: string
        if (!is_null($passportPUID) && !is_string($passportPUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passportPUID)), __LINE__);
        }
        $this->PassportPUID = $passportPUID;
        return $this;
    }
    /**
     * Get ManagerId value
     * @return string|null
     */
    public function getManagerId()
    {
        return $this->ManagerId;
    }
    /**
     * Set ManagerId value
     * @param string $managerId
     * @return UserPropertyBase
     */
    public function setManagerId($managerId = null)
    {
        // validation for constraint: string
        if (!is_null($managerId) && !is_string($managerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($managerId)), __LINE__);
        }
        $this->ManagerId = $managerId;
        return $this;
    }
    /**
     * Get DefaultApproverId value
     * @return string|null
     */
    public function getDefaultApproverId()
    {
        return $this->DefaultApproverId;
    }
    /**
     * Set DefaultApproverId value
     * @param string $defaultApproverId
     * @return UserPropertyBase
     */
    public function setDefaultApproverId($defaultApproverId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultApproverId) && !is_string($defaultApproverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultApproverId)), __LINE__);
        }
        $this->DefaultApproverId = $defaultApproverId;
        return $this;
    }
    /**
     * Get DefaultApprover value
     * @return User|null
     */
    public function getDefaultApprover()
    {
        return $this->DefaultApprover;
    }
    /**
     * Set DefaultApprover value
     * @param User $defaultApprover
     * @return UserPropertyBase
     */
    public function setDefaultApprover(User $defaultApprover = null)
    {
        $this->DefaultApprover = $defaultApprover;
        return $this;
    }
    /**
     * Get ApproverId value
     * @return string|null
     */
    public function getApproverId()
    {
        return $this->ApproverId;
    }
    /**
     * Set ApproverId value
     * @param string $approverId
     * @return UserPropertyBase
     */
    public function setApproverId($approverId = null)
    {
        // validation for constraint: string
        if (!is_null($approverId) && !is_string($approverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approverId)), __LINE__);
        }
        $this->ApproverId = $approverId;
        return $this;
    }
    /**
     * Get Approver value
     * @return User|null
     */
    public function getApprover()
    {
        return $this->Approver;
    }
    /**
     * Set Approver value
     * @param User $approver
     * @return UserPropertyBase
     */
    public function setApprover(User $approver = null)
    {
        $this->Approver = $approver;
        return $this;
    }
    /**
     * Get DomainId value
     * @return string|null
     */
    public function getDomainId()
    {
        return $this->DomainId;
    }
    /**
     * Set DomainId value
     * @param string $domainId
     * @return UserPropertyBase
     */
    public function setDomainId($domainId = null)
    {
        // validation for constraint: string
        if (!is_null($domainId) && !is_string($domainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainId)), __LINE__);
        }
        $this->DomainId = $domainId;
        return $this;
    }
    /**
     * Get Domain value
     * @return Domain|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param Domain $domain
     * @return UserPropertyBase
     */
    public function setDomain(Domain $domain = null)
    {
        $this->Domain = $domain;
        return $this;
    }
    /**
     * Get DomainCode value
     * @return string|null
     */
    public function getDomainCode()
    {
        return $this->DomainCode;
    }
    /**
     * Set DomainCode value
     * @param string $domainCode
     * @return UserPropertyBase
     */
    public function setDomainCode($domainCode = null)
    {
        // validation for constraint: string
        if (!is_null($domainCode) && !is_string($domainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainCode)), __LINE__);
        }
        $this->DomainCode = $domainCode;
        return $this;
    }
    /**
     * Get SecurityRoleId value
     * @return string|null
     */
    public function getSecurityRoleId()
    {
        return $this->SecurityRoleId;
    }
    /**
     * Set SecurityRoleId value
     * @param string $securityRoleId
     * @return UserPropertyBase
     */
    public function setSecurityRoleId($securityRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($securityRoleId) && !is_string($securityRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityRoleId)), __LINE__);
        }
        $this->SecurityRoleId = $securityRoleId;
        return $this;
    }
    /**
     * Get SecurityRole value
     * @return SecurityRole|null
     */
    public function getSecurityRole()
    {
        return $this->SecurityRole;
    }
    /**
     * Set SecurityRole value
     * @param SecurityRole $securityRole
     * @return UserPropertyBase
     */
    public function setSecurityRole(SecurityRole $securityRole = null)
    {
        $this->SecurityRole = $securityRole;
        return $this;
    }
    /**
     * Get LanguagePreferenceId value
     * @return string|null
     */
    public function getLanguagePreferenceId()
    {
        return $this->LanguagePreferenceId;
    }
    /**
     * Set LanguagePreferenceId value
     * @param string $languagePreferenceId
     * @return UserPropertyBase
     */
    public function setLanguagePreferenceId($languagePreferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($languagePreferenceId) && !is_string($languagePreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languagePreferenceId)), __LINE__);
        }
        $this->LanguagePreferenceId = $languagePreferenceId;
        return $this;
    }
    /**
     * Get LanguagePreference value
     * @return UserLanguage|null
     */
    public function getLanguagePreference()
    {
        return $this->LanguagePreference;
    }
    /**
     * Set LanguagePreference value
     * @param UserLanguage $languagePreference
     * @return UserPropertyBase
     */
    public function setLanguagePreference(UserLanguage $languagePreference = null)
    {
        $this->LanguagePreference = $languagePreference;
        return $this;
    }
    /**
     * Get CurrencyPreferenceId value
     * @return string|null
     */
    public function getCurrencyPreferenceId()
    {
        return $this->CurrencyPreferenceId;
    }
    /**
     * Set CurrencyPreferenceId value
     * @param string $currencyPreferenceId
     * @return UserPropertyBase
     */
    public function setCurrencyPreferenceId($currencyPreferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($currencyPreferenceId) && !is_string($currencyPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyPreferenceId)), __LINE__);
        }
        $this->CurrencyPreferenceId = $currencyPreferenceId;
        return $this;
    }
    /**
     * Get CurrencyPreference value
     * @return Currency|null
     */
    public function getCurrencyPreference()
    {
        return $this->CurrencyPreference;
    }
    /**
     * Set CurrencyPreference value
     * @param Currency $currencyPreference
     * @return UserPropertyBase
     */
    public function setCurrencyPreference(Currency $currencyPreference = null)
    {
        $this->CurrencyPreference = $currencyPreference;
        return $this;
    }
    /**
     * Get TimeZonePreferenceId value
     * @return string|null
     */
    public function getTimeZonePreferenceId()
    {
        return $this->TimeZonePreferenceId;
    }
    /**
     * Set TimeZonePreferenceId value
     * @param string $timeZonePreferenceId
     * @return UserPropertyBase
     */
    public function setTimeZonePreferenceId($timeZonePreferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($timeZonePreferenceId) && !is_string($timeZonePreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeZonePreferenceId)), __LINE__);
        }
        $this->TimeZonePreferenceId = $timeZonePreferenceId;
        return $this;
    }
    /**
     * Get TimeZonePreference value
     * @return TimeZone|null
     */
    public function getTimeZonePreference()
    {
        return $this->TimeZonePreference;
    }
    /**
     * Set TimeZonePreference value
     * @param TimeZone $timeZonePreference
     * @return UserPropertyBase
     */
    public function setTimeZonePreference(TimeZone $timeZonePreference = null)
    {
        $this->TimeZonePreference = $timeZonePreference;
        return $this;
    }
    /**
     * Get AddressCity value
     * @return string|null
     */
    public function getAddressCity()
    {
        return $this->AddressCity;
    }
    /**
     * Set AddressCity value
     * @param string $addressCity
     * @return UserPropertyBase
     */
    public function setAddressCity($addressCity = null)
    {
        // validation for constraint: string
        if (!is_null($addressCity) && !is_string($addressCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressCity)), __LINE__);
        }
        $this->AddressCity = $addressCity;
        return $this;
    }
    /**
     * Get AddressCountry value
     * @return string|null
     */
    public function getAddressCountry()
    {
        return $this->AddressCountry;
    }
    /**
     * Set AddressCountry value
     * @param string $addressCountry
     * @return UserPropertyBase
     */
    public function setAddressCountry($addressCountry = null)
    {
        // validation for constraint: string
        if (!is_null($addressCountry) && !is_string($addressCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressCountry)), __LINE__);
        }
        $this->AddressCountry = $addressCountry;
        return $this;
    }
    /**
     * Get AddressFax value
     * @return string|null
     */
    public function getAddressFax()
    {
        return $this->AddressFax;
    }
    /**
     * Set AddressFax value
     * @param string $addressFax
     * @return UserPropertyBase
     */
    public function setAddressFax($addressFax = null)
    {
        // validation for constraint: string
        if (!is_null($addressFax) && !is_string($addressFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressFax)), __LINE__);
        }
        $this->AddressFax = $addressFax;
        return $this;
    }
    /**
     * Get AddressPhone1 value
     * @return string|null
     */
    public function getAddressPhone1()
    {
        return $this->AddressPhone1;
    }
    /**
     * Set AddressPhone1 value
     * @param string $addressPhone1
     * @return UserPropertyBase
     */
    public function setAddressPhone1($addressPhone1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressPhone1) && !is_string($addressPhone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressPhone1)), __LINE__);
        }
        $this->AddressPhone1 = $addressPhone1;
        return $this;
    }
    /**
     * Get AddressPhone2 value
     * @return string|null
     */
    public function getAddressPhone2()
    {
        return $this->AddressPhone2;
    }
    /**
     * Set AddressPhone2 value
     * @param string $addressPhone2
     * @return UserPropertyBase
     */
    public function setAddressPhone2($addressPhone2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressPhone2) && !is_string($addressPhone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressPhone2)), __LINE__);
        }
        $this->AddressPhone2 = $addressPhone2;
        return $this;
    }
    /**
     * Get AddressState value
     * @return string|null
     */
    public function getAddressState()
    {
        return $this->AddressState;
    }
    /**
     * Set AddressState value
     * @param string $addressState
     * @return UserPropertyBase
     */
    public function setAddressState($addressState = null)
    {
        // validation for constraint: string
        if (!is_null($addressState) && !is_string($addressState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressState)), __LINE__);
        }
        $this->AddressState = $addressState;
        return $this;
    }
    /**
     * Get AddressStreet1 value
     * @return string|null
     */
    public function getAddressStreet1()
    {
        return $this->AddressStreet1;
    }
    /**
     * Set AddressStreet1 value
     * @param string $addressStreet1
     * @return UserPropertyBase
     */
    public function setAddressStreet1($addressStreet1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressStreet1) && !is_string($addressStreet1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStreet1)), __LINE__);
        }
        $this->AddressStreet1 = $addressStreet1;
        return $this;
    }
    /**
     * Get AddressStreet2 value
     * @return string|null
     */
    public function getAddressStreet2()
    {
        return $this->AddressStreet2;
    }
    /**
     * Set AddressStreet2 value
     * @param string $addressStreet2
     * @return UserPropertyBase
     */
    public function setAddressStreet2($addressStreet2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressStreet2) && !is_string($addressStreet2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStreet2)), __LINE__);
        }
        $this->AddressStreet2 = $addressStreet2;
        return $this;
    }
    /**
     * Get AddressPostalCode value
     * @return string|null
     */
    public function getAddressPostalCode()
    {
        return $this->AddressPostalCode;
    }
    /**
     * Set AddressPostalCode value
     * @param string $addressPostalCode
     * @return UserPropertyBase
     */
    public function setAddressPostalCode($addressPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressPostalCode) && !is_string($addressPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressPostalCode)), __LINE__);
        }
        $this->AddressPostalCode = $addressPostalCode;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return UserPropertyBase
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return UserPropertyBase
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get WebexUserID value
     * @return string|null
     */
    public function getWebexUserID()
    {
        return $this->WebexUserID;
    }
    /**
     * Set WebexUserID value
     * @param string $webexUserID
     * @return UserPropertyBase
     */
    public function setWebexUserID($webexUserID = null)
    {
        // validation for constraint: string
        if (!is_null($webexUserID) && !is_string($webexUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($webexUserID)), __LINE__);
        }
        $this->WebexUserID = $webexUserID;
        return $this;
    }
    /**
     * Get WebexPassword value
     * @return string|null
     */
    public function getWebexPassword()
    {
        return $this->WebexPassword;
    }
    /**
     * Set WebexPassword value
     * @param string $webexPassword
     * @return UserPropertyBase
     */
    public function setWebexPassword($webexPassword = null)
    {
        // validation for constraint: string
        if (!is_null($webexPassword) && !is_string($webexPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($webexPassword)), __LINE__);
        }
        $this->WebexPassword = $webexPassword;
        return $this;
    }
    /**
     * Get ImageID value
     * @return string|null
     */
    public function getImageID()
    {
        return $this->ImageID;
    }
    /**
     * Set ImageID value
     * @param string $imageID
     * @return UserPropertyBase
     */
    public function setImageID($imageID = null)
    {
        // validation for constraint: string
        if (!is_null($imageID) && !is_string($imageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageID)), __LINE__);
        }
        $this->ImageID = $imageID;
        return $this;
    }
    /**
     * Get OptText1 value
     * @return string|null
     */
    public function getOptText1()
    {
        return $this->OptText1;
    }
    /**
     * Set OptText1 value
     * @param string $optText1
     * @return UserPropertyBase
     */
    public function setOptText1($optText1 = null)
    {
        // validation for constraint: string
        if (!is_null($optText1) && !is_string($optText1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText1)), __LINE__);
        }
        $this->OptText1 = $optText1;
        return $this;
    }
    /**
     * Get OptText2 value
     * @return string|null
     */
    public function getOptText2()
    {
        return $this->OptText2;
    }
    /**
     * Set OptText2 value
     * @param string $optText2
     * @return UserPropertyBase
     */
    public function setOptText2($optText2 = null)
    {
        // validation for constraint: string
        if (!is_null($optText2) && !is_string($optText2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText2)), __LINE__);
        }
        $this->OptText2 = $optText2;
        return $this;
    }
    /**
     * Get OptText3 value
     * @return string|null
     */
    public function getOptText3()
    {
        return $this->OptText3;
    }
    /**
     * Set OptText3 value
     * @param string $optText3
     * @return UserPropertyBase
     */
    public function setOptText3($optText3 = null)
    {
        // validation for constraint: string
        if (!is_null($optText3) && !is_string($optText3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText3)), __LINE__);
        }
        $this->OptText3 = $optText3;
        return $this;
    }
    /**
     * Get OptText4 value
     * @return string|null
     */
    public function getOptText4()
    {
        return $this->OptText4;
    }
    /**
     * Set OptText4 value
     * @param string $optText4
     * @return UserPropertyBase
     */
    public function setOptText4($optText4 = null)
    {
        // validation for constraint: string
        if (!is_null($optText4) && !is_string($optText4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText4)), __LINE__);
        }
        $this->OptText4 = $optText4;
        return $this;
    }
    /**
     * Get OptMemo1 value
     * @return string|null
     */
    public function getOptMemo1()
    {
        return $this->OptMemo1;
    }
    /**
     * Set OptMemo1 value
     * @param string $optMemo1
     * @return UserPropertyBase
     */
    public function setOptMemo1($optMemo1 = null)
    {
        // validation for constraint: string
        if (!is_null($optMemo1) && !is_string($optMemo1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optMemo1)), __LINE__);
        }
        $this->OptMemo1 = $optMemo1;
        return $this;
    }
    /**
     * Get OptCurrencyId value
     * @return string|null
     */
    public function getOptCurrencyId()
    {
        return $this->OptCurrencyId;
    }
    /**
     * Set OptCurrencyId value
     * @param string $optCurrencyId
     * @return UserPropertyBase
     */
    public function setOptCurrencyId($optCurrencyId = null)
    {
        // validation for constraint: string
        if (!is_null($optCurrencyId) && !is_string($optCurrencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optCurrencyId)), __LINE__);
        }
        $this->OptCurrencyId = $optCurrencyId;
        return $this;
    }
    /**
     * Get OptCurrency value
     * @return Currency|null
     */
    public function getOptCurrency()
    {
        return $this->OptCurrency;
    }
    /**
     * Set OptCurrency value
     * @param Currency $optCurrency
     * @return UserPropertyBase
     */
    public function setOptCurrency(Currency $optCurrency = null)
    {
        $this->OptCurrency = $optCurrency;
        return $this;
    }
    /**
     * Get ApproverLevel1Id value
     * @return string|null
     */
    public function getApproverLevel1Id()
    {
        return $this->ApproverLevel1Id;
    }
    /**
     * Set ApproverLevel1Id value
     * @param string $approverLevel1Id
     * @return UserPropertyBase
     */
    public function setApproverLevel1Id($approverLevel1Id = null)
    {
        // validation for constraint: string
        if (!is_null($approverLevel1Id) && !is_string($approverLevel1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approverLevel1Id)), __LINE__);
        }
        $this->ApproverLevel1Id = $approverLevel1Id;
        return $this;
    }
    /**
     * Get ApproverLevel1 value
     * @return User|null
     */
    public function getApproverLevel1()
    {
        return $this->ApproverLevel1;
    }
    /**
     * Set ApproverLevel1 value
     * @param User $approverLevel1
     * @return UserPropertyBase
     */
    public function setApproverLevel1(User $approverLevel1 = null)
    {
        $this->ApproverLevel1 = $approverLevel1;
        return $this;
    }
    /**
     * Get ApproverLevel2Id value
     * @return string|null
     */
    public function getApproverLevel2Id()
    {
        return $this->ApproverLevel2Id;
    }
    /**
     * Set ApproverLevel2Id value
     * @param string $approverLevel2Id
     * @return UserPropertyBase
     */
    public function setApproverLevel2Id($approverLevel2Id = null)
    {
        // validation for constraint: string
        if (!is_null($approverLevel2Id) && !is_string($approverLevel2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approverLevel2Id)), __LINE__);
        }
        $this->ApproverLevel2Id = $approverLevel2Id;
        return $this;
    }
    /**
     * Get ApproverLevel2 value
     * @return User|null
     */
    public function getApproverLevel2()
    {
        return $this->ApproverLevel2;
    }
    /**
     * Set ApproverLevel2 value
     * @param User $approverLevel2
     * @return UserPropertyBase
     */
    public function setApproverLevel2(User $approverLevel2 = null)
    {
        $this->ApproverLevel2 = $approverLevel2;
        return $this;
    }
    /**
     * Get ApproverLevel3Id value
     * @return string|null
     */
    public function getApproverLevel3Id()
    {
        return $this->ApproverLevel3Id;
    }
    /**
     * Set ApproverLevel3Id value
     * @param string $approverLevel3Id
     * @return UserPropertyBase
     */
    public function setApproverLevel3Id($approverLevel3Id = null)
    {
        // validation for constraint: string
        if (!is_null($approverLevel3Id) && !is_string($approverLevel3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approverLevel3Id)), __LINE__);
        }
        $this->ApproverLevel3Id = $approverLevel3Id;
        return $this;
    }
    /**
     * Get ApproverLevel3 value
     * @return User|null
     */
    public function getApproverLevel3()
    {
        return $this->ApproverLevel3;
    }
    /**
     * Set ApproverLevel3 value
     * @param User $approverLevel3
     * @return UserPropertyBase
     */
    public function setApproverLevel3(User $approverLevel3 = null)
    {
        $this->ApproverLevel3 = $approverLevel3;
        return $this;
    }
    /**
     * Get ApproverLevel4Id value
     * @return string|null
     */
    public function getApproverLevel4Id()
    {
        return $this->ApproverLevel4Id;
    }
    /**
     * Set ApproverLevel4Id value
     * @param string $approverLevel4Id
     * @return UserPropertyBase
     */
    public function setApproverLevel4Id($approverLevel4Id = null)
    {
        // validation for constraint: string
        if (!is_null($approverLevel4Id) && !is_string($approverLevel4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approverLevel4Id)), __LINE__);
        }
        $this->ApproverLevel4Id = $approverLevel4Id;
        return $this;
    }
    /**
     * Get ApproverLevel4 value
     * @return User|null
     */
    public function getApproverLevel4()
    {
        return $this->ApproverLevel4;
    }
    /**
     * Set ApproverLevel4 value
     * @param User $approverLevel4
     * @return UserPropertyBase
     */
    public function setApproverLevel4(User $approverLevel4 = null)
    {
        $this->ApproverLevel4 = $approverLevel4;
        return $this;
    }
    /**
     * Get AgencySubElementCode value
     * @return string|null
     */
    public function getAgencySubElementCode()
    {
        return $this->AgencySubElementCode;
    }
    /**
     * Set AgencySubElementCode value
     * @param string $agencySubElementCode
     * @return UserPropertyBase
     */
    public function setAgencySubElementCode($agencySubElementCode = null)
    {
        // validation for constraint: string
        if (!is_null($agencySubElementCode) && !is_string($agencySubElementCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencySubElementCode)), __LINE__);
        }
        $this->AgencySubElementCode = $agencySubElementCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UserPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
