<?php
/**
 * This class stands for SuccessStatus EnumType
 * @subpackage Enumerations
 */
class SuccessStatus
{
    /**
     * Constant for value 'Fail'
     * @return string 'Fail'
     */
    const VALUE_FAIL = 'Fail';
    /**
     * Constant for value 'Pass'
     * @return string 'Pass'
     */
    const VALUE_PASS = 'Pass';
    /**
     * Constant for value 'UnsupportedValue'
     * @return string 'UnsupportedValue'
     */
    const VALUE_UNSUPPORTED_VALUE = 'UnsupportedValue';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FAIL
     * @uses self::VALUE_PASS
     * @uses self::VALUE_UNSUPPORTED_VALUE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FAIL,
            self::VALUE_PASS,
            self::VALUE_UNSUPPORTED_VALUE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
