<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SkillSharedDomainPropertyBase StructType
 * @subpackage Structs
 */
abstract class SkillSharedDomainPropertyBase extends Entity
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The SkillId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SkillId;
    /**
     * The Skill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Skill
     */
    public $Skill;
    /**
     * The DomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainId;
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Domain
     */
    public $Domain;
    /**
     * Constructor method for SkillSharedDomainPropertyBase
     * @uses SkillSharedDomainPropertyBase::setId()
     * @uses SkillSharedDomainPropertyBase::setSkillId()
     * @uses SkillSharedDomainPropertyBase::setSkill()
     * @uses SkillSharedDomainPropertyBase::setDomainId()
     * @uses SkillSharedDomainPropertyBase::setDomain()
     * @param string $id
     * @param string $skillId
     * @param Skill $skill
     * @param string $domainId
     * @param Domain $domain
     */
    public function __construct($id = null, $skillId = null, Skill $skill = null, $domainId = null, Domain $domain = null)
    {
        $this
            ->setId($id)
            ->setSkillId($skillId)
            ->setSkill($skill)
            ->setDomainId($domainId)
            ->setDomain($domain);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return SkillSharedDomainPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get SkillId value
     * @return string|null
     */
    public function getSkillId()
    {
        return $this->SkillId;
    }
    /**
     * Set SkillId value
     * @param string $skillId
     * @return SkillSharedDomainPropertyBase
     */
    public function setSkillId($skillId = null)
    {
        // validation for constraint: string
        if (!is_null($skillId) && !is_string($skillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($skillId)), __LINE__);
        }
        $this->SkillId = $skillId;
        return $this;
    }
    /**
     * Get Skill value
     * @return Skill|null
     */
    public function getSkill()
    {
        return $this->Skill;
    }
    /**
     * Set Skill value
     * @param Skill $skill
     * @return SkillSharedDomainPropertyBase
     */
    public function setSkill(Skill $skill = null)
    {
        $this->Skill = $skill;
        return $this;
    }
    /**
     * Get DomainId value
     * @return string|null
     */
    public function getDomainId()
    {
        return $this->DomainId;
    }
    /**
     * Set DomainId value
     * @param string $domainId
     * @return SkillSharedDomainPropertyBase
     */
    public function setDomainId($domainId = null)
    {
        // validation for constraint: string
        if (!is_null($domainId) && !is_string($domainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainId)), __LINE__);
        }
        $this->DomainId = $domainId;
        return $this;
    }
    /**
     * Get Domain value
     * @return Domain|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param Domain $domain
     * @return SkillSharedDomainPropertyBase
     */
    public function setDomain(Domain $domain = null)
    {
        $this->Domain = $domain;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return SkillSharedDomainPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
