<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Sets the UserSecurityContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param UserSecurityContext $userSecurityContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserSecurityContext(UserSecurityContext $userSecurityContext, $nameSpace = 'http://www.sumtotalsystems.com/sumtotal7/sumtotalws/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserSecurityContext', $userSecurityContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SearchUsersByPath
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SearchUsersByPath $parameters
     * @return SearchUsersByPathResponse|bool
     */
    public function SearchUsersByPath(SearchUsersByPath $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchUsersByPath($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return SearchUsersByPathResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
