<?php
/**
 * This class stands for RegistrationStatus EnumType
 * @subpackage Enumerations
 */
class RegistrationStatus
{
    /**
     * Constant for value 'Registered'
     * @return string 'Registered'
     */
    const VALUE_REGISTERED = 'Registered';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'OnWaitlist'
     * @return string 'OnWaitlist'
     */
    const VALUE_ON_WAITLIST = 'OnWaitlist';
    /**
     * Constant for value 'HoldForApproval'
     * @return string 'HoldForApproval'
     */
    const VALUE_HOLD_FOR_APPROVAL = 'HoldForApproval';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'NoShow'
     * @return string 'NoShow'
     */
    const VALUE_NO_SHOW = 'NoShow';
    /**
     * Constant for value 'ReservedWaitList'
     * @return string 'ReservedWaitList'
     */
    const VALUE_RESERVED_WAIT_LIST = 'ReservedWaitList';
    /**
     * Constant for value 'ExpiredWaitList'
     * @return string 'ExpiredWaitList'
     */
    const VALUE_EXPIRED_WAIT_LIST = 'ExpiredWaitList';
    /**
     * Constant for value 'Replaced'
     * @return string 'Replaced'
     */
    const VALUE_REPLACED = 'Replaced';
    /**
     * Constant for value 'Waived'
     * @return string 'Waived'
     */
    const VALUE_WAIVED = 'Waived';
    /**
     * Constant for value 'InProgress'
     * @return string 'InProgress'
     */
    const VALUE_IN_PROGRESS = 'InProgress';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REGISTERED
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_ON_WAITLIST
     * @uses self::VALUE_HOLD_FOR_APPROVAL
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_NO_SHOW
     * @uses self::VALUE_RESERVED_WAIT_LIST
     * @uses self::VALUE_EXPIRED_WAIT_LIST
     * @uses self::VALUE_REPLACED
     * @uses self::VALUE_WAIVED
     * @uses self::VALUE_IN_PROGRESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGISTERED,
            self::VALUE_CANCELLED,
            self::VALUE_ON_WAITLIST,
            self::VALUE_HOLD_FOR_APPROVAL,
            self::VALUE_COMPLETED,
            self::VALUE_NO_SHOW,
            self::VALUE_RESERVED_WAIT_LIST,
            self::VALUE_EXPIRED_WAIT_LIST,
            self::VALUE_REPLACED,
            self::VALUE_WAIVED,
            self::VALUE_IN_PROGRESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
