<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrganizationUserPropertyBase StructType
 * @subpackage Structs
 */
abstract class OrganizationUserPropertyBase extends Entity
{
    /**
     * The IsPrimaryOrganization
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPrimaryOrganization;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The OrganizationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrganizationId;
    /**
     * The Organization
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Organization
     */
    public $Organization;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserId;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $User;
    /**
     * Constructor method for OrganizationUserPropertyBase
     * @uses OrganizationUserPropertyBase::setIsPrimaryOrganization()
     * @uses OrganizationUserPropertyBase::setId()
     * @uses OrganizationUserPropertyBase::setOrganizationId()
     * @uses OrganizationUserPropertyBase::setOrganization()
     * @uses OrganizationUserPropertyBase::setUserId()
     * @uses OrganizationUserPropertyBase::setUser()
     * @param bool $isPrimaryOrganization
     * @param string $id
     * @param string $organizationId
     * @param Organization $organization
     * @param string $userId
     * @param User $user
     */
    public function __construct($isPrimaryOrganization = null, $id = null, $organizationId = null, Organization $organization = null, $userId = null, User $user = null)
    {
        $this
            ->setIsPrimaryOrganization($isPrimaryOrganization)
            ->setId($id)
            ->setOrganizationId($organizationId)
            ->setOrganization($organization)
            ->setUserId($userId)
            ->setUser($user);
    }
    /**
     * Get IsPrimaryOrganization value
     * @return bool
     */
    public function getIsPrimaryOrganization()
    {
        return $this->IsPrimaryOrganization;
    }
    /**
     * Set IsPrimaryOrganization value
     * @param bool $isPrimaryOrganization
     * @return OrganizationUserPropertyBase
     */
    public function setIsPrimaryOrganization($isPrimaryOrganization = null)
    {
        $this->IsPrimaryOrganization = $isPrimaryOrganization;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return OrganizationUserPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get OrganizationId value
     * @return string|null
     */
    public function getOrganizationId()
    {
        return $this->OrganizationId;
    }
    /**
     * Set OrganizationId value
     * @param string $organizationId
     * @return OrganizationUserPropertyBase
     */
    public function setOrganizationId($organizationId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationId) && !is_string($organizationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organizationId)), __LINE__);
        }
        $this->OrganizationId = $organizationId;
        return $this;
    }
    /**
     * Get Organization value
     * @return Organization|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param Organization $organization
     * @return OrganizationUserPropertyBase
     */
    public function setOrganization(Organization $organization = null)
    {
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return OrganizationUserPropertyBase
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get User value
     * @return User|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param User $user
     * @return OrganizationUserPropertyBase
     */
    public function setUser(User $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return OrganizationUserPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
