<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquipmentPropertyBase StructType
 * @subpackage Structs
 */
abstract class EquipmentPropertyBase extends Entity
{
    /**
     * The RequiresApproval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RequiresApproval;
    /**
     * The OptDate1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $OptDate1;
    /**
     * The OptDate2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $OptDate2;
    /**
     * The OptYesNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OptYesNo;
    /**
     * The OptMoney
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $OptMoney;
    /**
     * The OptInteger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $OptInteger;
    /**
     * The OptFloat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDouble
     */
    public $OptFloat;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * The Model
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Model;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The PersonnelEMail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonnelEMail;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The DomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainId;
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Domain
     */
    public $Domain;
    /**
     * The LocationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationId;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Location
     */
    public $Location;
    /**
     * The EquipmentTypeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EquipmentTypeId;
    /**
     * The EquipmentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EquipmentType
     */
    public $EquipmentType;
    /**
     * The ApproverId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApproverId;
    /**
     * The Approver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $Approver;
    /**
     * The OptText1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText1;
    /**
     * The OptText2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText2;
    /**
     * The OptText3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText3;
    /**
     * The OptText4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText4;
    /**
     * The OptMemo1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptMemo1;
    /**
     * The OptCurrencyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptCurrencyId;
    /**
     * The OptCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Currency
     */
    public $OptCurrency;
    /**
     * Constructor method for EquipmentPropertyBase
     * @uses EquipmentPropertyBase::setRequiresApproval()
     * @uses EquipmentPropertyBase::setOptDate1()
     * @uses EquipmentPropertyBase::setOptDate2()
     * @uses EquipmentPropertyBase::setOptYesNo()
     * @uses EquipmentPropertyBase::setOptMoney()
     * @uses EquipmentPropertyBase::setOptInteger()
     * @uses EquipmentPropertyBase::setOptFloat()
     * @uses EquipmentPropertyBase::setId()
     * @uses EquipmentPropertyBase::setName()
     * @uses EquipmentPropertyBase::setSerialNumber()
     * @uses EquipmentPropertyBase::setModel()
     * @uses EquipmentPropertyBase::setUrl()
     * @uses EquipmentPropertyBase::setPersonnelEMail()
     * @uses EquipmentPropertyBase::setDescription()
     * @uses EquipmentPropertyBase::setNotes()
     * @uses EquipmentPropertyBase::setDomainId()
     * @uses EquipmentPropertyBase::setDomain()
     * @uses EquipmentPropertyBase::setLocationId()
     * @uses EquipmentPropertyBase::setLocation()
     * @uses EquipmentPropertyBase::setEquipmentTypeId()
     * @uses EquipmentPropertyBase::setEquipmentType()
     * @uses EquipmentPropertyBase::setApproverId()
     * @uses EquipmentPropertyBase::setApprover()
     * @uses EquipmentPropertyBase::setOptText1()
     * @uses EquipmentPropertyBase::setOptText2()
     * @uses EquipmentPropertyBase::setOptText3()
     * @uses EquipmentPropertyBase::setOptText4()
     * @uses EquipmentPropertyBase::setOptMemo1()
     * @uses EquipmentPropertyBase::setOptCurrencyId()
     * @uses EquipmentPropertyBase::setOptCurrency()
     * @param int $requiresApproval
     * @param NullableDateTime $optDate1
     * @param NullableDateTime $optDate2
     * @param bool $optYesNo
     * @param NullableDecimal $optMoney
     * @param NullableInt32 $optInteger
     * @param NullableDouble $optFloat
     * @param string $id
     * @param string $name
     * @param string $serialNumber
     * @param string $model
     * @param string $url
     * @param string $personnelEMail
     * @param string $description
     * @param string $notes
     * @param string $domainId
     * @param Domain $domain
     * @param string $locationId
     * @param Location $location
     * @param string $equipmentTypeId
     * @param EquipmentType $equipmentType
     * @param string $approverId
     * @param User $approver
     * @param string $optText1
     * @param string $optText2
     * @param string $optText3
     * @param string $optText4
     * @param string $optMemo1
     * @param string $optCurrencyId
     * @param Currency $optCurrency
     */
    public function __construct($requiresApproval = null, NullableDateTime $optDate1 = null, NullableDateTime $optDate2 = null, $optYesNo = null, NullableDecimal $optMoney = null, NullableInt32 $optInteger = null, NullableDouble $optFloat = null, $id = null, $name = null, $serialNumber = null, $model = null, $url = null, $personnelEMail = null, $description = null, $notes = null, $domainId = null, Domain $domain = null, $locationId = null, Location $location = null, $equipmentTypeId = null, EquipmentType $equipmentType = null, $approverId = null, User $approver = null, $optText1 = null, $optText2 = null, $optText3 = null, $optText4 = null, $optMemo1 = null, $optCurrencyId = null, Currency $optCurrency = null)
    {
        $this
            ->setRequiresApproval($requiresApproval)
            ->setOptDate1($optDate1)
            ->setOptDate2($optDate2)
            ->setOptYesNo($optYesNo)
            ->setOptMoney($optMoney)
            ->setOptInteger($optInteger)
            ->setOptFloat($optFloat)
            ->setId($id)
            ->setName($name)
            ->setSerialNumber($serialNumber)
            ->setModel($model)
            ->setUrl($url)
            ->setPersonnelEMail($personnelEMail)
            ->setDescription($description)
            ->setNotes($notes)
            ->setDomainId($domainId)
            ->setDomain($domain)
            ->setLocationId($locationId)
            ->setLocation($location)
            ->setEquipmentTypeId($equipmentTypeId)
            ->setEquipmentType($equipmentType)
            ->setApproverId($approverId)
            ->setApprover($approver)
            ->setOptText1($optText1)
            ->setOptText2($optText2)
            ->setOptText3($optText3)
            ->setOptText4($optText4)
            ->setOptMemo1($optMemo1)
            ->setOptCurrencyId($optCurrencyId)
            ->setOptCurrency($optCurrency);
    }
    /**
     * Get RequiresApproval value
     * @return int
     */
    public function getRequiresApproval()
    {
        return $this->RequiresApproval;
    }
    /**
     * Set RequiresApproval value
     * @param int $requiresApproval
     * @return EquipmentPropertyBase
     */
    public function setRequiresApproval($requiresApproval = null)
    {
        // validation for constraint: int
        if (!is_null($requiresApproval) && !is_numeric($requiresApproval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requiresApproval)), __LINE__);
        }
        $this->RequiresApproval = $requiresApproval;
        return $this;
    }
    /**
     * Get OptDate1 value
     * @return NullableDateTime
     */
    public function getOptDate1()
    {
        return $this->OptDate1;
    }
    /**
     * Set OptDate1 value
     * @param NullableDateTime $optDate1
     * @return EquipmentPropertyBase
     */
    public function setOptDate1(NullableDateTime $optDate1 = null)
    {
        $this->OptDate1 = $optDate1;
        return $this;
    }
    /**
     * Get OptDate2 value
     * @return NullableDateTime
     */
    public function getOptDate2()
    {
        return $this->OptDate2;
    }
    /**
     * Set OptDate2 value
     * @param NullableDateTime $optDate2
     * @return EquipmentPropertyBase
     */
    public function setOptDate2(NullableDateTime $optDate2 = null)
    {
        $this->OptDate2 = $optDate2;
        return $this;
    }
    /**
     * Get OptYesNo value
     * @return bool
     */
    public function getOptYesNo()
    {
        return $this->OptYesNo;
    }
    /**
     * Set OptYesNo value
     * @param bool $optYesNo
     * @return EquipmentPropertyBase
     */
    public function setOptYesNo($optYesNo = null)
    {
        $this->OptYesNo = $optYesNo;
        return $this;
    }
    /**
     * Get OptMoney value
     * @return NullableDecimal
     */
    public function getOptMoney()
    {
        return $this->OptMoney;
    }
    /**
     * Set OptMoney value
     * @param NullableDecimal $optMoney
     * @return EquipmentPropertyBase
     */
    public function setOptMoney(NullableDecimal $optMoney = null)
    {
        $this->OptMoney = $optMoney;
        return $this;
    }
    /**
     * Get OptInteger value
     * @return NullableInt32
     */
    public function getOptInteger()
    {
        return $this->OptInteger;
    }
    /**
     * Set OptInteger value
     * @param NullableInt32 $optInteger
     * @return EquipmentPropertyBase
     */
    public function setOptInteger(NullableInt32 $optInteger = null)
    {
        $this->OptInteger = $optInteger;
        return $this;
    }
    /**
     * Get OptFloat value
     * @return NullableDouble
     */
    public function getOptFloat()
    {
        return $this->OptFloat;
    }
    /**
     * Set OptFloat value
     * @param NullableDouble $optFloat
     * @return EquipmentPropertyBase
     */
    public function setOptFloat(NullableDouble $optFloat = null)
    {
        $this->OptFloat = $optFloat;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return EquipmentPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return EquipmentPropertyBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return EquipmentPropertyBase
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get Model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->Model;
    }
    /**
     * Set Model value
     * @param string $model
     * @return EquipmentPropertyBase
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($model)), __LINE__);
        }
        $this->Model = $model;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return EquipmentPropertyBase
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get PersonnelEMail value
     * @return string|null
     */
    public function getPersonnelEMail()
    {
        return $this->PersonnelEMail;
    }
    /**
     * Set PersonnelEMail value
     * @param string $personnelEMail
     * @return EquipmentPropertyBase
     */
    public function setPersonnelEMail($personnelEMail = null)
    {
        // validation for constraint: string
        if (!is_null($personnelEMail) && !is_string($personnelEMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personnelEMail)), __LINE__);
        }
        $this->PersonnelEMail = $personnelEMail;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return EquipmentPropertyBase
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return EquipmentPropertyBase
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get DomainId value
     * @return string|null
     */
    public function getDomainId()
    {
        return $this->DomainId;
    }
    /**
     * Set DomainId value
     * @param string $domainId
     * @return EquipmentPropertyBase
     */
    public function setDomainId($domainId = null)
    {
        // validation for constraint: string
        if (!is_null($domainId) && !is_string($domainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainId)), __LINE__);
        }
        $this->DomainId = $domainId;
        return $this;
    }
    /**
     * Get Domain value
     * @return Domain|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param Domain $domain
     * @return EquipmentPropertyBase
     */
    public function setDomain(Domain $domain = null)
    {
        $this->Domain = $domain;
        return $this;
    }
    /**
     * Get LocationId value
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->LocationId;
    }
    /**
     * Set LocationId value
     * @param string $locationId
     * @return EquipmentPropertyBase
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: string
        if (!is_null($locationId) && !is_string($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationId)), __LINE__);
        }
        $this->LocationId = $locationId;
        return $this;
    }
    /**
     * Get Location value
     * @return Location|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param Location $location
     * @return EquipmentPropertyBase
     */
    public function setLocation(Location $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get EquipmentTypeId value
     * @return string|null
     */
    public function getEquipmentTypeId()
    {
        return $this->EquipmentTypeId;
    }
    /**
     * Set EquipmentTypeId value
     * @param string $equipmentTypeId
     * @return EquipmentPropertyBase
     */
    public function setEquipmentTypeId($equipmentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentTypeId) && !is_string($equipmentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentTypeId)), __LINE__);
        }
        $this->EquipmentTypeId = $equipmentTypeId;
        return $this;
    }
    /**
     * Get EquipmentType value
     * @return EquipmentType|null
     */
    public function getEquipmentType()
    {
        return $this->EquipmentType;
    }
    /**
     * Set EquipmentType value
     * @param EquipmentType $equipmentType
     * @return EquipmentPropertyBase
     */
    public function setEquipmentType(EquipmentType $equipmentType = null)
    {
        $this->EquipmentType = $equipmentType;
        return $this;
    }
    /**
     * Get ApproverId value
     * @return string|null
     */
    public function getApproverId()
    {
        return $this->ApproverId;
    }
    /**
     * Set ApproverId value
     * @param string $approverId
     * @return EquipmentPropertyBase
     */
    public function setApproverId($approverId = null)
    {
        // validation for constraint: string
        if (!is_null($approverId) && !is_string($approverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approverId)), __LINE__);
        }
        $this->ApproverId = $approverId;
        return $this;
    }
    /**
     * Get Approver value
     * @return User|null
     */
    public function getApprover()
    {
        return $this->Approver;
    }
    /**
     * Set Approver value
     * @param User $approver
     * @return EquipmentPropertyBase
     */
    public function setApprover(User $approver = null)
    {
        $this->Approver = $approver;
        return $this;
    }
    /**
     * Get OptText1 value
     * @return string|null
     */
    public function getOptText1()
    {
        return $this->OptText1;
    }
    /**
     * Set OptText1 value
     * @param string $optText1
     * @return EquipmentPropertyBase
     */
    public function setOptText1($optText1 = null)
    {
        // validation for constraint: string
        if (!is_null($optText1) && !is_string($optText1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText1)), __LINE__);
        }
        $this->OptText1 = $optText1;
        return $this;
    }
    /**
     * Get OptText2 value
     * @return string|null
     */
    public function getOptText2()
    {
        return $this->OptText2;
    }
    /**
     * Set OptText2 value
     * @param string $optText2
     * @return EquipmentPropertyBase
     */
    public function setOptText2($optText2 = null)
    {
        // validation for constraint: string
        if (!is_null($optText2) && !is_string($optText2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText2)), __LINE__);
        }
        $this->OptText2 = $optText2;
        return $this;
    }
    /**
     * Get OptText3 value
     * @return string|null
     */
    public function getOptText3()
    {
        return $this->OptText3;
    }
    /**
     * Set OptText3 value
     * @param string $optText3
     * @return EquipmentPropertyBase
     */
    public function setOptText3($optText3 = null)
    {
        // validation for constraint: string
        if (!is_null($optText3) && !is_string($optText3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText3)), __LINE__);
        }
        $this->OptText3 = $optText3;
        return $this;
    }
    /**
     * Get OptText4 value
     * @return string|null
     */
    public function getOptText4()
    {
        return $this->OptText4;
    }
    /**
     * Set OptText4 value
     * @param string $optText4
     * @return EquipmentPropertyBase
     */
    public function setOptText4($optText4 = null)
    {
        // validation for constraint: string
        if (!is_null($optText4) && !is_string($optText4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText4)), __LINE__);
        }
        $this->OptText4 = $optText4;
        return $this;
    }
    /**
     * Get OptMemo1 value
     * @return string|null
     */
    public function getOptMemo1()
    {
        return $this->OptMemo1;
    }
    /**
     * Set OptMemo1 value
     * @param string $optMemo1
     * @return EquipmentPropertyBase
     */
    public function setOptMemo1($optMemo1 = null)
    {
        // validation for constraint: string
        if (!is_null($optMemo1) && !is_string($optMemo1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optMemo1)), __LINE__);
        }
        $this->OptMemo1 = $optMemo1;
        return $this;
    }
    /**
     * Get OptCurrencyId value
     * @return string|null
     */
    public function getOptCurrencyId()
    {
        return $this->OptCurrencyId;
    }
    /**
     * Set OptCurrencyId value
     * @param string $optCurrencyId
     * @return EquipmentPropertyBase
     */
    public function setOptCurrencyId($optCurrencyId = null)
    {
        // validation for constraint: string
        if (!is_null($optCurrencyId) && !is_string($optCurrencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optCurrencyId)), __LINE__);
        }
        $this->OptCurrencyId = $optCurrencyId;
        return $this;
    }
    /**
     * Get OptCurrency value
     * @return Currency|null
     */
    public function getOptCurrency()
    {
        return $this->OptCurrency;
    }
    /**
     * Set OptCurrency value
     * @param Currency $optCurrency
     * @return EquipmentPropertyBase
     */
    public function setOptCurrency(Currency $optCurrency = null)
    {
        $this->OptCurrency = $optCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return EquipmentPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
