<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompetencyPropertyBase StructType
 * @subpackage Structs
 */
abstract class CompetencyPropertyBase extends Entity
{
    /**
     * The OptDate1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $OptDate1;
    /**
     * The OptDate2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $OptDate2;
    /**
     * The OptYesNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OptYesNo;
    /**
     * The OptMoney
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $OptMoney;
    /**
     * The OptInteger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $OptInteger;
    /**
     * The OptFloat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDouble
     */
    public $OptFloat;
    /**
     * The RequiredSkills
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfCompetencyRequiredSkill
     */
    public $RequiredSkills;
    /**
     * The SharedDomains
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfCompetencySharedDomain
     */
    public $SharedDomains;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The QuestionStem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuestionStem;
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityId;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $Activity;
    /**
     * The DomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainId;
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Domain
     */
    public $Domain;
    /**
     * The DomainCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainCode;
    /**
     * The OptText1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText1;
    /**
     * The OptText2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText2;
    /**
     * The OptText3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText3;
    /**
     * The OptText4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText4;
    /**
     * The OptMemo1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptMemo1;
    /**
     * The OptCurrencyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptCurrencyId;
    /**
     * The OptCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Currency
     */
    public $OptCurrency;
    /**
     * Constructor method for CompetencyPropertyBase
     * @uses CompetencyPropertyBase::setOptDate1()
     * @uses CompetencyPropertyBase::setOptDate2()
     * @uses CompetencyPropertyBase::setOptYesNo()
     * @uses CompetencyPropertyBase::setOptMoney()
     * @uses CompetencyPropertyBase::setOptInteger()
     * @uses CompetencyPropertyBase::setOptFloat()
     * @uses CompetencyPropertyBase::setRequiredSkills()
     * @uses CompetencyPropertyBase::setSharedDomains()
     * @uses CompetencyPropertyBase::setId()
     * @uses CompetencyPropertyBase::setName()
     * @uses CompetencyPropertyBase::setDescription()
     * @uses CompetencyPropertyBase::setUrl()
     * @uses CompetencyPropertyBase::setQuestionStem()
     * @uses CompetencyPropertyBase::setActivityId()
     * @uses CompetencyPropertyBase::setActivity()
     * @uses CompetencyPropertyBase::setDomainId()
     * @uses CompetencyPropertyBase::setDomain()
     * @uses CompetencyPropertyBase::setDomainCode()
     * @uses CompetencyPropertyBase::setOptText1()
     * @uses CompetencyPropertyBase::setOptText2()
     * @uses CompetencyPropertyBase::setOptText3()
     * @uses CompetencyPropertyBase::setOptText4()
     * @uses CompetencyPropertyBase::setOptMemo1()
     * @uses CompetencyPropertyBase::setOptCurrencyId()
     * @uses CompetencyPropertyBase::setOptCurrency()
     * @param NullableDateTime $optDate1
     * @param NullableDateTime $optDate2
     * @param bool $optYesNo
     * @param NullableDecimal $optMoney
     * @param NullableInt32 $optInteger
     * @param NullableDouble $optFloat
     * @param ArrayOfCompetencyRequiredSkill $requiredSkills
     * @param ArrayOfCompetencySharedDomain $sharedDomains
     * @param string $id
     * @param string $name
     * @param string $description
     * @param string $url
     * @param string $questionStem
     * @param string $activityId
     * @param Activity $activity
     * @param string $domainId
     * @param Domain $domain
     * @param string $domainCode
     * @param string $optText1
     * @param string $optText2
     * @param string $optText3
     * @param string $optText4
     * @param string $optMemo1
     * @param string $optCurrencyId
     * @param Currency $optCurrency
     */
    public function __construct(NullableDateTime $optDate1 = null, NullableDateTime $optDate2 = null, $optYesNo = null, NullableDecimal $optMoney = null, NullableInt32 $optInteger = null, NullableDouble $optFloat = null, ArrayOfCompetencyRequiredSkill $requiredSkills = null, ArrayOfCompetencySharedDomain $sharedDomains = null, $id = null, $name = null, $description = null, $url = null, $questionStem = null, $activityId = null, Activity $activity = null, $domainId = null, Domain $domain = null, $domainCode = null, $optText1 = null, $optText2 = null, $optText3 = null, $optText4 = null, $optMemo1 = null, $optCurrencyId = null, Currency $optCurrency = null)
    {
        $this
            ->setOptDate1($optDate1)
            ->setOptDate2($optDate2)
            ->setOptYesNo($optYesNo)
            ->setOptMoney($optMoney)
            ->setOptInteger($optInteger)
            ->setOptFloat($optFloat)
            ->setRequiredSkills($requiredSkills)
            ->setSharedDomains($sharedDomains)
            ->setId($id)
            ->setName($name)
            ->setDescription($description)
            ->setUrl($url)
            ->setQuestionStem($questionStem)
            ->setActivityId($activityId)
            ->setActivity($activity)
            ->setDomainId($domainId)
            ->setDomain($domain)
            ->setDomainCode($domainCode)
            ->setOptText1($optText1)
            ->setOptText2($optText2)
            ->setOptText3($optText3)
            ->setOptText4($optText4)
            ->setOptMemo1($optMemo1)
            ->setOptCurrencyId($optCurrencyId)
            ->setOptCurrency($optCurrency);
    }
    /**
     * Get OptDate1 value
     * @return NullableDateTime
     */
    public function getOptDate1()
    {
        return $this->OptDate1;
    }
    /**
     * Set OptDate1 value
     * @param NullableDateTime $optDate1
     * @return CompetencyPropertyBase
     */
    public function setOptDate1(NullableDateTime $optDate1 = null)
    {
        $this->OptDate1 = $optDate1;
        return $this;
    }
    /**
     * Get OptDate2 value
     * @return NullableDateTime
     */
    public function getOptDate2()
    {
        return $this->OptDate2;
    }
    /**
     * Set OptDate2 value
     * @param NullableDateTime $optDate2
     * @return CompetencyPropertyBase
     */
    public function setOptDate2(NullableDateTime $optDate2 = null)
    {
        $this->OptDate2 = $optDate2;
        return $this;
    }
    /**
     * Get OptYesNo value
     * @return bool
     */
    public function getOptYesNo()
    {
        return $this->OptYesNo;
    }
    /**
     * Set OptYesNo value
     * @param bool $optYesNo
     * @return CompetencyPropertyBase
     */
    public function setOptYesNo($optYesNo = null)
    {
        $this->OptYesNo = $optYesNo;
        return $this;
    }
    /**
     * Get OptMoney value
     * @return NullableDecimal
     */
    public function getOptMoney()
    {
        return $this->OptMoney;
    }
    /**
     * Set OptMoney value
     * @param NullableDecimal $optMoney
     * @return CompetencyPropertyBase
     */
    public function setOptMoney(NullableDecimal $optMoney = null)
    {
        $this->OptMoney = $optMoney;
        return $this;
    }
    /**
     * Get OptInteger value
     * @return NullableInt32
     */
    public function getOptInteger()
    {
        return $this->OptInteger;
    }
    /**
     * Set OptInteger value
     * @param NullableInt32 $optInteger
     * @return CompetencyPropertyBase
     */
    public function setOptInteger(NullableInt32 $optInteger = null)
    {
        $this->OptInteger = $optInteger;
        return $this;
    }
    /**
     * Get OptFloat value
     * @return NullableDouble
     */
    public function getOptFloat()
    {
        return $this->OptFloat;
    }
    /**
     * Set OptFloat value
     * @param NullableDouble $optFloat
     * @return CompetencyPropertyBase
     */
    public function setOptFloat(NullableDouble $optFloat = null)
    {
        $this->OptFloat = $optFloat;
        return $this;
    }
    /**
     * Get RequiredSkills value
     * @return ArrayOfCompetencyRequiredSkill
     */
    public function getRequiredSkills()
    {
        return $this->RequiredSkills;
    }
    /**
     * Set RequiredSkills value
     * @param ArrayOfCompetencyRequiredSkill $requiredSkills
     * @return CompetencyPropertyBase
     */
    public function setRequiredSkills(ArrayOfCompetencyRequiredSkill $requiredSkills = null)
    {
        $this->RequiredSkills = $requiredSkills;
        return $this;
    }
    /**
     * Get SharedDomains value
     * @return ArrayOfCompetencySharedDomain
     */
    public function getSharedDomains()
    {
        return $this->SharedDomains;
    }
    /**
     * Set SharedDomains value
     * @param ArrayOfCompetencySharedDomain $sharedDomains
     * @return CompetencyPropertyBase
     */
    public function setSharedDomains(ArrayOfCompetencySharedDomain $sharedDomains = null)
    {
        $this->SharedDomains = $sharedDomains;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return CompetencyPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return CompetencyPropertyBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return CompetencyPropertyBase
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return CompetencyPropertyBase
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get QuestionStem value
     * @return string|null
     */
    public function getQuestionStem()
    {
        return $this->QuestionStem;
    }
    /**
     * Set QuestionStem value
     * @param string $questionStem
     * @return CompetencyPropertyBase
     */
    public function setQuestionStem($questionStem = null)
    {
        // validation for constraint: string
        if (!is_null($questionStem) && !is_string($questionStem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($questionStem)), __LINE__);
        }
        $this->QuestionStem = $questionStem;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return CompetencyPropertyBase
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get Activity value
     * @return Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param Activity $activity
     * @return CompetencyPropertyBase
     */
    public function setActivity(Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get DomainId value
     * @return string|null
     */
    public function getDomainId()
    {
        return $this->DomainId;
    }
    /**
     * Set DomainId value
     * @param string $domainId
     * @return CompetencyPropertyBase
     */
    public function setDomainId($domainId = null)
    {
        // validation for constraint: string
        if (!is_null($domainId) && !is_string($domainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainId)), __LINE__);
        }
        $this->DomainId = $domainId;
        return $this;
    }
    /**
     * Get Domain value
     * @return Domain|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param Domain $domain
     * @return CompetencyPropertyBase
     */
    public function setDomain(Domain $domain = null)
    {
        $this->Domain = $domain;
        return $this;
    }
    /**
     * Get DomainCode value
     * @return string|null
     */
    public function getDomainCode()
    {
        return $this->DomainCode;
    }
    /**
     * Set DomainCode value
     * @param string $domainCode
     * @return CompetencyPropertyBase
     */
    public function setDomainCode($domainCode = null)
    {
        // validation for constraint: string
        if (!is_null($domainCode) && !is_string($domainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainCode)), __LINE__);
        }
        $this->DomainCode = $domainCode;
        return $this;
    }
    /**
     * Get OptText1 value
     * @return string|null
     */
    public function getOptText1()
    {
        return $this->OptText1;
    }
    /**
     * Set OptText1 value
     * @param string $optText1
     * @return CompetencyPropertyBase
     */
    public function setOptText1($optText1 = null)
    {
        // validation for constraint: string
        if (!is_null($optText1) && !is_string($optText1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText1)), __LINE__);
        }
        $this->OptText1 = $optText1;
        return $this;
    }
    /**
     * Get OptText2 value
     * @return string|null
     */
    public function getOptText2()
    {
        return $this->OptText2;
    }
    /**
     * Set OptText2 value
     * @param string $optText2
     * @return CompetencyPropertyBase
     */
    public function setOptText2($optText2 = null)
    {
        // validation for constraint: string
        if (!is_null($optText2) && !is_string($optText2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText2)), __LINE__);
        }
        $this->OptText2 = $optText2;
        return $this;
    }
    /**
     * Get OptText3 value
     * @return string|null
     */
    public function getOptText3()
    {
        return $this->OptText3;
    }
    /**
     * Set OptText3 value
     * @param string $optText3
     * @return CompetencyPropertyBase
     */
    public function setOptText3($optText3 = null)
    {
        // validation for constraint: string
        if (!is_null($optText3) && !is_string($optText3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText3)), __LINE__);
        }
        $this->OptText3 = $optText3;
        return $this;
    }
    /**
     * Get OptText4 value
     * @return string|null
     */
    public function getOptText4()
    {
        return $this->OptText4;
    }
    /**
     * Set OptText4 value
     * @param string $optText4
     * @return CompetencyPropertyBase
     */
    public function setOptText4($optText4 = null)
    {
        // validation for constraint: string
        if (!is_null($optText4) && !is_string($optText4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText4)), __LINE__);
        }
        $this->OptText4 = $optText4;
        return $this;
    }
    /**
     * Get OptMemo1 value
     * @return string|null
     */
    public function getOptMemo1()
    {
        return $this->OptMemo1;
    }
    /**
     * Set OptMemo1 value
     * @param string $optMemo1
     * @return CompetencyPropertyBase
     */
    public function setOptMemo1($optMemo1 = null)
    {
        // validation for constraint: string
        if (!is_null($optMemo1) && !is_string($optMemo1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optMemo1)), __LINE__);
        }
        $this->OptMemo1 = $optMemo1;
        return $this;
    }
    /**
     * Get OptCurrencyId value
     * @return string|null
     */
    public function getOptCurrencyId()
    {
        return $this->OptCurrencyId;
    }
    /**
     * Set OptCurrencyId value
     * @param string $optCurrencyId
     * @return CompetencyPropertyBase
     */
    public function setOptCurrencyId($optCurrencyId = null)
    {
        // validation for constraint: string
        if (!is_null($optCurrencyId) && !is_string($optCurrencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optCurrencyId)), __LINE__);
        }
        $this->OptCurrencyId = $optCurrencyId;
        return $this;
    }
    /**
     * Get OptCurrency value
     * @return Currency|null
     */
    public function getOptCurrency()
    {
        return $this->OptCurrency;
    }
    /**
     * Set OptCurrency value
     * @param Currency $optCurrency
     * @return CompetencyPropertyBase
     */
    public function setOptCurrency(Currency $optCurrency = null)
    {
        $this->OptCurrency = $optCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return CompetencyPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
