<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonRelation ArrayType
 * @subpackage Arrays
 */
class ArrayOfPersonRelation extends AbstractStructArrayBase
{
    /**
     * The PersonRelation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var PersonRelation[]
     */
    public $PersonRelation;
    /**
     * Constructor method for ArrayOfPersonRelation
     * @uses ArrayOfPersonRelation::setPersonRelation()
     * @param PersonRelation[] $personRelation
     */
    public function __construct(array $personRelation = array())
    {
        $this
            ->setPersonRelation($personRelation);
    }
    /**
     * Get PersonRelation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return PersonRelation[]|null
     */
    public function getPersonRelation()
    {
        return isset($this->PersonRelation) ? $this->PersonRelation : null;
    }
    /**
     * Set PersonRelation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param PersonRelation[] $personRelation
     * @return ArrayOfPersonRelation
     */
    public function setPersonRelation(array $personRelation = array())
    {
        foreach ($personRelation as $arrayOfPersonRelationPersonRelationItem) {
            // validation for constraint: itemType
            if (!$arrayOfPersonRelationPersonRelationItem instanceof PersonRelation) {
                throw new \InvalidArgumentException(sprintf('The PersonRelation property can only contain items of PersonRelation, "%s" given', is_object($arrayOfPersonRelationPersonRelationItem) ? get_class($arrayOfPersonRelationPersonRelationItem) : gettype($arrayOfPersonRelationPersonRelationItem)), __LINE__);
            }
        }
        if (is_null($personRelation) || (is_array($personRelation) && empty($personRelation))) {
            unset($this->PersonRelation);
        } else {
            $this->PersonRelation = $personRelation;
        }
        return $this;
    }
    /**
     * Add item to PersonRelation value
     * @throws \InvalidArgumentException
     * @param PersonRelation $item
     * @return ArrayOfPersonRelation
     */
    public function addToPersonRelation(PersonRelation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PersonRelation) {
            throw new \InvalidArgumentException(sprintf('The PersonRelation property can only contain items of PersonRelation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PersonRelation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return PersonRelation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return PersonRelation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return PersonRelation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return PersonRelation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return PersonRelation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonRelation
     */
    public function getAttributeName()
    {
        return 'PersonRelation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfPersonRelation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
