<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobRequiredSkill ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobRequiredSkill extends AbstractStructArrayBase
{
    /**
     * The JobRequiredSkill
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var JobRequiredSkill[]
     */
    public $JobRequiredSkill;
    /**
     * Constructor method for ArrayOfJobRequiredSkill
     * @uses ArrayOfJobRequiredSkill::setJobRequiredSkill()
     * @param JobRequiredSkill[] $jobRequiredSkill
     */
    public function __construct(array $jobRequiredSkill = array())
    {
        $this
            ->setJobRequiredSkill($jobRequiredSkill);
    }
    /**
     * Get JobRequiredSkill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return JobRequiredSkill[]|null
     */
    public function getJobRequiredSkill()
    {
        return isset($this->JobRequiredSkill) ? $this->JobRequiredSkill : null;
    }
    /**
     * Set JobRequiredSkill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param JobRequiredSkill[] $jobRequiredSkill
     * @return ArrayOfJobRequiredSkill
     */
    public function setJobRequiredSkill(array $jobRequiredSkill = array())
    {
        foreach ($jobRequiredSkill as $arrayOfJobRequiredSkillJobRequiredSkillItem) {
            // validation for constraint: itemType
            if (!$arrayOfJobRequiredSkillJobRequiredSkillItem instanceof JobRequiredSkill) {
                throw new \InvalidArgumentException(sprintf('The JobRequiredSkill property can only contain items of JobRequiredSkill, "%s" given', is_object($arrayOfJobRequiredSkillJobRequiredSkillItem) ? get_class($arrayOfJobRequiredSkillJobRequiredSkillItem) : gettype($arrayOfJobRequiredSkillJobRequiredSkillItem)), __LINE__);
            }
        }
        if (is_null($jobRequiredSkill) || (is_array($jobRequiredSkill) && empty($jobRequiredSkill))) {
            unset($this->JobRequiredSkill);
        } else {
            $this->JobRequiredSkill = $jobRequiredSkill;
        }
        return $this;
    }
    /**
     * Add item to JobRequiredSkill value
     * @throws \InvalidArgumentException
     * @param JobRequiredSkill $item
     * @return ArrayOfJobRequiredSkill
     */
    public function addToJobRequiredSkill(JobRequiredSkill $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof JobRequiredSkill) {
            throw new \InvalidArgumentException(sprintf('The JobRequiredSkill property can only contain items of JobRequiredSkill, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JobRequiredSkill[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return JobRequiredSkill|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return JobRequiredSkill|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return JobRequiredSkill|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return JobRequiredSkill|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return JobRequiredSkill|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobRequiredSkill
     */
    public function getAttributeName()
    {
        return 'JobRequiredSkill';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfJobRequiredSkill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
