<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobRequiredActivity ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobRequiredActivity extends AbstractStructArrayBase
{
    /**
     * The JobRequiredActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var JobRequiredActivity[]
     */
    public $JobRequiredActivity;
    /**
     * Constructor method for ArrayOfJobRequiredActivity
     * @uses ArrayOfJobRequiredActivity::setJobRequiredActivity()
     * @param JobRequiredActivity[] $jobRequiredActivity
     */
    public function __construct(array $jobRequiredActivity = array())
    {
        $this
            ->setJobRequiredActivity($jobRequiredActivity);
    }
    /**
     * Get JobRequiredActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return JobRequiredActivity[]|null
     */
    public function getJobRequiredActivity()
    {
        return isset($this->JobRequiredActivity) ? $this->JobRequiredActivity : null;
    }
    /**
     * Set JobRequiredActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param JobRequiredActivity[] $jobRequiredActivity
     * @return ArrayOfJobRequiredActivity
     */
    public function setJobRequiredActivity(array $jobRequiredActivity = array())
    {
        foreach ($jobRequiredActivity as $arrayOfJobRequiredActivityJobRequiredActivityItem) {
            // validation for constraint: itemType
            if (!$arrayOfJobRequiredActivityJobRequiredActivityItem instanceof JobRequiredActivity) {
                throw new \InvalidArgumentException(sprintf('The JobRequiredActivity property can only contain items of JobRequiredActivity, "%s" given', is_object($arrayOfJobRequiredActivityJobRequiredActivityItem) ? get_class($arrayOfJobRequiredActivityJobRequiredActivityItem) : gettype($arrayOfJobRequiredActivityJobRequiredActivityItem)), __LINE__);
            }
        }
        if (is_null($jobRequiredActivity) || (is_array($jobRequiredActivity) && empty($jobRequiredActivity))) {
            unset($this->JobRequiredActivity);
        } else {
            $this->JobRequiredActivity = $jobRequiredActivity;
        }
        return $this;
    }
    /**
     * Add item to JobRequiredActivity value
     * @throws \InvalidArgumentException
     * @param JobRequiredActivity $item
     * @return ArrayOfJobRequiredActivity
     */
    public function addToJobRequiredActivity(JobRequiredActivity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof JobRequiredActivity) {
            throw new \InvalidArgumentException(sprintf('The JobRequiredActivity property can only contain items of JobRequiredActivity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JobRequiredActivity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return JobRequiredActivity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return JobRequiredActivity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return JobRequiredActivity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return JobRequiredActivity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return JobRequiredActivity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobRequiredActivity
     */
    public function getAttributeName()
    {
        return 'JobRequiredActivity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfJobRequiredActivity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
