<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityRegistration ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityRegistration extends AbstractStructArrayBase
{
    /**
     * The ActivityRegistration
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ActivityRegistration[]
     */
    public $ActivityRegistration;
    /**
     * Constructor method for ArrayOfActivityRegistration
     * @uses ArrayOfActivityRegistration::setActivityRegistration()
     * @param ActivityRegistration[] $activityRegistration
     */
    public function __construct(array $activityRegistration = array())
    {
        $this
            ->setActivityRegistration($activityRegistration);
    }
    /**
     * Get ActivityRegistration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ActivityRegistration[]|null
     */
    public function getActivityRegistration()
    {
        return isset($this->ActivityRegistration) ? $this->ActivityRegistration : null;
    }
    /**
     * Set ActivityRegistration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param ActivityRegistration[] $activityRegistration
     * @return ArrayOfActivityRegistration
     */
    public function setActivityRegistration(array $activityRegistration = array())
    {
        foreach ($activityRegistration as $arrayOfActivityRegistrationActivityRegistrationItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityRegistrationActivityRegistrationItem instanceof ActivityRegistration) {
                throw new \InvalidArgumentException(sprintf('The ActivityRegistration property can only contain items of ActivityRegistration, "%s" given', is_object($arrayOfActivityRegistrationActivityRegistrationItem) ? get_class($arrayOfActivityRegistrationActivityRegistrationItem) : gettype($arrayOfActivityRegistrationActivityRegistrationItem)), __LINE__);
            }
        }
        if (is_null($activityRegistration) || (is_array($activityRegistration) && empty($activityRegistration))) {
            unset($this->ActivityRegistration);
        } else {
            $this->ActivityRegistration = $activityRegistration;
        }
        return $this;
    }
    /**
     * Add item to ActivityRegistration value
     * @throws \InvalidArgumentException
     * @param ActivityRegistration $item
     * @return ArrayOfActivityRegistration
     */
    public function addToActivityRegistration(ActivityRegistration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ActivityRegistration) {
            throw new \InvalidArgumentException(sprintf('The ActivityRegistration property can only contain items of ActivityRegistration, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityRegistration[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return ActivityRegistration|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return ActivityRegistration|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return ActivityRegistration|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return ActivityRegistration|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return ActivityRegistration|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityRegistration
     */
    public function getAttributeName()
    {
        return 'ActivityRegistration';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfActivityRegistration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
