<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://quickenloans.stage.sumtotal.host/LearningAPI/Services/UserManagement.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://quickenloans.stage.sumtotal.host/LearningAPI/Services/UserManagement.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new Get($options);
$get->setSoapHeaderUserSecurityContext(new UserSecurityContext());
/**
 * Sample call for GetUserById operation/method
 */
if ($get->GetUserById(new GetUserById()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUsers operation/method
 */
if ($get->GetUsers(new GetUsers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRequiredSkills operation/method
 */
if ($get->GetRequiredSkills(new GetRequiredSkills()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAcquiredSkills operation/method
 */
if ($get->GetAcquiredSkills(new GetAcquiredSkills()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRequiredCompetencies operation/method
 */
if ($get->GetRequiredCompetencies(new GetRequiredCompetencies()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRequiredActivities operation/method
 */
if ($get->GetRequiredActivities(new GetRequiredActivities()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPendingEvaluations operation/method
 */
if ($get->GetPendingEvaluations(new GetPendingEvaluations()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMemberDomains operation/method
 */
if ($get->GetMemberDomains(new GetMemberDomains()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTRUsers operation/method
 */
if ($get->GetTRUsers(new GetTRUsers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserByUserName operation/method
 */
if ($get->GetUserByUserName(new GetUserByUserName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUsersByUserNumber operation/method
 */
if ($get->GetUsersByUserNumber(new GetUsersByUserNumber()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserAssignmentStatusByJob operation/method
 */
if ($get->GetUserAssignmentStatusByJob(new GetUserAssignmentStatusByJob()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new Create($options);
$create->setSoapHeaderUserSecurityContext(new UserSecurityContext());
/**
 * Sample call for CreateEmptyUser operation/method
 */
if ($create->CreateEmptyUser(new CreateEmptyUser()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateUser operation/method
 */
if ($create->CreateUser(new CreateUser()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateUserAndUpdateJobOrg operation/method
 */
if ($create->CreateUserAndUpdateJobOrg(new CreateUserAndUpdateJobOrg()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new Update($options);
$update->setSoapHeaderUserSecurityContext(new UserSecurityContext());
/**
 * Sample call for UpdateUser operation/method
 */
if ($update->UpdateUser(new UpdateUser()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new Delete($options);
$delete->setSoapHeaderUserSecurityContext(new UserSecurityContext());
/**
 * Sample call for DeleteUser operation/method
 */
if ($delete->DeleteUser(new DeleteUser()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new Add($options);
$add->setSoapHeaderUserSecurityContext(new UserSecurityContext());
/**
 * Sample call for AddUpdateRequiredSkill operation/method
 */
if ($add->AddUpdateRequiredSkill(new AddUpdateRequiredSkill()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUpdateAcquiredSkill operation/method
 */
if ($add->AddUpdateAcquiredSkill(new AddUpdateAcquiredSkill()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUpdateRequiredCompetency operation/method
 */
if ($add->AddUpdateRequiredCompetency(new AddUpdateRequiredCompetency()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUpdateRequiredActivity operation/method
 */
if ($add->AddUpdateRequiredActivity(new AddUpdateRequiredActivity()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUpdateRequiredActivityWithDueDate operation/method
 */
if ($add->AddUpdateRequiredActivityWithDueDate(new AddUpdateRequiredActivityWithDueDate()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUpdateRequiredActivityWithStartDateAndDueDate
 * operation/method
 */
if ($add->AddUpdateRequiredActivityWithStartDateAndDueDate(new AddUpdateRequiredActivityWithStartDateAndDueDate()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new Remove($options);
$remove->setSoapHeaderUserSecurityContext(new UserSecurityContext());
/**
 * Sample call for RemoveRequiredSkill operation/method
 */
if ($remove->RemoveRequiredSkill(new RemoveRequiredSkill()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveAcquiredSkill operation/method
 */
if ($remove->RemoveAcquiredSkill(new RemoveAcquiredSkill()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveRequiredCompetency operation/method
 */
if ($remove->RemoveRequiredCompetency(new RemoveRequiredCompetency()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveRequiredActivity operation/method
 */
if ($remove->RemoveRequiredActivity(new RemoveRequiredActivity()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new Search($options);
$search->setSoapHeaderUserSecurityContext(new UserSecurityContext());
/**
 * Sample call for SearchUsersByPath operation/method
 */
if ($search->SearchUsersByPath(new SearchUsersByPath()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Refresh ServiceType
 */
$refresh = new Refresh($options);
$refresh->setSoapHeaderUserSecurityContext(new UserSecurityContext());
/**
 * Sample call for RefreshAudience operation/method
 */
if ($refresh->RefreshAudience(new RefreshAudience()) !== false) {
    print_r($refresh->getResult());
} else {
    print_r($refresh->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new Is($options);
$is->setSoapHeaderUserSecurityContext(new UserSecurityContext());
/**
 * Sample call for IsCertification operation/method
 */
if ($is->IsCertification(new IsCertification()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for User ServiceType
 */
$user = new User($options);
$user->setSoapHeaderUserSecurityContext(new UserSecurityContext());
/**
 * Sample call for UserAudienceRefresh operation/method
 */
if ($user->UserAudienceRefresh(new UserAudienceRefresh()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
