<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserAcquiredSkillPropertyBase StructType
 * @subpackage Structs
 */
abstract class UserAcquiredSkillPropertyBase extends Entity
{
    /**
     * The FirstAcquisitionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FirstAcquisitionDate;
    /**
     * The MostRecentAcquisitionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MostRecentAcquisitionDate;
    /**
     * The CertificationNoteDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $CertificationNoteDate;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserId;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $User;
    /**
     * The SkillId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SkillId;
    /**
     * The Skill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Skill
     */
    public $Skill;
    /**
     * The ProficiencyScaleId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProficiencyScaleId;
    /**
     * The ProficiencyScale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ProficiencyScale
     */
    public $ProficiencyScale;
    /**
     * The ProficiencyValueId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProficiencyValueId;
    /**
     * The ProficiencyValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ProficiencyValue
     */
    public $ProficiencyValue;
    /**
     * The CertificationNote
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CertificationNote;
    /**
     * Constructor method for UserAcquiredSkillPropertyBase
     * @uses UserAcquiredSkillPropertyBase::setFirstAcquisitionDate()
     * @uses UserAcquiredSkillPropertyBase::setMostRecentAcquisitionDate()
     * @uses UserAcquiredSkillPropertyBase::setCertificationNoteDate()
     * @uses UserAcquiredSkillPropertyBase::setId()
     * @uses UserAcquiredSkillPropertyBase::setUserId()
     * @uses UserAcquiredSkillPropertyBase::setUser()
     * @uses UserAcquiredSkillPropertyBase::setSkillId()
     * @uses UserAcquiredSkillPropertyBase::setSkill()
     * @uses UserAcquiredSkillPropertyBase::setProficiencyScaleId()
     * @uses UserAcquiredSkillPropertyBase::setProficiencyScale()
     * @uses UserAcquiredSkillPropertyBase::setProficiencyValueId()
     * @uses UserAcquiredSkillPropertyBase::setProficiencyValue()
     * @uses UserAcquiredSkillPropertyBase::setCertificationNote()
     * @param string $firstAcquisitionDate
     * @param string $mostRecentAcquisitionDate
     * @param NullableDateTime $certificationNoteDate
     * @param string $id
     * @param string $userId
     * @param User $user
     * @param string $skillId
     * @param Skill $skill
     * @param string $proficiencyScaleId
     * @param ProficiencyScale $proficiencyScale
     * @param string $proficiencyValueId
     * @param ProficiencyValue $proficiencyValue
     * @param string $certificationNote
     */
    public function __construct($firstAcquisitionDate = null, $mostRecentAcquisitionDate = null, NullableDateTime $certificationNoteDate = null, $id = null, $userId = null, User $user = null, $skillId = null, Skill $skill = null, $proficiencyScaleId = null, ProficiencyScale $proficiencyScale = null, $proficiencyValueId = null, ProficiencyValue $proficiencyValue = null, $certificationNote = null)
    {
        $this
            ->setFirstAcquisitionDate($firstAcquisitionDate)
            ->setMostRecentAcquisitionDate($mostRecentAcquisitionDate)
            ->setCertificationNoteDate($certificationNoteDate)
            ->setId($id)
            ->setUserId($userId)
            ->setUser($user)
            ->setSkillId($skillId)
            ->setSkill($skill)
            ->setProficiencyScaleId($proficiencyScaleId)
            ->setProficiencyScale($proficiencyScale)
            ->setProficiencyValueId($proficiencyValueId)
            ->setProficiencyValue($proficiencyValue)
            ->setCertificationNote($certificationNote);
    }
    /**
     * Get FirstAcquisitionDate value
     * @return string
     */
    public function getFirstAcquisitionDate()
    {
        return $this->FirstAcquisitionDate;
    }
    /**
     * Set FirstAcquisitionDate value
     * @param string $firstAcquisitionDate
     * @return UserAcquiredSkillPropertyBase
     */
    public function setFirstAcquisitionDate($firstAcquisitionDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstAcquisitionDate) && !is_string($firstAcquisitionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstAcquisitionDate)), __LINE__);
        }
        $this->FirstAcquisitionDate = $firstAcquisitionDate;
        return $this;
    }
    /**
     * Get MostRecentAcquisitionDate value
     * @return string
     */
    public function getMostRecentAcquisitionDate()
    {
        return $this->MostRecentAcquisitionDate;
    }
    /**
     * Set MostRecentAcquisitionDate value
     * @param string $mostRecentAcquisitionDate
     * @return UserAcquiredSkillPropertyBase
     */
    public function setMostRecentAcquisitionDate($mostRecentAcquisitionDate = null)
    {
        // validation for constraint: string
        if (!is_null($mostRecentAcquisitionDate) && !is_string($mostRecentAcquisitionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mostRecentAcquisitionDate)), __LINE__);
        }
        $this->MostRecentAcquisitionDate = $mostRecentAcquisitionDate;
        return $this;
    }
    /**
     * Get CertificationNoteDate value
     * @return NullableDateTime
     */
    public function getCertificationNoteDate()
    {
        return $this->CertificationNoteDate;
    }
    /**
     * Set CertificationNoteDate value
     * @param NullableDateTime $certificationNoteDate
     * @return UserAcquiredSkillPropertyBase
     */
    public function setCertificationNoteDate(NullableDateTime $certificationNoteDate = null)
    {
        $this->CertificationNoteDate = $certificationNoteDate;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return UserAcquiredSkillPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return UserAcquiredSkillPropertyBase
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get User value
     * @return User|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param User $user
     * @return UserAcquiredSkillPropertyBase
     */
    public function setUser(User $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get SkillId value
     * @return string|null
     */
    public function getSkillId()
    {
        return $this->SkillId;
    }
    /**
     * Set SkillId value
     * @param string $skillId
     * @return UserAcquiredSkillPropertyBase
     */
    public function setSkillId($skillId = null)
    {
        // validation for constraint: string
        if (!is_null($skillId) && !is_string($skillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($skillId)), __LINE__);
        }
        $this->SkillId = $skillId;
        return $this;
    }
    /**
     * Get Skill value
     * @return Skill|null
     */
    public function getSkill()
    {
        return $this->Skill;
    }
    /**
     * Set Skill value
     * @param Skill $skill
     * @return UserAcquiredSkillPropertyBase
     */
    public function setSkill(Skill $skill = null)
    {
        $this->Skill = $skill;
        return $this;
    }
    /**
     * Get ProficiencyScaleId value
     * @return string|null
     */
    public function getProficiencyScaleId()
    {
        return $this->ProficiencyScaleId;
    }
    /**
     * Set ProficiencyScaleId value
     * @param string $proficiencyScaleId
     * @return UserAcquiredSkillPropertyBase
     */
    public function setProficiencyScaleId($proficiencyScaleId = null)
    {
        // validation for constraint: string
        if (!is_null($proficiencyScaleId) && !is_string($proficiencyScaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proficiencyScaleId)), __LINE__);
        }
        $this->ProficiencyScaleId = $proficiencyScaleId;
        return $this;
    }
    /**
     * Get ProficiencyScale value
     * @return ProficiencyScale|null
     */
    public function getProficiencyScale()
    {
        return $this->ProficiencyScale;
    }
    /**
     * Set ProficiencyScale value
     * @param ProficiencyScale $proficiencyScale
     * @return UserAcquiredSkillPropertyBase
     */
    public function setProficiencyScale(ProficiencyScale $proficiencyScale = null)
    {
        $this->ProficiencyScale = $proficiencyScale;
        return $this;
    }
    /**
     * Get ProficiencyValueId value
     * @return string|null
     */
    public function getProficiencyValueId()
    {
        return $this->ProficiencyValueId;
    }
    /**
     * Set ProficiencyValueId value
     * @param string $proficiencyValueId
     * @return UserAcquiredSkillPropertyBase
     */
    public function setProficiencyValueId($proficiencyValueId = null)
    {
        // validation for constraint: string
        if (!is_null($proficiencyValueId) && !is_string($proficiencyValueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proficiencyValueId)), __LINE__);
        }
        $this->ProficiencyValueId = $proficiencyValueId;
        return $this;
    }
    /**
     * Get ProficiencyValue value
     * @return ProficiencyValue|null
     */
    public function getProficiencyValue()
    {
        return $this->ProficiencyValue;
    }
    /**
     * Set ProficiencyValue value
     * @param ProficiencyValue $proficiencyValue
     * @return UserAcquiredSkillPropertyBase
     */
    public function setProficiencyValue(ProficiencyValue $proficiencyValue = null)
    {
        $this->ProficiencyValue = $proficiencyValue;
        return $this;
    }
    /**
     * Get CertificationNote value
     * @return string|null
     */
    public function getCertificationNote()
    {
        return $this->CertificationNote;
    }
    /**
     * Set CertificationNote value
     * @param string $certificationNote
     * @return UserAcquiredSkillPropertyBase
     */
    public function setCertificationNote($certificationNote = null)
    {
        // validation for constraint: string
        if (!is_null($certificationNote) && !is_string($certificationNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certificationNote)), __LINE__);
        }
        $this->CertificationNote = $certificationNote;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UserAcquiredSkillPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
