<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUsers StructType
 * @subpackage Structs
 */
class GetUsers extends AbstractStructBase
{
    /**
     * The populationLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $populationLevel;
    /**
     * The inDomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $inDomainId;
    /**
     * The searchFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $searchFilter;
    /**
     * Constructor method for GetUsers
     * @uses GetUsers::setPopulationLevel()
     * @uses GetUsers::setInDomainId()
     * @uses GetUsers::setSearchFilter()
     * @param int $populationLevel
     * @param string $inDomainId
     * @param string $searchFilter
     */
    public function __construct($populationLevel = null, $inDomainId = null, $searchFilter = null)
    {
        $this
            ->setPopulationLevel($populationLevel)
            ->setInDomainId($inDomainId)
            ->setSearchFilter($searchFilter);
    }
    /**
     * Get populationLevel value
     * @return int
     */
    public function getPopulationLevel()
    {
        return $this->populationLevel;
    }
    /**
     * Set populationLevel value
     * @param int $populationLevel
     * @return GetUsers
     */
    public function setPopulationLevel($populationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($populationLevel) && !is_numeric($populationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($populationLevel)), __LINE__);
        }
        $this->populationLevel = $populationLevel;
        return $this;
    }
    /**
     * Get inDomainId value
     * @return string|null
     */
    public function getInDomainId()
    {
        return $this->inDomainId;
    }
    /**
     * Set inDomainId value
     * @param string $inDomainId
     * @return GetUsers
     */
    public function setInDomainId($inDomainId = null)
    {
        // validation for constraint: string
        if (!is_null($inDomainId) && !is_string($inDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inDomainId)), __LINE__);
        }
        $this->inDomainId = $inDomainId;
        return $this;
    }
    /**
     * Get searchFilter value
     * @return string|null
     */
    public function getSearchFilter()
    {
        return $this->searchFilter;
    }
    /**
     * Set searchFilter value
     * @param string $searchFilter
     * @return GetUsers
     */
    public function setSearchFilter($searchFilter = null)
    {
        // validation for constraint: string
        if (!is_null($searchFilter) && !is_string($searchFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchFilter)), __LINE__);
        }
        $this->searchFilter = $searchFilter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetUsers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
