<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTRUsers StructType
 * @subpackage Structs
 */
class GetTRUsers extends AbstractStructBase
{
    /**
     * The populationLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $populationLevel;
    /**
     * Constructor method for GetTRUsers
     * @uses GetTRUsers::setPopulationLevel()
     * @param int $populationLevel
     */
    public function __construct($populationLevel = null)
    {
        $this
            ->setPopulationLevel($populationLevel);
    }
    /**
     * Get populationLevel value
     * @return int
     */
    public function getPopulationLevel()
    {
        return $this->populationLevel;
    }
    /**
     * Set populationLevel value
     * @param int $populationLevel
     * @return GetTRUsers
     */
    public function setPopulationLevel($populationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($populationLevel) && !is_numeric($populationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($populationLevel)), __LINE__);
        }
        $this->populationLevel = $populationLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetTRUsers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
