<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrganizationRequiredCompetency ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrganizationRequiredCompetency extends AbstractStructArrayBase
{
    /**
     * The OrganizationRequiredCompetency
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var OrganizationRequiredCompetency[]
     */
    public $OrganizationRequiredCompetency;
    /**
     * Constructor method for ArrayOfOrganizationRequiredCompetency
     * @uses ArrayOfOrganizationRequiredCompetency::setOrganizationRequiredCompetency()
     * @param OrganizationRequiredCompetency[] $organizationRequiredCompetency
     */
    public function __construct(array $organizationRequiredCompetency = array())
    {
        $this
            ->setOrganizationRequiredCompetency($organizationRequiredCompetency);
    }
    /**
     * Get OrganizationRequiredCompetency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return OrganizationRequiredCompetency[]|null
     */
    public function getOrganizationRequiredCompetency()
    {
        return isset($this->OrganizationRequiredCompetency) ? $this->OrganizationRequiredCompetency : null;
    }
    /**
     * Set OrganizationRequiredCompetency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param OrganizationRequiredCompetency[] $organizationRequiredCompetency
     * @return ArrayOfOrganizationRequiredCompetency
     */
    public function setOrganizationRequiredCompetency(array $organizationRequiredCompetency = array())
    {
        foreach ($organizationRequiredCompetency as $arrayOfOrganizationRequiredCompetencyOrganizationRequiredCompetencyItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrganizationRequiredCompetencyOrganizationRequiredCompetencyItem instanceof OrganizationRequiredCompetency) {
                throw new \InvalidArgumentException(sprintf('The OrganizationRequiredCompetency property can only contain items of OrganizationRequiredCompetency, "%s" given', is_object($arrayOfOrganizationRequiredCompetencyOrganizationRequiredCompetencyItem) ? get_class($arrayOfOrganizationRequiredCompetencyOrganizationRequiredCompetencyItem) : gettype($arrayOfOrganizationRequiredCompetencyOrganizationRequiredCompetencyItem)), __LINE__);
            }
        }
        if (is_null($organizationRequiredCompetency) || (is_array($organizationRequiredCompetency) && empty($organizationRequiredCompetency))) {
            unset($this->OrganizationRequiredCompetency);
        } else {
            $this->OrganizationRequiredCompetency = $organizationRequiredCompetency;
        }
        return $this;
    }
    /**
     * Add item to OrganizationRequiredCompetency value
     * @throws \InvalidArgumentException
     * @param OrganizationRequiredCompetency $item
     * @return ArrayOfOrganizationRequiredCompetency
     */
    public function addToOrganizationRequiredCompetency(OrganizationRequiredCompetency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof OrganizationRequiredCompetency) {
            throw new \InvalidArgumentException(sprintf('The OrganizationRequiredCompetency property can only contain items of OrganizationRequiredCompetency, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrganizationRequiredCompetency[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return OrganizationRequiredCompetency|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return OrganizationRequiredCompetency|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return OrganizationRequiredCompetency|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return OrganizationRequiredCompetency|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return OrganizationRequiredCompetency|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrganizationRequiredCompetency
     */
    public function getAttributeName()
    {
        return 'OrganizationRequiredCompetency';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfOrganizationRequiredCompetency
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
