<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityEquipment ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityEquipment extends AbstractStructArrayBase
{
    /**
     * The ActivityEquipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ActivityEquipment[]
     */
    public $ActivityEquipment;
    /**
     * Constructor method for ArrayOfActivityEquipment
     * @uses ArrayOfActivityEquipment::setActivityEquipment()
     * @param ActivityEquipment[] $activityEquipment
     */
    public function __construct(array $activityEquipment = array())
    {
        $this
            ->setActivityEquipment($activityEquipment);
    }
    /**
     * Get ActivityEquipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ActivityEquipment[]|null
     */
    public function getActivityEquipment()
    {
        return isset($this->ActivityEquipment) ? $this->ActivityEquipment : null;
    }
    /**
     * Set ActivityEquipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param ActivityEquipment[] $activityEquipment
     * @return ArrayOfActivityEquipment
     */
    public function setActivityEquipment(array $activityEquipment = array())
    {
        foreach ($activityEquipment as $arrayOfActivityEquipmentActivityEquipmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityEquipmentActivityEquipmentItem instanceof ActivityEquipment) {
                throw new \InvalidArgumentException(sprintf('The ActivityEquipment property can only contain items of ActivityEquipment, "%s" given', is_object($arrayOfActivityEquipmentActivityEquipmentItem) ? get_class($arrayOfActivityEquipmentActivityEquipmentItem) : gettype($arrayOfActivityEquipmentActivityEquipmentItem)), __LINE__);
            }
        }
        if (is_null($activityEquipment) || (is_array($activityEquipment) && empty($activityEquipment))) {
            unset($this->ActivityEquipment);
        } else {
            $this->ActivityEquipment = $activityEquipment;
        }
        return $this;
    }
    /**
     * Add item to ActivityEquipment value
     * @throws \InvalidArgumentException
     * @param ActivityEquipment $item
     * @return ArrayOfActivityEquipment
     */
    public function addToActivityEquipment(ActivityEquipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ActivityEquipment) {
            throw new \InvalidArgumentException(sprintf('The ActivityEquipment property can only contain items of ActivityEquipment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityEquipment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return ActivityEquipment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return ActivityEquipment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return ActivityEquipment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return ActivityEquipment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return ActivityEquipment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityEquipment
     */
    public function getAttributeName()
    {
        return 'ActivityEquipment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfActivityEquipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
