<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityPropertyBase StructType
 * @subpackage Structs
 */
abstract class ActivityPropertyBase extends Entity
{
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsActive;
    /**
     * The IsOpenForRegistration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsOpenForRegistration;
    /**
     * The NoRegistrationRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $NoRegistrationRequired;
    /**
     * The MaximumNumberOfAttempts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $MaximumNumberOfAttempts;
    /**
     * The IsCancelled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsCancelled;
    /**
     * The IsHidden
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsHidden;
    /**
     * The IsPrivate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsPrivate;
    /**
     * The BaseCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $BaseCost;
    /**
     * The CancellationCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $CancellationCost;
    /**
     * The LateCancellationCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $LateCancellationCost;
    /**
     * The NoShowCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $NoShowCost;
    /**
     * The CostCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $CostCurrency;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $EndDate;
    /**
     * The RegistrationDeadline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $RegistrationDeadline;
    /**
     * The RegCancellationDeadline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $RegCancellationDeadline;
    /**
     * The TimeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $TimeZone;
    /**
     * The RequiresApproval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $RequiresApproval;
    /**
     * The OptDate1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $OptDate1;
    /**
     * The OptDate2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $OptDate2;
    /**
     * The OptYesNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OptYesNo;
    /**
     * The OptMoney
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $OptMoney;
    /**
     * The OptInteger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $OptInteger;
    /**
     * The OptFloat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDouble
     */
    public $OptFloat;
    /**
     * The IsCertification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCertification;
    /**
     * The MinimumCapacity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $MinimumCapacity;
    /**
     * The MaximumCapacity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $MaximumCapacity;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The LaunchMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LaunchMethod;
    /**
     * The SharedDomains
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfActivitySharedDomain
     */
    public $SharedDomains;
    /**
     * The Instructors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfActivityInstructor
     */
    public $Instructors;
    /**
     * The Locations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfActivityLocation
     */
    public $Locations;
    /**
     * The Equipments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfActivityEquipment
     */
    public $Equipments;
    /**
     * The Tracks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfActivityTrack
     */
    public $Tracks;
    /**
     * The Catalogs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfActivityCatalogs
     */
    public $Catalogs;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The LabelId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabelId;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ActivityLabel
     */
    public $Label;
    /**
     * The ParentActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentActivityId;
    /**
     * The ParentActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $ParentActivity;
    /**
     * The RootActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RootActivityId;
    /**
     * The RootActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $RootActivity;
    /**
     * The DomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainId;
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Domain
     */
    public $Domain;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DescriptionHTML
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescriptionHTML;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The EmployeeNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmployeeNotes;
    /**
     * The InstructorNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstructorNotes;
    /**
     * The DefaultApproverId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DefaultApproverId;
    /**
     * The DefaultApprover
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $DefaultApprover;
    /**
     * The ContactEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactEmail;
    /**
     * The NotificationEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotificationEmail;
    /**
     * The MetadataId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MetadataId;
    /**
     * The Metadata
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ActivityMetadata
     */
    public $Metadata;
    /**
     * The SystemMetadataId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemMetadataId;
    /**
     * The SystemMetadata
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ActivitySystemMetadata
     */
    public $SystemMetadata;
    /**
     * The OptText1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText1;
    /**
     * The OptText2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText2;
    /**
     * The OptText3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText3;
    /**
     * The OptText4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText4;
    /**
     * The OptMemo1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptMemo1;
    /**
     * The OptCurrencyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptCurrencyId;
    /**
     * The OptCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Currency
     */
    public $OptCurrency;
    /**
     * The LEMtdId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LEMtdId;
    /**
     * The LEMtd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LEMtd
     */
    public $LEMtd;
    /**
     * The OfferingStatusId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfferingStatusId;
    /**
     * The OfferingStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ActivityOffering
     */
    public $OfferingStatus;
    /**
     * The DIFSettingsId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DIFSettingsId;
    /**
     * The DIFSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TRDIFSettings
     */
    public $DIFSettings;
    /**
     * The DurationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DurationId;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ActivityDuration
     */
    public $Duration;
    /**
     * The CBTPath
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CBTPath;
    /**
     * The ImageUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageUrl;
    /**
     * The LEMtd_IconName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LEMtd_IconName;
    /**
     * Constructor method for ActivityPropertyBase
     * @uses ActivityPropertyBase::setIsActive()
     * @uses ActivityPropertyBase::setIsOpenForRegistration()
     * @uses ActivityPropertyBase::setNoRegistrationRequired()
     * @uses ActivityPropertyBase::setMaximumNumberOfAttempts()
     * @uses ActivityPropertyBase::setIsCancelled()
     * @uses ActivityPropertyBase::setIsHidden()
     * @uses ActivityPropertyBase::setIsPrivate()
     * @uses ActivityPropertyBase::setBaseCost()
     * @uses ActivityPropertyBase::setCancellationCost()
     * @uses ActivityPropertyBase::setLateCancellationCost()
     * @uses ActivityPropertyBase::setNoShowCost()
     * @uses ActivityPropertyBase::setCostCurrency()
     * @uses ActivityPropertyBase::setStartDate()
     * @uses ActivityPropertyBase::setEndDate()
     * @uses ActivityPropertyBase::setRegistrationDeadline()
     * @uses ActivityPropertyBase::setRegCancellationDeadline()
     * @uses ActivityPropertyBase::setTimeZone()
     * @uses ActivityPropertyBase::setRequiresApproval()
     * @uses ActivityPropertyBase::setOptDate1()
     * @uses ActivityPropertyBase::setOptDate2()
     * @uses ActivityPropertyBase::setOptYesNo()
     * @uses ActivityPropertyBase::setOptMoney()
     * @uses ActivityPropertyBase::setOptInteger()
     * @uses ActivityPropertyBase::setOptFloat()
     * @uses ActivityPropertyBase::setIsCertification()
     * @uses ActivityPropertyBase::setMinimumCapacity()
     * @uses ActivityPropertyBase::setMaximumCapacity()
     * @uses ActivityPropertyBase::setLastUpdateDate()
     * @uses ActivityPropertyBase::setLaunchMethod()
     * @uses ActivityPropertyBase::setSharedDomains()
     * @uses ActivityPropertyBase::setInstructors()
     * @uses ActivityPropertyBase::setLocations()
     * @uses ActivityPropertyBase::setEquipments()
     * @uses ActivityPropertyBase::setTracks()
     * @uses ActivityPropertyBase::setCatalogs()
     * @uses ActivityPropertyBase::setId()
     * @uses ActivityPropertyBase::setName()
     * @uses ActivityPropertyBase::setLabelId()
     * @uses ActivityPropertyBase::setLabel()
     * @uses ActivityPropertyBase::setParentActivityId()
     * @uses ActivityPropertyBase::setParentActivity()
     * @uses ActivityPropertyBase::setRootActivityId()
     * @uses ActivityPropertyBase::setRootActivity()
     * @uses ActivityPropertyBase::setDomainId()
     * @uses ActivityPropertyBase::setDomain()
     * @uses ActivityPropertyBase::setCode()
     * @uses ActivityPropertyBase::setDescription()
     * @uses ActivityPropertyBase::setDescriptionHTML()
     * @uses ActivityPropertyBase::setUrl()
     * @uses ActivityPropertyBase::setEmployeeNotes()
     * @uses ActivityPropertyBase::setInstructorNotes()
     * @uses ActivityPropertyBase::setDefaultApproverId()
     * @uses ActivityPropertyBase::setDefaultApprover()
     * @uses ActivityPropertyBase::setContactEmail()
     * @uses ActivityPropertyBase::setNotificationEmail()
     * @uses ActivityPropertyBase::setMetadataId()
     * @uses ActivityPropertyBase::setMetadata()
     * @uses ActivityPropertyBase::setSystemMetadataId()
     * @uses ActivityPropertyBase::setSystemMetadata()
     * @uses ActivityPropertyBase::setOptText1()
     * @uses ActivityPropertyBase::setOptText2()
     * @uses ActivityPropertyBase::setOptText3()
     * @uses ActivityPropertyBase::setOptText4()
     * @uses ActivityPropertyBase::setOptMemo1()
     * @uses ActivityPropertyBase::setOptCurrencyId()
     * @uses ActivityPropertyBase::setOptCurrency()
     * @uses ActivityPropertyBase::setLEMtdId()
     * @uses ActivityPropertyBase::setLEMtd()
     * @uses ActivityPropertyBase::setOfferingStatusId()
     * @uses ActivityPropertyBase::setOfferingStatus()
     * @uses ActivityPropertyBase::setDIFSettingsId()
     * @uses ActivityPropertyBase::setDIFSettings()
     * @uses ActivityPropertyBase::setDurationId()
     * @uses ActivityPropertyBase::setDuration()
     * @uses ActivityPropertyBase::setCBTPath()
     * @uses ActivityPropertyBase::setImageUrl()
     * @uses ActivityPropertyBase::setLEMtd_IconName()
     * @param int $isActive
     * @param int $isOpenForRegistration
     * @param NullableInt32 $noRegistrationRequired
     * @param NullableInt32 $maximumNumberOfAttempts
     * @param int $isCancelled
     * @param int $isHidden
     * @param int $isPrivate
     * @param NullableDecimal $baseCost
     * @param NullableDecimal $cancellationCost
     * @param NullableDecimal $lateCancellationCost
     * @param NullableDecimal $noShowCost
     * @param NullableInt32 $costCurrency
     * @param NullableDateTime $startDate
     * @param NullableDateTime $endDate
     * @param NullableDateTime $registrationDeadline
     * @param NullableDateTime $regCancellationDeadline
     * @param NullableInt32 $timeZone
     * @param NullableInt32 $requiresApproval
     * @param NullableDateTime $optDate1
     * @param NullableDateTime $optDate2
     * @param int $optYesNo
     * @param NullableDecimal $optMoney
     * @param NullableInt32 $optInteger
     * @param NullableDouble $optFloat
     * @param bool $isCertification
     * @param NullableInt32 $minimumCapacity
     * @param NullableInt32 $maximumCapacity
     * @param string $lastUpdateDate
     * @param string $launchMethod
     * @param ArrayOfActivitySharedDomain $sharedDomains
     * @param ArrayOfActivityInstructor $instructors
     * @param ArrayOfActivityLocation $locations
     * @param ArrayOfActivityEquipment $equipments
     * @param ArrayOfActivityTrack $tracks
     * @param ArrayOfActivityCatalogs $catalogs
     * @param string $id
     * @param string $name
     * @param string $labelId
     * @param ActivityLabel $label
     * @param string $parentActivityId
     * @param Activity $parentActivity
     * @param string $rootActivityId
     * @param Activity $rootActivity
     * @param string $domainId
     * @param Domain $domain
     * @param string $code
     * @param string $description
     * @param string $descriptionHTML
     * @param string $url
     * @param string $employeeNotes
     * @param string $instructorNotes
     * @param string $defaultApproverId
     * @param User $defaultApprover
     * @param string $contactEmail
     * @param string $notificationEmail
     * @param string $metadataId
     * @param ActivityMetadata $metadata
     * @param string $systemMetadataId
     * @param ActivitySystemMetadata $systemMetadata
     * @param string $optText1
     * @param string $optText2
     * @param string $optText3
     * @param string $optText4
     * @param string $optMemo1
     * @param string $optCurrencyId
     * @param Currency $optCurrency
     * @param string $lEMtdId
     * @param LEMtd $lEMtd
     * @param string $offeringStatusId
     * @param ActivityOffering $offeringStatus
     * @param string $dIFSettingsId
     * @param TRDIFSettings $dIFSettings
     * @param string $durationId
     * @param ActivityDuration $duration
     * @param string $cBTPath
     * @param string $imageUrl
     * @param string $lEMtd_IconName
     */
    public function __construct($isActive = null, $isOpenForRegistration = null, NullableInt32 $noRegistrationRequired = null, NullableInt32 $maximumNumberOfAttempts = null, $isCancelled = null, $isHidden = null, $isPrivate = null, NullableDecimal $baseCost = null, NullableDecimal $cancellationCost = null, NullableDecimal $lateCancellationCost = null, NullableDecimal $noShowCost = null, NullableInt32 $costCurrency = null, NullableDateTime $startDate = null, NullableDateTime $endDate = null, NullableDateTime $registrationDeadline = null, NullableDateTime $regCancellationDeadline = null, NullableInt32 $timeZone = null, NullableInt32 $requiresApproval = null, NullableDateTime $optDate1 = null, NullableDateTime $optDate2 = null, $optYesNo = null, NullableDecimal $optMoney = null, NullableInt32 $optInteger = null, NullableDouble $optFloat = null, $isCertification = null, NullableInt32 $minimumCapacity = null, NullableInt32 $maximumCapacity = null, $lastUpdateDate = null, $launchMethod = null, ArrayOfActivitySharedDomain $sharedDomains = null, ArrayOfActivityInstructor $instructors = null, ArrayOfActivityLocation $locations = null, ArrayOfActivityEquipment $equipments = null, ArrayOfActivityTrack $tracks = null, ArrayOfActivityCatalogs $catalogs = null, $id = null, $name = null, $labelId = null, ActivityLabel $label = null, $parentActivityId = null, Activity $parentActivity = null, $rootActivityId = null, Activity $rootActivity = null, $domainId = null, Domain $domain = null, $code = null, $description = null, $descriptionHTML = null, $url = null, $employeeNotes = null, $instructorNotes = null, $defaultApproverId = null, User $defaultApprover = null, $contactEmail = null, $notificationEmail = null, $metadataId = null, ActivityMetadata $metadata = null, $systemMetadataId = null, ActivitySystemMetadata $systemMetadata = null, $optText1 = null, $optText2 = null, $optText3 = null, $optText4 = null, $optMemo1 = null, $optCurrencyId = null, Currency $optCurrency = null, $lEMtdId = null, LEMtd $lEMtd = null, $offeringStatusId = null, ActivityOffering $offeringStatus = null, $dIFSettingsId = null, TRDIFSettings $dIFSettings = null, $durationId = null, ActivityDuration $duration = null, $cBTPath = null, $imageUrl = null, $lEMtd_IconName = null)
    {
        $this
            ->setIsActive($isActive)
            ->setIsOpenForRegistration($isOpenForRegistration)
            ->setNoRegistrationRequired($noRegistrationRequired)
            ->setMaximumNumberOfAttempts($maximumNumberOfAttempts)
            ->setIsCancelled($isCancelled)
            ->setIsHidden($isHidden)
            ->setIsPrivate($isPrivate)
            ->setBaseCost($baseCost)
            ->setCancellationCost($cancellationCost)
            ->setLateCancellationCost($lateCancellationCost)
            ->setNoShowCost($noShowCost)
            ->setCostCurrency($costCurrency)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setRegistrationDeadline($registrationDeadline)
            ->setRegCancellationDeadline($regCancellationDeadline)
            ->setTimeZone($timeZone)
            ->setRequiresApproval($requiresApproval)
            ->setOptDate1($optDate1)
            ->setOptDate2($optDate2)
            ->setOptYesNo($optYesNo)
            ->setOptMoney($optMoney)
            ->setOptInteger($optInteger)
            ->setOptFloat($optFloat)
            ->setIsCertification($isCertification)
            ->setMinimumCapacity($minimumCapacity)
            ->setMaximumCapacity($maximumCapacity)
            ->setLastUpdateDate($lastUpdateDate)
            ->setLaunchMethod($launchMethod)
            ->setSharedDomains($sharedDomains)
            ->setInstructors($instructors)
            ->setLocations($locations)
            ->setEquipments($equipments)
            ->setTracks($tracks)
            ->setCatalogs($catalogs)
            ->setId($id)
            ->setName($name)
            ->setLabelId($labelId)
            ->setLabel($label)
            ->setParentActivityId($parentActivityId)
            ->setParentActivity($parentActivity)
            ->setRootActivityId($rootActivityId)
            ->setRootActivity($rootActivity)
            ->setDomainId($domainId)
            ->setDomain($domain)
            ->setCode($code)
            ->setDescription($description)
            ->setDescriptionHTML($descriptionHTML)
            ->setUrl($url)
            ->setEmployeeNotes($employeeNotes)
            ->setInstructorNotes($instructorNotes)
            ->setDefaultApproverId($defaultApproverId)
            ->setDefaultApprover($defaultApprover)
            ->setContactEmail($contactEmail)
            ->setNotificationEmail($notificationEmail)
            ->setMetadataId($metadataId)
            ->setMetadata($metadata)
            ->setSystemMetadataId($systemMetadataId)
            ->setSystemMetadata($systemMetadata)
            ->setOptText1($optText1)
            ->setOptText2($optText2)
            ->setOptText3($optText3)
            ->setOptText4($optText4)
            ->setOptMemo1($optMemo1)
            ->setOptCurrencyId($optCurrencyId)
            ->setOptCurrency($optCurrency)
            ->setLEMtdId($lEMtdId)
            ->setLEMtd($lEMtd)
            ->setOfferingStatusId($offeringStatusId)
            ->setOfferingStatus($offeringStatus)
            ->setDIFSettingsId($dIFSettingsId)
            ->setDIFSettings($dIFSettings)
            ->setDurationId($durationId)
            ->setDuration($duration)
            ->setCBTPath($cBTPath)
            ->setImageUrl($imageUrl)
            ->setLEMtd_IconName($lEMtd_IconName);
    }
    /**
     * Get IsActive value
     * @return int
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param int $isActive
     * @return ActivityPropertyBase
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: int
        if (!is_null($isActive) && !is_numeric($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsOpenForRegistration value
     * @return int
     */
    public function getIsOpenForRegistration()
    {
        return $this->IsOpenForRegistration;
    }
    /**
     * Set IsOpenForRegistration value
     * @param int $isOpenForRegistration
     * @return ActivityPropertyBase
     */
    public function setIsOpenForRegistration($isOpenForRegistration = null)
    {
        // validation for constraint: int
        if (!is_null($isOpenForRegistration) && !is_numeric($isOpenForRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isOpenForRegistration)), __LINE__);
        }
        $this->IsOpenForRegistration = $isOpenForRegistration;
        return $this;
    }
    /**
     * Get NoRegistrationRequired value
     * @return NullableInt32
     */
    public function getNoRegistrationRequired()
    {
        return $this->NoRegistrationRequired;
    }
    /**
     * Set NoRegistrationRequired value
     * @param NullableInt32 $noRegistrationRequired
     * @return ActivityPropertyBase
     */
    public function setNoRegistrationRequired(NullableInt32 $noRegistrationRequired = null)
    {
        $this->NoRegistrationRequired = $noRegistrationRequired;
        return $this;
    }
    /**
     * Get MaximumNumberOfAttempts value
     * @return NullableInt32
     */
    public function getMaximumNumberOfAttempts()
    {
        return $this->MaximumNumberOfAttempts;
    }
    /**
     * Set MaximumNumberOfAttempts value
     * @param NullableInt32 $maximumNumberOfAttempts
     * @return ActivityPropertyBase
     */
    public function setMaximumNumberOfAttempts(NullableInt32 $maximumNumberOfAttempts = null)
    {
        $this->MaximumNumberOfAttempts = $maximumNumberOfAttempts;
        return $this;
    }
    /**
     * Get IsCancelled value
     * @return int
     */
    public function getIsCancelled()
    {
        return $this->IsCancelled;
    }
    /**
     * Set IsCancelled value
     * @param int $isCancelled
     * @return ActivityPropertyBase
     */
    public function setIsCancelled($isCancelled = null)
    {
        // validation for constraint: int
        if (!is_null($isCancelled) && !is_numeric($isCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isCancelled)), __LINE__);
        }
        $this->IsCancelled = $isCancelled;
        return $this;
    }
    /**
     * Get IsHidden value
     * @return int
     */
    public function getIsHidden()
    {
        return $this->IsHidden;
    }
    /**
     * Set IsHidden value
     * @param int $isHidden
     * @return ActivityPropertyBase
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: int
        if (!is_null($isHidden) && !is_numeric($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isHidden)), __LINE__);
        }
        $this->IsHidden = $isHidden;
        return $this;
    }
    /**
     * Get IsPrivate value
     * @return int
     */
    public function getIsPrivate()
    {
        return $this->IsPrivate;
    }
    /**
     * Set IsPrivate value
     * @param int $isPrivate
     * @return ActivityPropertyBase
     */
    public function setIsPrivate($isPrivate = null)
    {
        // validation for constraint: int
        if (!is_null($isPrivate) && !is_numeric($isPrivate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isPrivate)), __LINE__);
        }
        $this->IsPrivate = $isPrivate;
        return $this;
    }
    /**
     * Get BaseCost value
     * @return NullableDecimal
     */
    public function getBaseCost()
    {
        return $this->BaseCost;
    }
    /**
     * Set BaseCost value
     * @param NullableDecimal $baseCost
     * @return ActivityPropertyBase
     */
    public function setBaseCost(NullableDecimal $baseCost = null)
    {
        $this->BaseCost = $baseCost;
        return $this;
    }
    /**
     * Get CancellationCost value
     * @return NullableDecimal
     */
    public function getCancellationCost()
    {
        return $this->CancellationCost;
    }
    /**
     * Set CancellationCost value
     * @param NullableDecimal $cancellationCost
     * @return ActivityPropertyBase
     */
    public function setCancellationCost(NullableDecimal $cancellationCost = null)
    {
        $this->CancellationCost = $cancellationCost;
        return $this;
    }
    /**
     * Get LateCancellationCost value
     * @return NullableDecimal
     */
    public function getLateCancellationCost()
    {
        return $this->LateCancellationCost;
    }
    /**
     * Set LateCancellationCost value
     * @param NullableDecimal $lateCancellationCost
     * @return ActivityPropertyBase
     */
    public function setLateCancellationCost(NullableDecimal $lateCancellationCost = null)
    {
        $this->LateCancellationCost = $lateCancellationCost;
        return $this;
    }
    /**
     * Get NoShowCost value
     * @return NullableDecimal
     */
    public function getNoShowCost()
    {
        return $this->NoShowCost;
    }
    /**
     * Set NoShowCost value
     * @param NullableDecimal $noShowCost
     * @return ActivityPropertyBase
     */
    public function setNoShowCost(NullableDecimal $noShowCost = null)
    {
        $this->NoShowCost = $noShowCost;
        return $this;
    }
    /**
     * Get CostCurrency value
     * @return NullableInt32
     */
    public function getCostCurrency()
    {
        return $this->CostCurrency;
    }
    /**
     * Set CostCurrency value
     * @param NullableInt32 $costCurrency
     * @return ActivityPropertyBase
     */
    public function setCostCurrency(NullableInt32 $costCurrency = null)
    {
        $this->CostCurrency = $costCurrency;
        return $this;
    }
    /**
     * Get StartDate value
     * @return NullableDateTime
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param NullableDateTime $startDate
     * @return ActivityPropertyBase
     */
    public function setStartDate(NullableDateTime $startDate = null)
    {
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return NullableDateTime
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param NullableDateTime $endDate
     * @return ActivityPropertyBase
     */
    public function setEndDate(NullableDateTime $endDate = null)
    {
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get RegistrationDeadline value
     * @return NullableDateTime
     */
    public function getRegistrationDeadline()
    {
        return $this->RegistrationDeadline;
    }
    /**
     * Set RegistrationDeadline value
     * @param NullableDateTime $registrationDeadline
     * @return ActivityPropertyBase
     */
    public function setRegistrationDeadline(NullableDateTime $registrationDeadline = null)
    {
        $this->RegistrationDeadline = $registrationDeadline;
        return $this;
    }
    /**
     * Get RegCancellationDeadline value
     * @return NullableDateTime
     */
    public function getRegCancellationDeadline()
    {
        return $this->RegCancellationDeadline;
    }
    /**
     * Set RegCancellationDeadline value
     * @param NullableDateTime $regCancellationDeadline
     * @return ActivityPropertyBase
     */
    public function setRegCancellationDeadline(NullableDateTime $regCancellationDeadline = null)
    {
        $this->RegCancellationDeadline = $regCancellationDeadline;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return NullableInt32
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param NullableInt32 $timeZone
     * @return ActivityPropertyBase
     */
    public function setTimeZone(NullableInt32 $timeZone = null)
    {
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Get RequiresApproval value
     * @return NullableInt32
     */
    public function getRequiresApproval()
    {
        return $this->RequiresApproval;
    }
    /**
     * Set RequiresApproval value
     * @param NullableInt32 $requiresApproval
     * @return ActivityPropertyBase
     */
    public function setRequiresApproval(NullableInt32 $requiresApproval = null)
    {
        $this->RequiresApproval = $requiresApproval;
        return $this;
    }
    /**
     * Get OptDate1 value
     * @return NullableDateTime
     */
    public function getOptDate1()
    {
        return $this->OptDate1;
    }
    /**
     * Set OptDate1 value
     * @param NullableDateTime $optDate1
     * @return ActivityPropertyBase
     */
    public function setOptDate1(NullableDateTime $optDate1 = null)
    {
        $this->OptDate1 = $optDate1;
        return $this;
    }
    /**
     * Get OptDate2 value
     * @return NullableDateTime
     */
    public function getOptDate2()
    {
        return $this->OptDate2;
    }
    /**
     * Set OptDate2 value
     * @param NullableDateTime $optDate2
     * @return ActivityPropertyBase
     */
    public function setOptDate2(NullableDateTime $optDate2 = null)
    {
        $this->OptDate2 = $optDate2;
        return $this;
    }
    /**
     * Get OptYesNo value
     * @return int
     */
    public function getOptYesNo()
    {
        return $this->OptYesNo;
    }
    /**
     * Set OptYesNo value
     * @param int $optYesNo
     * @return ActivityPropertyBase
     */
    public function setOptYesNo($optYesNo = null)
    {
        // validation for constraint: int
        if (!is_null($optYesNo) && !is_numeric($optYesNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($optYesNo)), __LINE__);
        }
        $this->OptYesNo = $optYesNo;
        return $this;
    }
    /**
     * Get OptMoney value
     * @return NullableDecimal
     */
    public function getOptMoney()
    {
        return $this->OptMoney;
    }
    /**
     * Set OptMoney value
     * @param NullableDecimal $optMoney
     * @return ActivityPropertyBase
     */
    public function setOptMoney(NullableDecimal $optMoney = null)
    {
        $this->OptMoney = $optMoney;
        return $this;
    }
    /**
     * Get OptInteger value
     * @return NullableInt32
     */
    public function getOptInteger()
    {
        return $this->OptInteger;
    }
    /**
     * Set OptInteger value
     * @param NullableInt32 $optInteger
     * @return ActivityPropertyBase
     */
    public function setOptInteger(NullableInt32 $optInteger = null)
    {
        $this->OptInteger = $optInteger;
        return $this;
    }
    /**
     * Get OptFloat value
     * @return NullableDouble
     */
    public function getOptFloat()
    {
        return $this->OptFloat;
    }
    /**
     * Set OptFloat value
     * @param NullableDouble $optFloat
     * @return ActivityPropertyBase
     */
    public function setOptFloat(NullableDouble $optFloat = null)
    {
        $this->OptFloat = $optFloat;
        return $this;
    }
    /**
     * Get IsCertification value
     * @return bool
     */
    public function getIsCertification()
    {
        return $this->IsCertification;
    }
    /**
     * Set IsCertification value
     * @param bool $isCertification
     * @return ActivityPropertyBase
     */
    public function setIsCertification($isCertification = null)
    {
        $this->IsCertification = $isCertification;
        return $this;
    }
    /**
     * Get MinimumCapacity value
     * @return NullableInt32
     */
    public function getMinimumCapacity()
    {
        return $this->MinimumCapacity;
    }
    /**
     * Set MinimumCapacity value
     * @param NullableInt32 $minimumCapacity
     * @return ActivityPropertyBase
     */
    public function setMinimumCapacity(NullableInt32 $minimumCapacity = null)
    {
        $this->MinimumCapacity = $minimumCapacity;
        return $this;
    }
    /**
     * Get MaximumCapacity value
     * @return NullableInt32
     */
    public function getMaximumCapacity()
    {
        return $this->MaximumCapacity;
    }
    /**
     * Set MaximumCapacity value
     * @param NullableInt32 $maximumCapacity
     * @return ActivityPropertyBase
     */
    public function setMaximumCapacity(NullableInt32 $maximumCapacity = null)
    {
        $this->MaximumCapacity = $maximumCapacity;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return ActivityPropertyBase
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get LaunchMethod value
     * @return string
     */
    public function getLaunchMethod()
    {
        return $this->LaunchMethod;
    }
    /**
     * Set LaunchMethod value
     * @uses LaunchMethod::valueIsValid()
     * @uses LaunchMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $launchMethod
     * @return ActivityPropertyBase
     */
    public function setLaunchMethod($launchMethod = null)
    {
        // validation for constraint: enumeration
        if (!LaunchMethod::valueIsValid($launchMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $launchMethod, implode(', ', LaunchMethod::getValidValues())), __LINE__);
        }
        $this->LaunchMethod = $launchMethod;
        return $this;
    }
    /**
     * Get SharedDomains value
     * @return ArrayOfActivitySharedDomain
     */
    public function getSharedDomains()
    {
        return $this->SharedDomains;
    }
    /**
     * Set SharedDomains value
     * @param ArrayOfActivitySharedDomain $sharedDomains
     * @return ActivityPropertyBase
     */
    public function setSharedDomains(ArrayOfActivitySharedDomain $sharedDomains = null)
    {
        $this->SharedDomains = $sharedDomains;
        return $this;
    }
    /**
     * Get Instructors value
     * @return ArrayOfActivityInstructor
     */
    public function getInstructors()
    {
        return $this->Instructors;
    }
    /**
     * Set Instructors value
     * @param ArrayOfActivityInstructor $instructors
     * @return ActivityPropertyBase
     */
    public function setInstructors(ArrayOfActivityInstructor $instructors = null)
    {
        $this->Instructors = $instructors;
        return $this;
    }
    /**
     * Get Locations value
     * @return ArrayOfActivityLocation
     */
    public function getLocations()
    {
        return $this->Locations;
    }
    /**
     * Set Locations value
     * @param ArrayOfActivityLocation $locations
     * @return ActivityPropertyBase
     */
    public function setLocations(ArrayOfActivityLocation $locations = null)
    {
        $this->Locations = $locations;
        return $this;
    }
    /**
     * Get Equipments value
     * @return ArrayOfActivityEquipment
     */
    public function getEquipments()
    {
        return $this->Equipments;
    }
    /**
     * Set Equipments value
     * @param ArrayOfActivityEquipment $equipments
     * @return ActivityPropertyBase
     */
    public function setEquipments(ArrayOfActivityEquipment $equipments = null)
    {
        $this->Equipments = $equipments;
        return $this;
    }
    /**
     * Get Tracks value
     * @return ArrayOfActivityTrack
     */
    public function getTracks()
    {
        return $this->Tracks;
    }
    /**
     * Set Tracks value
     * @param ArrayOfActivityTrack $tracks
     * @return ActivityPropertyBase
     */
    public function setTracks(ArrayOfActivityTrack $tracks = null)
    {
        $this->Tracks = $tracks;
        return $this;
    }
    /**
     * Get Catalogs value
     * @return ArrayOfActivityCatalogs
     */
    public function getCatalogs()
    {
        return $this->Catalogs;
    }
    /**
     * Set Catalogs value
     * @param ArrayOfActivityCatalogs $catalogs
     * @return ActivityPropertyBase
     */
    public function setCatalogs(ArrayOfActivityCatalogs $catalogs = null)
    {
        $this->Catalogs = $catalogs;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return ActivityPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return ActivityPropertyBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get LabelId value
     * @return string|null
     */
    public function getLabelId()
    {
        return $this->LabelId;
    }
    /**
     * Set LabelId value
     * @param string $labelId
     * @return ActivityPropertyBase
     */
    public function setLabelId($labelId = null)
    {
        // validation for constraint: string
        if (!is_null($labelId) && !is_string($labelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelId)), __LINE__);
        }
        $this->LabelId = $labelId;
        return $this;
    }
    /**
     * Get Label value
     * @return ActivityLabel|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param ActivityLabel $label
     * @return ActivityPropertyBase
     */
    public function setLabel(ActivityLabel $label = null)
    {
        $this->Label = $label;
        return $this;
    }
    /**
     * Get ParentActivityId value
     * @return string|null
     */
    public function getParentActivityId()
    {
        return $this->ParentActivityId;
    }
    /**
     * Set ParentActivityId value
     * @param string $parentActivityId
     * @return ActivityPropertyBase
     */
    public function setParentActivityId($parentActivityId = null)
    {
        // validation for constraint: string
        if (!is_null($parentActivityId) && !is_string($parentActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentActivityId)), __LINE__);
        }
        $this->ParentActivityId = $parentActivityId;
        return $this;
    }
    /**
     * Get ParentActivity value
     * @return Activity|null
     */
    public function getParentActivity()
    {
        return $this->ParentActivity;
    }
    /**
     * Set ParentActivity value
     * @param Activity $parentActivity
     * @return ActivityPropertyBase
     */
    public function setParentActivity(Activity $parentActivity = null)
    {
        $this->ParentActivity = $parentActivity;
        return $this;
    }
    /**
     * Get RootActivityId value
     * @return string|null
     */
    public function getRootActivityId()
    {
        return $this->RootActivityId;
    }
    /**
     * Set RootActivityId value
     * @param string $rootActivityId
     * @return ActivityPropertyBase
     */
    public function setRootActivityId($rootActivityId = null)
    {
        // validation for constraint: string
        if (!is_null($rootActivityId) && !is_string($rootActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rootActivityId)), __LINE__);
        }
        $this->RootActivityId = $rootActivityId;
        return $this;
    }
    /**
     * Get RootActivity value
     * @return Activity|null
     */
    public function getRootActivity()
    {
        return $this->RootActivity;
    }
    /**
     * Set RootActivity value
     * @param Activity $rootActivity
     * @return ActivityPropertyBase
     */
    public function setRootActivity(Activity $rootActivity = null)
    {
        $this->RootActivity = $rootActivity;
        return $this;
    }
    /**
     * Get DomainId value
     * @return string|null
     */
    public function getDomainId()
    {
        return $this->DomainId;
    }
    /**
     * Set DomainId value
     * @param string $domainId
     * @return ActivityPropertyBase
     */
    public function setDomainId($domainId = null)
    {
        // validation for constraint: string
        if (!is_null($domainId) && !is_string($domainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainId)), __LINE__);
        }
        $this->DomainId = $domainId;
        return $this;
    }
    /**
     * Get Domain value
     * @return Domain|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param Domain $domain
     * @return ActivityPropertyBase
     */
    public function setDomain(Domain $domain = null)
    {
        $this->Domain = $domain;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return ActivityPropertyBase
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return ActivityPropertyBase
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DescriptionHTML value
     * @return string|null
     */
    public function getDescriptionHTML()
    {
        return $this->DescriptionHTML;
    }
    /**
     * Set DescriptionHTML value
     * @param string $descriptionHTML
     * @return ActivityPropertyBase
     */
    public function setDescriptionHTML($descriptionHTML = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionHTML) && !is_string($descriptionHTML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptionHTML)), __LINE__);
        }
        $this->DescriptionHTML = $descriptionHTML;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return ActivityPropertyBase
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get EmployeeNotes value
     * @return string|null
     */
    public function getEmployeeNotes()
    {
        return $this->EmployeeNotes;
    }
    /**
     * Set EmployeeNotes value
     * @param string $employeeNotes
     * @return ActivityPropertyBase
     */
    public function setEmployeeNotes($employeeNotes = null)
    {
        // validation for constraint: string
        if (!is_null($employeeNotes) && !is_string($employeeNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($employeeNotes)), __LINE__);
        }
        $this->EmployeeNotes = $employeeNotes;
        return $this;
    }
    /**
     * Get InstructorNotes value
     * @return string|null
     */
    public function getInstructorNotes()
    {
        return $this->InstructorNotes;
    }
    /**
     * Set InstructorNotes value
     * @param string $instructorNotes
     * @return ActivityPropertyBase
     */
    public function setInstructorNotes($instructorNotes = null)
    {
        // validation for constraint: string
        if (!is_null($instructorNotes) && !is_string($instructorNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instructorNotes)), __LINE__);
        }
        $this->InstructorNotes = $instructorNotes;
        return $this;
    }
    /**
     * Get DefaultApproverId value
     * @return string|null
     */
    public function getDefaultApproverId()
    {
        return $this->DefaultApproverId;
    }
    /**
     * Set DefaultApproverId value
     * @param string $defaultApproverId
     * @return ActivityPropertyBase
     */
    public function setDefaultApproverId($defaultApproverId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultApproverId) && !is_string($defaultApproverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultApproverId)), __LINE__);
        }
        $this->DefaultApproverId = $defaultApproverId;
        return $this;
    }
    /**
     * Get DefaultApprover value
     * @return User|null
     */
    public function getDefaultApprover()
    {
        return $this->DefaultApprover;
    }
    /**
     * Set DefaultApprover value
     * @param User $defaultApprover
     * @return ActivityPropertyBase
     */
    public function setDefaultApprover(User $defaultApprover = null)
    {
        $this->DefaultApprover = $defaultApprover;
        return $this;
    }
    /**
     * Get ContactEmail value
     * @return string|null
     */
    public function getContactEmail()
    {
        return $this->ContactEmail;
    }
    /**
     * Set ContactEmail value
     * @param string $contactEmail
     * @return ActivityPropertyBase
     */
    public function setContactEmail($contactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmail) && !is_string($contactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactEmail)), __LINE__);
        }
        $this->ContactEmail = $contactEmail;
        return $this;
    }
    /**
     * Get NotificationEmail value
     * @return string|null
     */
    public function getNotificationEmail()
    {
        return $this->NotificationEmail;
    }
    /**
     * Set NotificationEmail value
     * @param string $notificationEmail
     * @return ActivityPropertyBase
     */
    public function setNotificationEmail($notificationEmail = null)
    {
        // validation for constraint: string
        if (!is_null($notificationEmail) && !is_string($notificationEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationEmail)), __LINE__);
        }
        $this->NotificationEmail = $notificationEmail;
        return $this;
    }
    /**
     * Get MetadataId value
     * @return string|null
     */
    public function getMetadataId()
    {
        return $this->MetadataId;
    }
    /**
     * Set MetadataId value
     * @param string $metadataId
     * @return ActivityPropertyBase
     */
    public function setMetadataId($metadataId = null)
    {
        // validation for constraint: string
        if (!is_null($metadataId) && !is_string($metadataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($metadataId)), __LINE__);
        }
        $this->MetadataId = $metadataId;
        return $this;
    }
    /**
     * Get Metadata value
     * @return ActivityMetadata|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param ActivityMetadata $metadata
     * @return ActivityPropertyBase
     */
    public function setMetadata(ActivityMetadata $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get SystemMetadataId value
     * @return string|null
     */
    public function getSystemMetadataId()
    {
        return $this->SystemMetadataId;
    }
    /**
     * Set SystemMetadataId value
     * @param string $systemMetadataId
     * @return ActivityPropertyBase
     */
    public function setSystemMetadataId($systemMetadataId = null)
    {
        // validation for constraint: string
        if (!is_null($systemMetadataId) && !is_string($systemMetadataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemMetadataId)), __LINE__);
        }
        $this->SystemMetadataId = $systemMetadataId;
        return $this;
    }
    /**
     * Get SystemMetadata value
     * @return ActivitySystemMetadata|null
     */
    public function getSystemMetadata()
    {
        return $this->SystemMetadata;
    }
    /**
     * Set SystemMetadata value
     * @param ActivitySystemMetadata $systemMetadata
     * @return ActivityPropertyBase
     */
    public function setSystemMetadata(ActivitySystemMetadata $systemMetadata = null)
    {
        $this->SystemMetadata = $systemMetadata;
        return $this;
    }
    /**
     * Get OptText1 value
     * @return string|null
     */
    public function getOptText1()
    {
        return $this->OptText1;
    }
    /**
     * Set OptText1 value
     * @param string $optText1
     * @return ActivityPropertyBase
     */
    public function setOptText1($optText1 = null)
    {
        // validation for constraint: string
        if (!is_null($optText1) && !is_string($optText1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText1)), __LINE__);
        }
        $this->OptText1 = $optText1;
        return $this;
    }
    /**
     * Get OptText2 value
     * @return string|null
     */
    public function getOptText2()
    {
        return $this->OptText2;
    }
    /**
     * Set OptText2 value
     * @param string $optText2
     * @return ActivityPropertyBase
     */
    public function setOptText2($optText2 = null)
    {
        // validation for constraint: string
        if (!is_null($optText2) && !is_string($optText2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText2)), __LINE__);
        }
        $this->OptText2 = $optText2;
        return $this;
    }
    /**
     * Get OptText3 value
     * @return string|null
     */
    public function getOptText3()
    {
        return $this->OptText3;
    }
    /**
     * Set OptText3 value
     * @param string $optText3
     * @return ActivityPropertyBase
     */
    public function setOptText3($optText3 = null)
    {
        // validation for constraint: string
        if (!is_null($optText3) && !is_string($optText3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText3)), __LINE__);
        }
        $this->OptText3 = $optText3;
        return $this;
    }
    /**
     * Get OptText4 value
     * @return string|null
     */
    public function getOptText4()
    {
        return $this->OptText4;
    }
    /**
     * Set OptText4 value
     * @param string $optText4
     * @return ActivityPropertyBase
     */
    public function setOptText4($optText4 = null)
    {
        // validation for constraint: string
        if (!is_null($optText4) && !is_string($optText4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText4)), __LINE__);
        }
        $this->OptText4 = $optText4;
        return $this;
    }
    /**
     * Get OptMemo1 value
     * @return string|null
     */
    public function getOptMemo1()
    {
        return $this->OptMemo1;
    }
    /**
     * Set OptMemo1 value
     * @param string $optMemo1
     * @return ActivityPropertyBase
     */
    public function setOptMemo1($optMemo1 = null)
    {
        // validation for constraint: string
        if (!is_null($optMemo1) && !is_string($optMemo1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optMemo1)), __LINE__);
        }
        $this->OptMemo1 = $optMemo1;
        return $this;
    }
    /**
     * Get OptCurrencyId value
     * @return string|null
     */
    public function getOptCurrencyId()
    {
        return $this->OptCurrencyId;
    }
    /**
     * Set OptCurrencyId value
     * @param string $optCurrencyId
     * @return ActivityPropertyBase
     */
    public function setOptCurrencyId($optCurrencyId = null)
    {
        // validation for constraint: string
        if (!is_null($optCurrencyId) && !is_string($optCurrencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optCurrencyId)), __LINE__);
        }
        $this->OptCurrencyId = $optCurrencyId;
        return $this;
    }
    /**
     * Get OptCurrency value
     * @return Currency|null
     */
    public function getOptCurrency()
    {
        return $this->OptCurrency;
    }
    /**
     * Set OptCurrency value
     * @param Currency $optCurrency
     * @return ActivityPropertyBase
     */
    public function setOptCurrency(Currency $optCurrency = null)
    {
        $this->OptCurrency = $optCurrency;
        return $this;
    }
    /**
     * Get LEMtdId value
     * @return string|null
     */
    public function getLEMtdId()
    {
        return $this->LEMtdId;
    }
    /**
     * Set LEMtdId value
     * @param string $lEMtdId
     * @return ActivityPropertyBase
     */
    public function setLEMtdId($lEMtdId = null)
    {
        // validation for constraint: string
        if (!is_null($lEMtdId) && !is_string($lEMtdId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lEMtdId)), __LINE__);
        }
        $this->LEMtdId = $lEMtdId;
        return $this;
    }
    /**
     * Get LEMtd value
     * @return LEMtd|null
     */
    public function getLEMtd()
    {
        return $this->LEMtd;
    }
    /**
     * Set LEMtd value
     * @param LEMtd $lEMtd
     * @return ActivityPropertyBase
     */
    public function setLEMtd(LEMtd $lEMtd = null)
    {
        $this->LEMtd = $lEMtd;
        return $this;
    }
    /**
     * Get OfferingStatusId value
     * @return string|null
     */
    public function getOfferingStatusId()
    {
        return $this->OfferingStatusId;
    }
    /**
     * Set OfferingStatusId value
     * @param string $offeringStatusId
     * @return ActivityPropertyBase
     */
    public function setOfferingStatusId($offeringStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($offeringStatusId) && !is_string($offeringStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($offeringStatusId)), __LINE__);
        }
        $this->OfferingStatusId = $offeringStatusId;
        return $this;
    }
    /**
     * Get OfferingStatus value
     * @return ActivityOffering|null
     */
    public function getOfferingStatus()
    {
        return $this->OfferingStatus;
    }
    /**
     * Set OfferingStatus value
     * @param ActivityOffering $offeringStatus
     * @return ActivityPropertyBase
     */
    public function setOfferingStatus(ActivityOffering $offeringStatus = null)
    {
        $this->OfferingStatus = $offeringStatus;
        return $this;
    }
    /**
     * Get DIFSettingsId value
     * @return string|null
     */
    public function getDIFSettingsId()
    {
        return $this->DIFSettingsId;
    }
    /**
     * Set DIFSettingsId value
     * @param string $dIFSettingsId
     * @return ActivityPropertyBase
     */
    public function setDIFSettingsId($dIFSettingsId = null)
    {
        // validation for constraint: string
        if (!is_null($dIFSettingsId) && !is_string($dIFSettingsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dIFSettingsId)), __LINE__);
        }
        $this->DIFSettingsId = $dIFSettingsId;
        return $this;
    }
    /**
     * Get DIFSettings value
     * @return TRDIFSettings|null
     */
    public function getDIFSettings()
    {
        return $this->DIFSettings;
    }
    /**
     * Set DIFSettings value
     * @param TRDIFSettings $dIFSettings
     * @return ActivityPropertyBase
     */
    public function setDIFSettings(TRDIFSettings $dIFSettings = null)
    {
        $this->DIFSettings = $dIFSettings;
        return $this;
    }
    /**
     * Get DurationId value
     * @return string|null
     */
    public function getDurationId()
    {
        return $this->DurationId;
    }
    /**
     * Set DurationId value
     * @param string $durationId
     * @return ActivityPropertyBase
     */
    public function setDurationId($durationId = null)
    {
        // validation for constraint: string
        if (!is_null($durationId) && !is_string($durationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($durationId)), __LINE__);
        }
        $this->DurationId = $durationId;
        return $this;
    }
    /**
     * Get Duration value
     * @return ActivityDuration|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param ActivityDuration $duration
     * @return ActivityPropertyBase
     */
    public function setDuration(ActivityDuration $duration = null)
    {
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get CBTPath value
     * @return string|null
     */
    public function getCBTPath()
    {
        return $this->CBTPath;
    }
    /**
     * Set CBTPath value
     * @param string $cBTPath
     * @return ActivityPropertyBase
     */
    public function setCBTPath($cBTPath = null)
    {
        // validation for constraint: string
        if (!is_null($cBTPath) && !is_string($cBTPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cBTPath)), __LINE__);
        }
        $this->CBTPath = $cBTPath;
        return $this;
    }
    /**
     * Get ImageUrl value
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->ImageUrl;
    }
    /**
     * Set ImageUrl value
     * @param string $imageUrl
     * @return ActivityPropertyBase
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageUrl)), __LINE__);
        }
        $this->ImageUrl = $imageUrl;
        return $this;
    }
    /**
     * Get LEMtd_IconName value
     * @return string|null
     */
    public function getLEMtd_IconName()
    {
        return $this->LEMtd_IconName;
    }
    /**
     * Set LEMtd_IconName value
     * @param string $lEMtd_IconName
     * @return ActivityPropertyBase
     */
    public function setLEMtd_IconName($lEMtd_IconName = null)
    {
        // validation for constraint: string
        if (!is_null($lEMtd_IconName) && !is_string($lEMtd_IconName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lEMtd_IconName)), __LINE__);
        }
        $this->LEMtd_IconName = $lEMtd_IconName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ActivityPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
