<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityLocationPropertyBase StructType
 * @subpackage Structs
 */
abstract class ActivityLocationPropertyBase extends Entity
{
    /**
     * The ApprovalStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ApprovalStatus;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityId;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $Activity;
    /**
     * The LocationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationId;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Location
     */
    public $Location;
    /**
     * The ApproverId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApproverId;
    /**
     * The Approver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $Approver;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * Constructor method for ActivityLocationPropertyBase
     * @uses ActivityLocationPropertyBase::setApprovalStatus()
     * @uses ActivityLocationPropertyBase::setId()
     * @uses ActivityLocationPropertyBase::setActivityId()
     * @uses ActivityLocationPropertyBase::setActivity()
     * @uses ActivityLocationPropertyBase::setLocationId()
     * @uses ActivityLocationPropertyBase::setLocation()
     * @uses ActivityLocationPropertyBase::setApproverId()
     * @uses ActivityLocationPropertyBase::setApprover()
     * @uses ActivityLocationPropertyBase::setNotes()
     * @param string $approvalStatus
     * @param string $id
     * @param string $activityId
     * @param Activity $activity
     * @param string $locationId
     * @param Location $location
     * @param string $approverId
     * @param User $approver
     * @param string $notes
     */
    public function __construct($approvalStatus = null, $id = null, $activityId = null, Activity $activity = null, $locationId = null, Location $location = null, $approverId = null, User $approver = null, $notes = null)
    {
        $this
            ->setApprovalStatus($approvalStatus)
            ->setId($id)
            ->setActivityId($activityId)
            ->setActivity($activity)
            ->setLocationId($locationId)
            ->setLocation($location)
            ->setApproverId($approverId)
            ->setApprover($approver)
            ->setNotes($notes);
    }
    /**
     * Get ApprovalStatus value
     * @return string
     */
    public function getApprovalStatus()
    {
        return $this->ApprovalStatus;
    }
    /**
     * Set ApprovalStatus value
     * @uses ApprovalStatus::valueIsValid()
     * @uses ApprovalStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $approvalStatus
     * @return ActivityLocationPropertyBase
     */
    public function setApprovalStatus($approvalStatus = null)
    {
        // validation for constraint: enumeration
        if (!ApprovalStatus::valueIsValid($approvalStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $approvalStatus, implode(', ', ApprovalStatus::getValidValues())), __LINE__);
        }
        $this->ApprovalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return ActivityLocationPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return ActivityLocationPropertyBase
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get Activity value
     * @return Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param Activity $activity
     * @return ActivityLocationPropertyBase
     */
    public function setActivity(Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get LocationId value
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->LocationId;
    }
    /**
     * Set LocationId value
     * @param string $locationId
     * @return ActivityLocationPropertyBase
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: string
        if (!is_null($locationId) && !is_string($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationId)), __LINE__);
        }
        $this->LocationId = $locationId;
        return $this;
    }
    /**
     * Get Location value
     * @return Location|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param Location $location
     * @return ActivityLocationPropertyBase
     */
    public function setLocation(Location $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get ApproverId value
     * @return string|null
     */
    public function getApproverId()
    {
        return $this->ApproverId;
    }
    /**
     * Set ApproverId value
     * @param string $approverId
     * @return ActivityLocationPropertyBase
     */
    public function setApproverId($approverId = null)
    {
        // validation for constraint: string
        if (!is_null($approverId) && !is_string($approverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approverId)), __LINE__);
        }
        $this->ApproverId = $approverId;
        return $this;
    }
    /**
     * Get Approver value
     * @return User|null
     */
    public function getApprover()
    {
        return $this->Approver;
    }
    /**
     * Set Approver value
     * @param User $approver
     * @return ActivityLocationPropertyBase
     */
    public function setApprover(User $approver = null)
    {
        $this->Approver = $approver;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return ActivityLocationPropertyBase
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ActivityLocationPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
