<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityAllocationPropertyBase StructType
 * @subpackage Structs
 */
abstract class ActivityAllocationPropertyBase extends Entity
{
    /**
     * The TotalSeats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $TotalSeats;
    /**
     * The OccupiedSeats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OccupiedSeats;
    /**
     * The ReservedSeats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReservedSeats;
    /**
     * The AllocationExpirationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $AllocationExpirationDate;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityId;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $Activity;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ActivityAllocationPropertyBase
     * @uses ActivityAllocationPropertyBase::setTotalSeats()
     * @uses ActivityAllocationPropertyBase::setOccupiedSeats()
     * @uses ActivityAllocationPropertyBase::setReservedSeats()
     * @uses ActivityAllocationPropertyBase::setAllocationExpirationDate()
     * @uses ActivityAllocationPropertyBase::setId()
     * @uses ActivityAllocationPropertyBase::setActivityId()
     * @uses ActivityAllocationPropertyBase::setActivity()
     * @uses ActivityAllocationPropertyBase::setName()
     * @uses ActivityAllocationPropertyBase::setDescription()
     * @param NullableInt32 $totalSeats
     * @param int $occupiedSeats
     * @param int $reservedSeats
     * @param NullableDateTime $allocationExpirationDate
     * @param string $id
     * @param string $activityId
     * @param Activity $activity
     * @param string $name
     * @param string $description
     */
    public function __construct(NullableInt32 $totalSeats = null, $occupiedSeats = null, $reservedSeats = null, NullableDateTime $allocationExpirationDate = null, $id = null, $activityId = null, Activity $activity = null, $name = null, $description = null)
    {
        $this
            ->setTotalSeats($totalSeats)
            ->setOccupiedSeats($occupiedSeats)
            ->setReservedSeats($reservedSeats)
            ->setAllocationExpirationDate($allocationExpirationDate)
            ->setId($id)
            ->setActivityId($activityId)
            ->setActivity($activity)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get TotalSeats value
     * @return NullableInt32
     */
    public function getTotalSeats()
    {
        return $this->TotalSeats;
    }
    /**
     * Set TotalSeats value
     * @param NullableInt32 $totalSeats
     * @return ActivityAllocationPropertyBase
     */
    public function setTotalSeats(NullableInt32 $totalSeats = null)
    {
        $this->TotalSeats = $totalSeats;
        return $this;
    }
    /**
     * Get OccupiedSeats value
     * @return int
     */
    public function getOccupiedSeats()
    {
        return $this->OccupiedSeats;
    }
    /**
     * Set OccupiedSeats value
     * @param int $occupiedSeats
     * @return ActivityAllocationPropertyBase
     */
    public function setOccupiedSeats($occupiedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($occupiedSeats) && !is_numeric($occupiedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($occupiedSeats)), __LINE__);
        }
        $this->OccupiedSeats = $occupiedSeats;
        return $this;
    }
    /**
     * Get ReservedSeats value
     * @return int
     */
    public function getReservedSeats()
    {
        return $this->ReservedSeats;
    }
    /**
     * Set ReservedSeats value
     * @param int $reservedSeats
     * @return ActivityAllocationPropertyBase
     */
    public function setReservedSeats($reservedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($reservedSeats) && !is_numeric($reservedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservedSeats)), __LINE__);
        }
        $this->ReservedSeats = $reservedSeats;
        return $this;
    }
    /**
     * Get AllocationExpirationDate value
     * @return NullableDateTime
     */
    public function getAllocationExpirationDate()
    {
        return $this->AllocationExpirationDate;
    }
    /**
     * Set AllocationExpirationDate value
     * @param NullableDateTime $allocationExpirationDate
     * @return ActivityAllocationPropertyBase
     */
    public function setAllocationExpirationDate(NullableDateTime $allocationExpirationDate = null)
    {
        $this->AllocationExpirationDate = $allocationExpirationDate;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return ActivityAllocationPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return ActivityAllocationPropertyBase
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get Activity value
     * @return Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param Activity $activity
     * @return ActivityAllocationPropertyBase
     */
    public function setActivity(Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return ActivityAllocationPropertyBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return ActivityAllocationPropertyBase
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ActivityAllocationPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
