<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserRequiredActivityPropertyBase StructType
 * @subpackage Structs
 */
abstract class UserRequiredActivityPropertyBase extends Entity
{
    /**
     * The MinimumGrade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $MinimumGrade;
    /**
     * The IsRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsRequired;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserId;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $User;
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityId;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $Activity;
    /**
     * The PriorityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriorityId;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Priority
     */
    public $Priority;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * Constructor method for UserRequiredActivityPropertyBase
     * @uses UserRequiredActivityPropertyBase::setMinimumGrade()
     * @uses UserRequiredActivityPropertyBase::setIsRequired()
     * @uses UserRequiredActivityPropertyBase::setId()
     * @uses UserRequiredActivityPropertyBase::setUserId()
     * @uses UserRequiredActivityPropertyBase::setUser()
     * @uses UserRequiredActivityPropertyBase::setActivityId()
     * @uses UserRequiredActivityPropertyBase::setActivity()
     * @uses UserRequiredActivityPropertyBase::setPriorityId()
     * @uses UserRequiredActivityPropertyBase::setPriority()
     * @uses UserRequiredActivityPropertyBase::setNote()
     * @param NullableInt32 $minimumGrade
     * @param int $isRequired
     * @param string $id
     * @param string $userId
     * @param User $user
     * @param string $activityId
     * @param Activity $activity
     * @param string $priorityId
     * @param Priority $priority
     * @param string $note
     */
    public function __construct(NullableInt32 $minimumGrade = null, $isRequired = null, $id = null, $userId = null, User $user = null, $activityId = null, Activity $activity = null, $priorityId = null, Priority $priority = null, $note = null)
    {
        $this
            ->setMinimumGrade($minimumGrade)
            ->setIsRequired($isRequired)
            ->setId($id)
            ->setUserId($userId)
            ->setUser($user)
            ->setActivityId($activityId)
            ->setActivity($activity)
            ->setPriorityId($priorityId)
            ->setPriority($priority)
            ->setNote($note);
    }
    /**
     * Get MinimumGrade value
     * @return NullableInt32
     */
    public function getMinimumGrade()
    {
        return $this->MinimumGrade;
    }
    /**
     * Set MinimumGrade value
     * @param NullableInt32 $minimumGrade
     * @return UserRequiredActivityPropertyBase
     */
    public function setMinimumGrade(NullableInt32 $minimumGrade = null)
    {
        $this->MinimumGrade = $minimumGrade;
        return $this;
    }
    /**
     * Get IsRequired value
     * @return int
     */
    public function getIsRequired()
    {
        return $this->IsRequired;
    }
    /**
     * Set IsRequired value
     * @param int $isRequired
     * @return UserRequiredActivityPropertyBase
     */
    public function setIsRequired($isRequired = null)
    {
        // validation for constraint: int
        if (!is_null($isRequired) && !is_numeric($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isRequired)), __LINE__);
        }
        $this->IsRequired = $isRequired;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return UserRequiredActivityPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return UserRequiredActivityPropertyBase
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get User value
     * @return User|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param User $user
     * @return UserRequiredActivityPropertyBase
     */
    public function setUser(User $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return UserRequiredActivityPropertyBase
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get Activity value
     * @return Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param Activity $activity
     * @return UserRequiredActivityPropertyBase
     */
    public function setActivity(Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get PriorityId value
     * @return string|null
     */
    public function getPriorityId()
    {
        return $this->PriorityId;
    }
    /**
     * Set PriorityId value
     * @param string $priorityId
     * @return UserRequiredActivityPropertyBase
     */
    public function setPriorityId($priorityId = null)
    {
        // validation for constraint: string
        if (!is_null($priorityId) && !is_string($priorityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priorityId)), __LINE__);
        }
        $this->PriorityId = $priorityId;
        return $this;
    }
    /**
     * Get Priority value
     * @return Priority|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param Priority $priority
     * @return UserRequiredActivityPropertyBase
     */
    public function setPriority(Priority $priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return UserRequiredActivityPropertyBase
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UserRequiredActivityPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
