<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserLanguagePropertyBase StructType
 * @subpackage Structs
 */
abstract class UserLanguagePropertyBase extends Entity
{
    /**
     * The LCID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LCID;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Status;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for UserLanguagePropertyBase
     * @uses UserLanguagePropertyBase::setLCID()
     * @uses UserLanguagePropertyBase::setStatus()
     * @uses UserLanguagePropertyBase::setId()
     * @uses UserLanguagePropertyBase::setName()
     * @param int $lCID
     * @param bool $status
     * @param string $id
     * @param string $name
     */
    public function __construct($lCID = null, $status = null, $id = null, $name = null)
    {
        $this
            ->setLCID($lCID)
            ->setStatus($status)
            ->setId($id)
            ->setName($name);
    }
    /**
     * Get LCID value
     * @return int
     */
    public function getLCID()
    {
        return $this->LCID;
    }
    /**
     * Set LCID value
     * @param int $lCID
     * @return UserLanguagePropertyBase
     */
    public function setLCID($lCID = null)
    {
        // validation for constraint: int
        if (!is_null($lCID) && !is_numeric($lCID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lCID)), __LINE__);
        }
        $this->LCID = $lCID;
        return $this;
    }
    /**
     * Get Status value
     * @return bool
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return UserLanguagePropertyBase
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return UserLanguagePropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return UserLanguagePropertyBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UserLanguagePropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
