<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the UserSecurityContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param UserSecurityContext $userSecurityContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserSecurityContext(UserSecurityContext $userSecurityContext, $nameSpace = 'http://www.sumtotalsystems.com/sumtotal7/sumtotalws/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserSecurityContext', $userSecurityContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpdateUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateUser $parameters
     * @return UpdateUserResponse|bool
     */
    public function UpdateUser(UpdateUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return UpdateUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
