<?php
/**
 * This class stands for TrackCostingRule EnumType
 * @subpackage Enumerations
 */
class TrackCostingRule
{
    /**
     * Constant for value 'NoEcommerceFixedPrice'
     * @return string 'NoEcommerceFixedPrice'
     */
    const VALUE_NO_ECOMMERCE_FIXED_PRICE = 'NoEcommerceFixedPrice';
    /**
     * Constant for value 'NoEcommerceVariablePrice'
     * @return string 'NoEcommerceVariablePrice'
     */
    const VALUE_NO_ECOMMERCE_VARIABLE_PRICE = 'NoEcommerceVariablePrice';
    /**
     * Constant for value 'EcommerceFixedPrice'
     * @return string 'EcommerceFixedPrice'
     */
    const VALUE_ECOMMERCE_FIXED_PRICE = 'EcommerceFixedPrice';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_ECOMMERCE_FIXED_PRICE
     * @uses self::VALUE_NO_ECOMMERCE_VARIABLE_PRICE
     * @uses self::VALUE_ECOMMERCE_FIXED_PRICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_ECOMMERCE_FIXED_PRICE,
            self::VALUE_NO_ECOMMERCE_VARIABLE_PRICE,
            self::VALUE_ECOMMERCE_FIXED_PRICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
