<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TRDIFSettingsPropertyBase StructType
 * @subpackage Structs
 */
abstract class TRDIFSettingsPropertyBase extends Entity
{
    /**
     * The IsDIF
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDIF;
    /**
     * The LegalDurationDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDouble
     */
    public $LegalDurationDays;
    /**
     * The LegalDurationHours
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $LegalDurationHours;
    /**
     * The LegalDurationMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $LegalDurationMinutes;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The PreReq
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreReq;
    /**
     * The PublicConcern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PublicConcern;
    /**
     * The Objectives
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Objectives;
    /**
     * The Methods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Methods;
    /**
     * The ExternalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalID;
    /**
     * The TROrgId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TROrgId;
    /**
     * The TROrg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TotalRegulationOrg
     */
    public $TROrg;
    /**
     * The TRCategoryId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TRCategoryId;
    /**
     * The TRCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TotalRegulationCategory
     */
    public $TRCategory;
    /**
     * Constructor method for TRDIFSettingsPropertyBase
     * @uses TRDIFSettingsPropertyBase::setIsDIF()
     * @uses TRDIFSettingsPropertyBase::setLegalDurationDays()
     * @uses TRDIFSettingsPropertyBase::setLegalDurationHours()
     * @uses TRDIFSettingsPropertyBase::setLegalDurationMinutes()
     * @uses TRDIFSettingsPropertyBase::setId()
     * @uses TRDIFSettingsPropertyBase::setPreReq()
     * @uses TRDIFSettingsPropertyBase::setPublicConcern()
     * @uses TRDIFSettingsPropertyBase::setObjectives()
     * @uses TRDIFSettingsPropertyBase::setMethods()
     * @uses TRDIFSettingsPropertyBase::setExternalID()
     * @uses TRDIFSettingsPropertyBase::setTROrgId()
     * @uses TRDIFSettingsPropertyBase::setTROrg()
     * @uses TRDIFSettingsPropertyBase::setTRCategoryId()
     * @uses TRDIFSettingsPropertyBase::setTRCategory()
     * @param bool $isDIF
     * @param NullableDouble $legalDurationDays
     * @param NullableInt32 $legalDurationHours
     * @param NullableInt32 $legalDurationMinutes
     * @param string $id
     * @param string $preReq
     * @param string $publicConcern
     * @param string $objectives
     * @param string $methods
     * @param string $externalID
     * @param string $tROrgId
     * @param TotalRegulationOrg $tROrg
     * @param string $tRCategoryId
     * @param TotalRegulationCategory $tRCategory
     */
    public function __construct($isDIF = null, NullableDouble $legalDurationDays = null, NullableInt32 $legalDurationHours = null, NullableInt32 $legalDurationMinutes = null, $id = null, $preReq = null, $publicConcern = null, $objectives = null, $methods = null, $externalID = null, $tROrgId = null, TotalRegulationOrg $tROrg = null, $tRCategoryId = null, TotalRegulationCategory $tRCategory = null)
    {
        $this
            ->setIsDIF($isDIF)
            ->setLegalDurationDays($legalDurationDays)
            ->setLegalDurationHours($legalDurationHours)
            ->setLegalDurationMinutes($legalDurationMinutes)
            ->setId($id)
            ->setPreReq($preReq)
            ->setPublicConcern($publicConcern)
            ->setObjectives($objectives)
            ->setMethods($methods)
            ->setExternalID($externalID)
            ->setTROrgId($tROrgId)
            ->setTROrg($tROrg)
            ->setTRCategoryId($tRCategoryId)
            ->setTRCategory($tRCategory);
    }
    /**
     * Get IsDIF value
     * @return bool
     */
    public function getIsDIF()
    {
        return $this->IsDIF;
    }
    /**
     * Set IsDIF value
     * @param bool $isDIF
     * @return TRDIFSettingsPropertyBase
     */
    public function setIsDIF($isDIF = null)
    {
        $this->IsDIF = $isDIF;
        return $this;
    }
    /**
     * Get LegalDurationDays value
     * @return NullableDouble
     */
    public function getLegalDurationDays()
    {
        return $this->LegalDurationDays;
    }
    /**
     * Set LegalDurationDays value
     * @param NullableDouble $legalDurationDays
     * @return TRDIFSettingsPropertyBase
     */
    public function setLegalDurationDays(NullableDouble $legalDurationDays = null)
    {
        $this->LegalDurationDays = $legalDurationDays;
        return $this;
    }
    /**
     * Get LegalDurationHours value
     * @return NullableInt32
     */
    public function getLegalDurationHours()
    {
        return $this->LegalDurationHours;
    }
    /**
     * Set LegalDurationHours value
     * @param NullableInt32 $legalDurationHours
     * @return TRDIFSettingsPropertyBase
     */
    public function setLegalDurationHours(NullableInt32 $legalDurationHours = null)
    {
        $this->LegalDurationHours = $legalDurationHours;
        return $this;
    }
    /**
     * Get LegalDurationMinutes value
     * @return NullableInt32
     */
    public function getLegalDurationMinutes()
    {
        return $this->LegalDurationMinutes;
    }
    /**
     * Set LegalDurationMinutes value
     * @param NullableInt32 $legalDurationMinutes
     * @return TRDIFSettingsPropertyBase
     */
    public function setLegalDurationMinutes(NullableInt32 $legalDurationMinutes = null)
    {
        $this->LegalDurationMinutes = $legalDurationMinutes;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return TRDIFSettingsPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get PreReq value
     * @return string|null
     */
    public function getPreReq()
    {
        return $this->PreReq;
    }
    /**
     * Set PreReq value
     * @param string $preReq
     * @return TRDIFSettingsPropertyBase
     */
    public function setPreReq($preReq = null)
    {
        // validation for constraint: string
        if (!is_null($preReq) && !is_string($preReq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preReq)), __LINE__);
        }
        $this->PreReq = $preReq;
        return $this;
    }
    /**
     * Get PublicConcern value
     * @return string|null
     */
    public function getPublicConcern()
    {
        return $this->PublicConcern;
    }
    /**
     * Set PublicConcern value
     * @param string $publicConcern
     * @return TRDIFSettingsPropertyBase
     */
    public function setPublicConcern($publicConcern = null)
    {
        // validation for constraint: string
        if (!is_null($publicConcern) && !is_string($publicConcern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($publicConcern)), __LINE__);
        }
        $this->PublicConcern = $publicConcern;
        return $this;
    }
    /**
     * Get Objectives value
     * @return string|null
     */
    public function getObjectives()
    {
        return $this->Objectives;
    }
    /**
     * Set Objectives value
     * @param string $objectives
     * @return TRDIFSettingsPropertyBase
     */
    public function setObjectives($objectives = null)
    {
        // validation for constraint: string
        if (!is_null($objectives) && !is_string($objectives)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectives)), __LINE__);
        }
        $this->Objectives = $objectives;
        return $this;
    }
    /**
     * Get Methods value
     * @return string|null
     */
    public function getMethods()
    {
        return $this->Methods;
    }
    /**
     * Set Methods value
     * @param string $methods
     * @return TRDIFSettingsPropertyBase
     */
    public function setMethods($methods = null)
    {
        // validation for constraint: string
        if (!is_null($methods) && !is_string($methods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($methods)), __LINE__);
        }
        $this->Methods = $methods;
        return $this;
    }
    /**
     * Get ExternalID value
     * @return string|null
     */
    public function getExternalID()
    {
        return $this->ExternalID;
    }
    /**
     * Set ExternalID value
     * @param string $externalID
     * @return TRDIFSettingsPropertyBase
     */
    public function setExternalID($externalID = null)
    {
        // validation for constraint: string
        if (!is_null($externalID) && !is_string($externalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalID)), __LINE__);
        }
        $this->ExternalID = $externalID;
        return $this;
    }
    /**
     * Get TROrgId value
     * @return string|null
     */
    public function getTROrgId()
    {
        return $this->TROrgId;
    }
    /**
     * Set TROrgId value
     * @param string $tROrgId
     * @return TRDIFSettingsPropertyBase
     */
    public function setTROrgId($tROrgId = null)
    {
        // validation for constraint: string
        if (!is_null($tROrgId) && !is_string($tROrgId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tROrgId)), __LINE__);
        }
        $this->TROrgId = $tROrgId;
        return $this;
    }
    /**
     * Get TROrg value
     * @return TotalRegulationOrg|null
     */
    public function getTROrg()
    {
        return $this->TROrg;
    }
    /**
     * Set TROrg value
     * @param TotalRegulationOrg $tROrg
     * @return TRDIFSettingsPropertyBase
     */
    public function setTROrg(TotalRegulationOrg $tROrg = null)
    {
        $this->TROrg = $tROrg;
        return $this;
    }
    /**
     * Get TRCategoryId value
     * @return string|null
     */
    public function getTRCategoryId()
    {
        return $this->TRCategoryId;
    }
    /**
     * Set TRCategoryId value
     * @param string $tRCategoryId
     * @return TRDIFSettingsPropertyBase
     */
    public function setTRCategoryId($tRCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($tRCategoryId) && !is_string($tRCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tRCategoryId)), __LINE__);
        }
        $this->TRCategoryId = $tRCategoryId;
        return $this;
    }
    /**
     * Get TRCategory value
     * @return TotalRegulationCategory|null
     */
    public function getTRCategory()
    {
        return $this->TRCategory;
    }
    /**
     * Set TRCategory value
     * @param TotalRegulationCategory $tRCategory
     * @return TRDIFSettingsPropertyBase
     */
    public function setTRCategory(TotalRegulationCategory $tRCategory = null)
    {
        $this->TRCategory = $tRCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return TRDIFSettingsPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
