<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurityRolePropertyBase StructType
 * @subpackage Structs
 */
abstract class SecurityRolePropertyBase extends Entity
{
    /**
     * The IsDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDefault;
    /**
     * The InheritPermissions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $InheritPermissions;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainId;
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Domain
     */
    public $Domain;
    /**
     * The BaseRoleId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BaseRoleId;
    /**
     * The BaseRole
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var SecurityRole
     */
    public $BaseRole;
    /**
     * The Permissions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var Permission[]
     */
    public $Permissions;
    /**
     * Constructor method for SecurityRolePropertyBase
     * @uses SecurityRolePropertyBase::setIsDefault()
     * @uses SecurityRolePropertyBase::setInheritPermissions()
     * @uses SecurityRolePropertyBase::setIsActive()
     * @uses SecurityRolePropertyBase::setId()
     * @uses SecurityRolePropertyBase::setName()
     * @uses SecurityRolePropertyBase::setDescription()
     * @uses SecurityRolePropertyBase::setDomainId()
     * @uses SecurityRolePropertyBase::setDomain()
     * @uses SecurityRolePropertyBase::setBaseRoleId()
     * @uses SecurityRolePropertyBase::setBaseRole()
     * @uses SecurityRolePropertyBase::setPermissions()
     * @param bool $isDefault
     * @param bool $inheritPermissions
     * @param bool $isActive
     * @param string $id
     * @param string $name
     * @param string $description
     * @param string $domainId
     * @param Domain $domain
     * @param string $baseRoleId
     * @param SecurityRole $baseRole
     * @param Permission[] $permissions
     */
    public function __construct($isDefault = null, $inheritPermissions = null, $isActive = null, $id = null, $name = null, $description = null, $domainId = null, Domain $domain = null, $baseRoleId = null, SecurityRole $baseRole = null, array $permissions = array())
    {
        $this
            ->setIsDefault($isDefault)
            ->setInheritPermissions($inheritPermissions)
            ->setIsActive($isActive)
            ->setId($id)
            ->setName($name)
            ->setDescription($description)
            ->setDomainId($domainId)
            ->setDomain($domain)
            ->setBaseRoleId($baseRoleId)
            ->setBaseRole($baseRole)
            ->setPermissions($permissions);
    }
    /**
     * Get IsDefault value
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return SecurityRolePropertyBase
     */
    public function setIsDefault($isDefault = null)
    {
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get InheritPermissions value
     * @return bool
     */
    public function getInheritPermissions()
    {
        return $this->InheritPermissions;
    }
    /**
     * Set InheritPermissions value
     * @param bool $inheritPermissions
     * @return SecurityRolePropertyBase
     */
    public function setInheritPermissions($inheritPermissions = null)
    {
        $this->InheritPermissions = $inheritPermissions;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return SecurityRolePropertyBase
     */
    public function setIsActive($isActive = null)
    {
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return SecurityRolePropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return SecurityRolePropertyBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return SecurityRolePropertyBase
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DomainId value
     * @return string|null
     */
    public function getDomainId()
    {
        return $this->DomainId;
    }
    /**
     * Set DomainId value
     * @param string $domainId
     * @return SecurityRolePropertyBase
     */
    public function setDomainId($domainId = null)
    {
        // validation for constraint: string
        if (!is_null($domainId) && !is_string($domainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainId)), __LINE__);
        }
        $this->DomainId = $domainId;
        return $this;
    }
    /**
     * Get Domain value
     * @return Domain|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param Domain $domain
     * @return SecurityRolePropertyBase
     */
    public function setDomain(Domain $domain = null)
    {
        $this->Domain = $domain;
        return $this;
    }
    /**
     * Get BaseRoleId value
     * @return string|null
     */
    public function getBaseRoleId()
    {
        return $this->BaseRoleId;
    }
    /**
     * Set BaseRoleId value
     * @param string $baseRoleId
     * @return SecurityRolePropertyBase
     */
    public function setBaseRoleId($baseRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($baseRoleId) && !is_string($baseRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseRoleId)), __LINE__);
        }
        $this->BaseRoleId = $baseRoleId;
        return $this;
    }
    /**
     * Get BaseRole value
     * @return SecurityRole|null
     */
    public function getBaseRole()
    {
        return $this->BaseRole;
    }
    /**
     * Set BaseRole value
     * @param SecurityRole $baseRole
     * @return SecurityRolePropertyBase
     */
    public function setBaseRole(SecurityRole $baseRole = null)
    {
        $this->BaseRole = $baseRole;
        return $this;
    }
    /**
     * Get Permissions value
     * @return Permission[]|null
     */
    public function getPermissions()
    {
        return $this->Permissions;
    }
    /**
     * Set Permissions value
     * @throws \InvalidArgumentException
     * @param Permission[] $permissions
     * @return SecurityRolePropertyBase
     */
    public function setPermissions(array $permissions = array())
    {
        foreach ($permissions as $securityRolePropertyBasePermissionsItem) {
            // validation for constraint: itemType
            if (!$securityRolePropertyBasePermissionsItem instanceof Permission) {
                throw new \InvalidArgumentException(sprintf('The Permissions property can only contain items of Permission, "%s" given', is_object($securityRolePropertyBasePermissionsItem) ? get_class($securityRolePropertyBasePermissionsItem) : gettype($securityRolePropertyBasePermissionsItem)), __LINE__);
            }
        }
        $this->Permissions = $permissions;
        return $this;
    }
    /**
     * Add item to Permissions value
     * @throws \InvalidArgumentException
     * @param Permission $item
     * @return SecurityRolePropertyBase
     */
    public function addToPermissions(Permission $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof Permission) {
            throw new \InvalidArgumentException(sprintf('The Permissions property can only contain items of Permission, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Permissions[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return SecurityRolePropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
