<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Sets the UserSecurityContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param UserSecurityContext $userSecurityContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserSecurityContext(UserSecurityContext $userSecurityContext, $nameSpace = 'http://www.sumtotalsystems.com/sumtotal7/sumtotalws/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserSecurityContext', $userSecurityContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RemoveRequiredSkill
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param RemoveRequiredSkill $parameters
     * @return RemoveRequiredSkillResponse|bool
     */
    public function RemoveRequiredSkill(RemoveRequiredSkill $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveRequiredSkill($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveAcquiredSkill
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param RemoveAcquiredSkill $parameters
     * @return RemoveAcquiredSkillResponse|bool
     */
    public function RemoveAcquiredSkill(RemoveAcquiredSkill $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveAcquiredSkill($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveRequiredCompetency
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param RemoveRequiredCompetency $parameters
     * @return RemoveRequiredCompetencyResponse|bool
     */
    public function RemoveRequiredCompetency(RemoveRequiredCompetency $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveRequiredCompetency($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemoveRequiredActivity
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param RemoveRequiredActivity $parameters
     * @return RemoveRequiredActivityResponse|bool
     */
    public function RemoveRequiredActivity(RemoveRequiredActivity $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveRequiredActivity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return RemoveAcquiredSkillResponse|RemoveRequiredActivityResponse|RemoveRequiredCompetencyResponse|RemoveRequiredSkillResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
