<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NullableInt32 StructType
 * @subpackage Structs
 */
class NullableInt32 extends AbstractStructBase
{
    /**
     * The IsNull
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNull;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Value;
    /**
     * Constructor method for NullableInt32
     * @uses NullableInt32::setIsNull()
     * @uses NullableInt32::setValue()
     * @param bool $isNull
     * @param int $value
     */
    public function __construct($isNull = null, $value = null)
    {
        $this
            ->setIsNull($isNull)
            ->setValue($value);
    }
    /**
     * Get IsNull value
     * @return bool
     */
    public function getIsNull()
    {
        return $this->IsNull;
    }
    /**
     * Set IsNull value
     * @param bool $isNull
     * @return NullableInt32
     */
    public function setIsNull($isNull = null)
    {
        $this->IsNull = $isNull;
        return $this;
    }
    /**
     * Get Value value
     * @return int
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return NullableInt32
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !is_numeric($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return NullableInt32
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
