<?php
/**
 * This class stands for LaunchMethod EnumType
 * @subpackage Enumerations
 */
class LaunchMethod
{
    /**
     * Constant for value 'NONE'
     * @return string 'NONE'
     */
    const VALUE_NONE = 'NONE';
    /**
     * Constant for value 'SUMTOTAL_TOOLBOOK'
     * @return string 'SUMTOTAL_TOOLBOOK'
     */
    const VALUE_SUMTOTAL_TOOLBOOK = 'SUMTOTAL_TOOLBOOK';
    /**
     * Constant for value 'AT_T_CONNECT'
     * @return string 'AT_T_CONNECT'
     */
    const VALUE_AT_T_CONNECT = 'AT_T_CONNECT';
    /**
     * Constant for value 'SUMTOTAL_CONTENT_API'
     * @return string 'SUMTOTAL_CONTENT_API'
     */
    const VALUE_SUMTOTAL_CONTENT_API = 'SUMTOTAL_CONTENT_API';
    /**
     * Constant for value 'AICC_HACP'
     * @return string 'AICC_HACP'
     */
    const VALUE_AICC_HACP = 'AICC_HACP';
    /**
     * Constant for value 'SKILLSOFT_COURSE_PLAYER'
     * @return string 'SKILLSOFT_COURSE_PLAYER'
     */
    const VALUE_SKILLSOFT_COURSE_PLAYER = 'SKILLSOFT_COURSE_PLAYER';
    /**
     * Constant for value 'MACROMEDIA_AUTHORWARE'
     * @return string 'MACROMEDIA_AUTHORWARE'
     */
    const VALUE_MACROMEDIA_AUTHORWARE = 'MACROMEDIA_AUTHORWARE';
    /**
     * Constant for value 'QUESTIONMARK_PERCEPTION_AICC'
     * @return string 'QUESTIONMARK_PERCEPTION_AICC'
     */
    const VALUE_QUESTIONMARK_PERCEPTION_AICC = 'QUESTIONMARK_PERCEPTION_AICC';
    /**
     * Constant for value 'NETG_LEARNING_STUDIO'
     * @return string 'NETG_LEARNING_STUDIO'
     */
    const VALUE_NETG_LEARNING_STUDIO = 'NETG_LEARNING_STUDIO';
    /**
     * Constant for value 'MACROMEDIA_COURSEBUILDER'
     * @return string 'MACROMEDIA_COURSEBUILDER'
     */
    const VALUE_MACROMEDIA_COURSEBUILDER = 'MACROMEDIA_COURSEBUILDER';
    /**
     * Constant for value 'SUMTOTAL_VIRTUAL_CLASSROOM'
     * @return string 'SUMTOTAL_VIRTUAL_CLASSROOM'
     */
    const VALUE_SUMTOTAL_VIRTUAL_CLASSROOM = 'SUMTOTAL_VIRTUAL_CLASSROOM';
    /**
     * Constant for value 'KNOWLEDGE_DOCUMENT'
     * @return string 'KNOWLEDGE_DOCUMENT'
     */
    const VALUE_KNOWLEDGE_DOCUMENT = 'KNOWLEDGE_DOCUMENT';
    /**
     * Constant for value 'MENTERGY_LEARNLINC'
     * @return string 'MENTERGY_LEARNLINC'
     */
    const VALUE_MENTERGY_LEARNLINC = 'MENTERGY_LEARNLINC';
    /**
     * Constant for value 'SKILLSOFT_IT_SKILLS'
     * @return string 'SKILLSOFT_IT_SKILLS'
     */
    const VALUE_SKILLSOFT_IT_SKILLS = 'SKILLSOFT_IT_SKILLS';
    /**
     * Constant for value 'AICC_JAVASCRIPT'
     * @return string 'AICC_JAVASCRIPT'
     */
    const VALUE_AICC_JAVASCRIPT = 'AICC_JAVASCRIPT';
    /**
     * Constant for value 'CENTRA'
     * @return string 'CENTRA'
     */
    const VALUE_CENTRA = 'CENTRA';
    /**
     * Constant for value 'SUMTOTAL_EXPERIENCE'
     * @return string 'SUMTOTAL_EXPERIENCE'
     */
    const VALUE_SUMTOTAL_EXPERIENCE = 'SUMTOTAL_EXPERIENCE';
    /**
     * Constant for value 'SCORM_1_2'
     * @return string 'SCORM_1_2'
     */
    const VALUE_SCORM_1_2 = 'SCORM_1_2';
    /**
     * Constant for value 'GENERIC_DOCUMENT'
     * @return string 'GENERIC_DOCUMENT'
     */
    const VALUE_GENERIC_DOCUMENT = 'GENERIC_DOCUMENT';
    /**
     * Constant for value 'SKILLSOFT_SKILL_SIM'
     * @return string 'SKILLSOFT_SKILL_SIM'
     */
    const VALUE_SKILLSOFT_SKILL_SIM = 'SKILLSOFT_SKILL_SIM';
    /**
     * Constant for value 'SCORM_2004'
     * @return string 'SCORM_2004'
     */
    const VALUE_SCORM_2004 = 'SCORM_2004';
    /**
     * Constant for value 'WEBEX'
     * @return string 'WEBEX'
     */
    const VALUE_WEBEX = 'WEBEX';
    /**
     * Constant for value 'ADOBE_ACROBAT_CONNECT_PROFESSIONAL'
     * @return string 'ADOBE_ACROBAT_CONNECT_PROFESSIONAL'
     */
    const VALUE_ADOBE_ACROBAT_CONNECT_PROFESSIONAL = 'ADOBE_ACROBAT_CONNECT_PROFESSIONAL';
    /**
     * Constant for value 'LIVEMEETING'
     * @return string 'LIVEMEETING'
     */
    const VALUE_LIVEMEETING = 'LIVEMEETING';
    /**
     * Constant for value 'QUICK_ASSESSMENT'
     * @return string 'QUICK_ASSESSMENT'
     */
    const VALUE_QUICK_ASSESSMENT = 'QUICK_ASSESSMENT';
    /**
     * Constant for value 'MOBILE_SCORM_1_2'
     * @return string 'MOBILE_SCORM_1_2'
     */
    const VALUE_MOBILE_SCORM_1_2 = 'MOBILE_SCORM_1_2';
    /**
     * Constant for value 'ILINC'
     * @return string 'ILINC'
     */
    const VALUE_ILINC = 'ILINC';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_SUMTOTAL_TOOLBOOK
     * @uses self::VALUE_AT_T_CONNECT
     * @uses self::VALUE_SUMTOTAL_CONTENT_API
     * @uses self::VALUE_AICC_HACP
     * @uses self::VALUE_SKILLSOFT_COURSE_PLAYER
     * @uses self::VALUE_MACROMEDIA_AUTHORWARE
     * @uses self::VALUE_QUESTIONMARK_PERCEPTION_AICC
     * @uses self::VALUE_NETG_LEARNING_STUDIO
     * @uses self::VALUE_MACROMEDIA_COURSEBUILDER
     * @uses self::VALUE_SUMTOTAL_VIRTUAL_CLASSROOM
     * @uses self::VALUE_KNOWLEDGE_DOCUMENT
     * @uses self::VALUE_MENTERGY_LEARNLINC
     * @uses self::VALUE_SKILLSOFT_IT_SKILLS
     * @uses self::VALUE_AICC_JAVASCRIPT
     * @uses self::VALUE_CENTRA
     * @uses self::VALUE_SUMTOTAL_EXPERIENCE
     * @uses self::VALUE_SCORM_1_2
     * @uses self::VALUE_GENERIC_DOCUMENT
     * @uses self::VALUE_SKILLSOFT_SKILL_SIM
     * @uses self::VALUE_SCORM_2004
     * @uses self::VALUE_WEBEX
     * @uses self::VALUE_ADOBE_ACROBAT_CONNECT_PROFESSIONAL
     * @uses self::VALUE_LIVEMEETING
     * @uses self::VALUE_QUICK_ASSESSMENT
     * @uses self::VALUE_MOBILE_SCORM_1_2
     * @uses self::VALUE_ILINC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_SUMTOTAL_TOOLBOOK,
            self::VALUE_AT_T_CONNECT,
            self::VALUE_SUMTOTAL_CONTENT_API,
            self::VALUE_AICC_HACP,
            self::VALUE_SKILLSOFT_COURSE_PLAYER,
            self::VALUE_MACROMEDIA_AUTHORWARE,
            self::VALUE_QUESTIONMARK_PERCEPTION_AICC,
            self::VALUE_NETG_LEARNING_STUDIO,
            self::VALUE_MACROMEDIA_COURSEBUILDER,
            self::VALUE_SUMTOTAL_VIRTUAL_CLASSROOM,
            self::VALUE_KNOWLEDGE_DOCUMENT,
            self::VALUE_MENTERGY_LEARNLINC,
            self::VALUE_SKILLSOFT_IT_SKILLS,
            self::VALUE_AICC_JAVASCRIPT,
            self::VALUE_CENTRA,
            self::VALUE_SUMTOTAL_EXPERIENCE,
            self::VALUE_SCORM_1_2,
            self::VALUE_GENERIC_DOCUMENT,
            self::VALUE_SKILLSOFT_SKILL_SIM,
            self::VALUE_SCORM_2004,
            self::VALUE_WEBEX,
            self::VALUE_ADOBE_ACROBAT_CONNECT_PROFESSIONAL,
            self::VALUE_LIVEMEETING,
            self::VALUE_QUICK_ASSESSMENT,
            self::VALUE_MOBILE_SCORM_1_2,
            self::VALUE_ILINC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
