<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobRequiredActivityPropertyBase StructType
 * @subpackage Structs
 */
abstract class JobRequiredActivityPropertyBase extends Entity
{
    /**
     * The MinimumGrade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $MinimumGrade;
    /**
     * The IsRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsRequired;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The JobId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobId;
    /**
     * The Job
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Job
     */
    public $Job;
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityId;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $Activity;
    /**
     * The PriorityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriorityId;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Priority
     */
    public $Priority;
    /**
     * Constructor method for JobRequiredActivityPropertyBase
     * @uses JobRequiredActivityPropertyBase::setMinimumGrade()
     * @uses JobRequiredActivityPropertyBase::setIsRequired()
     * @uses JobRequiredActivityPropertyBase::setId()
     * @uses JobRequiredActivityPropertyBase::setJobId()
     * @uses JobRequiredActivityPropertyBase::setJob()
     * @uses JobRequiredActivityPropertyBase::setActivityId()
     * @uses JobRequiredActivityPropertyBase::setActivity()
     * @uses JobRequiredActivityPropertyBase::setPriorityId()
     * @uses JobRequiredActivityPropertyBase::setPriority()
     * @param NullableInt32 $minimumGrade
     * @param int $isRequired
     * @param string $id
     * @param string $jobId
     * @param Job $job
     * @param string $activityId
     * @param Activity $activity
     * @param string $priorityId
     * @param Priority $priority
     */
    public function __construct(NullableInt32 $minimumGrade = null, $isRequired = null, $id = null, $jobId = null, Job $job = null, $activityId = null, Activity $activity = null, $priorityId = null, Priority $priority = null)
    {
        $this
            ->setMinimumGrade($minimumGrade)
            ->setIsRequired($isRequired)
            ->setId($id)
            ->setJobId($jobId)
            ->setJob($job)
            ->setActivityId($activityId)
            ->setActivity($activity)
            ->setPriorityId($priorityId)
            ->setPriority($priority);
    }
    /**
     * Get MinimumGrade value
     * @return NullableInt32
     */
    public function getMinimumGrade()
    {
        return $this->MinimumGrade;
    }
    /**
     * Set MinimumGrade value
     * @param NullableInt32 $minimumGrade
     * @return JobRequiredActivityPropertyBase
     */
    public function setMinimumGrade(NullableInt32 $minimumGrade = null)
    {
        $this->MinimumGrade = $minimumGrade;
        return $this;
    }
    /**
     * Get IsRequired value
     * @return int
     */
    public function getIsRequired()
    {
        return $this->IsRequired;
    }
    /**
     * Set IsRequired value
     * @param int $isRequired
     * @return JobRequiredActivityPropertyBase
     */
    public function setIsRequired($isRequired = null)
    {
        // validation for constraint: int
        if (!is_null($isRequired) && !is_numeric($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isRequired)), __LINE__);
        }
        $this->IsRequired = $isRequired;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return JobRequiredActivityPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get JobId value
     * @return string|null
     */
    public function getJobId()
    {
        return $this->JobId;
    }
    /**
     * Set JobId value
     * @param string $jobId
     * @return JobRequiredActivityPropertyBase
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: string
        if (!is_null($jobId) && !is_string($jobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jobId)), __LINE__);
        }
        $this->JobId = $jobId;
        return $this;
    }
    /**
     * Get Job value
     * @return Job|null
     */
    public function getJob()
    {
        return $this->Job;
    }
    /**
     * Set Job value
     * @param Job $job
     * @return JobRequiredActivityPropertyBase
     */
    public function setJob(Job $job = null)
    {
        $this->Job = $job;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return JobRequiredActivityPropertyBase
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get Activity value
     * @return Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param Activity $activity
     * @return JobRequiredActivityPropertyBase
     */
    public function setActivity(Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get PriorityId value
     * @return string|null
     */
    public function getPriorityId()
    {
        return $this->PriorityId;
    }
    /**
     * Set PriorityId value
     * @param string $priorityId
     * @return JobRequiredActivityPropertyBase
     */
    public function setPriorityId($priorityId = null)
    {
        // validation for constraint: string
        if (!is_null($priorityId) && !is_string($priorityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priorityId)), __LINE__);
        }
        $this->PriorityId = $priorityId;
        return $this;
    }
    /**
     * Get Priority value
     * @return Priority|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param Priority $priority
     * @return JobRequiredActivityPropertyBase
     */
    public function setPriority(Priority $priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return JobRequiredActivityPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
