<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserById StructType
 * @subpackage Structs
 */
class GetUserById extends AbstractStructBase
{
    /**
     * The populationLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $populationLevel;
    /**
     * The usrId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usrId;
    /**
     * Constructor method for GetUserById
     * @uses GetUserById::setPopulationLevel()
     * @uses GetUserById::setUsrId()
     * @param int $populationLevel
     * @param string $usrId
     */
    public function __construct($populationLevel = null, $usrId = null)
    {
        $this
            ->setPopulationLevel($populationLevel)
            ->setUsrId($usrId);
    }
    /**
     * Get populationLevel value
     * @return int
     */
    public function getPopulationLevel()
    {
        return $this->populationLevel;
    }
    /**
     * Set populationLevel value
     * @param int $populationLevel
     * @return GetUserById
     */
    public function setPopulationLevel($populationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($populationLevel) && !is_numeric($populationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($populationLevel)), __LINE__);
        }
        $this->populationLevel = $populationLevel;
        return $this;
    }
    /**
     * Get usrId value
     * @return string|null
     */
    public function getUsrId()
    {
        return $this->usrId;
    }
    /**
     * Set usrId value
     * @param string $usrId
     * @return GetUserById
     */
    public function setUsrId($usrId = null)
    {
        // validation for constraint: string
        if (!is_null($usrId) && !is_string($usrId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usrId)), __LINE__);
        }
        $this->usrId = $usrId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetUserById
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
