<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserAssignmentStatusByJob StructType
 * @subpackage Structs
 */
class GetUserAssignmentStatusByJob extends AbstractStructBase
{
    /**
     * The assignmentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $assignmentType;
    /**
     * The usrNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usrNumber;
    /**
     * The jobCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $jobCode;
    /**
     * Constructor method for GetUserAssignmentStatusByJob
     * @uses GetUserAssignmentStatusByJob::setAssignmentType()
     * @uses GetUserAssignmentStatusByJob::setUsrNumber()
     * @uses GetUserAssignmentStatusByJob::setJobCode()
     * @param int $assignmentType
     * @param string $usrNumber
     * @param string $jobCode
     */
    public function __construct($assignmentType = null, $usrNumber = null, $jobCode = null)
    {
        $this
            ->setAssignmentType($assignmentType)
            ->setUsrNumber($usrNumber)
            ->setJobCode($jobCode);
    }
    /**
     * Get assignmentType value
     * @return int
     */
    public function getAssignmentType()
    {
        return $this->assignmentType;
    }
    /**
     * Set assignmentType value
     * @param int $assignmentType
     * @return GetUserAssignmentStatusByJob
     */
    public function setAssignmentType($assignmentType = null)
    {
        // validation for constraint: int
        if (!is_null($assignmentType) && !is_numeric($assignmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($assignmentType)), __LINE__);
        }
        $this->assignmentType = $assignmentType;
        return $this;
    }
    /**
     * Get usrNumber value
     * @return string|null
     */
    public function getUsrNumber()
    {
        return $this->usrNumber;
    }
    /**
     * Set usrNumber value
     * @param string $usrNumber
     * @return GetUserAssignmentStatusByJob
     */
    public function setUsrNumber($usrNumber = null)
    {
        // validation for constraint: string
        if (!is_null($usrNumber) && !is_string($usrNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usrNumber)), __LINE__);
        }
        $this->usrNumber = $usrNumber;
        return $this;
    }
    /**
     * Get jobCode value
     * @return string|null
     */
    public function getJobCode()
    {
        return $this->jobCode;
    }
    /**
     * Set jobCode value
     * @param string $jobCode
     * @return GetUserAssignmentStatusByJob
     */
    public function setJobCode($jobCode = null)
    {
        // validation for constraint: string
        if (!is_null($jobCode) && !is_string($jobCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jobCode)), __LINE__);
        }
        $this->jobCode = $jobCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetUserAssignmentStatusByJob
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
