<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRequiredSkills StructType
 * @subpackage Structs
 */
class GetRequiredSkills extends AbstractStructBase
{
    /**
     * The populationLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $populationLevel;
    /**
     * The forUsrId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $forUsrId;
    /**
     * Constructor method for GetRequiredSkills
     * @uses GetRequiredSkills::setPopulationLevel()
     * @uses GetRequiredSkills::setForUsrId()
     * @param int $populationLevel
     * @param string $forUsrId
     */
    public function __construct($populationLevel = null, $forUsrId = null)
    {
        $this
            ->setPopulationLevel($populationLevel)
            ->setForUsrId($forUsrId);
    }
    /**
     * Get populationLevel value
     * @return int
     */
    public function getPopulationLevel()
    {
        return $this->populationLevel;
    }
    /**
     * Set populationLevel value
     * @param int $populationLevel
     * @return GetRequiredSkills
     */
    public function setPopulationLevel($populationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($populationLevel) && !is_numeric($populationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($populationLevel)), __LINE__);
        }
        $this->populationLevel = $populationLevel;
        return $this;
    }
    /**
     * Get forUsrId value
     * @return string|null
     */
    public function getForUsrId()
    {
        return $this->forUsrId;
    }
    /**
     * Set forUsrId value
     * @param string $forUsrId
     * @return GetRequiredSkills
     */
    public function setForUsrId($forUsrId = null)
    {
        // validation for constraint: string
        if (!is_null($forUsrId) && !is_string($forUsrId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forUsrId)), __LINE__);
        }
        $this->forUsrId = $forUsrId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetRequiredSkills
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
