<?php
/**
 * This class stands for CompletionStatus EnumType
 * @subpackage Enumerations
 */
class CompletionStatus
{
    /**
     * Constant for value 'NotCompleted'
     * @return string 'NotCompleted'
     */
    const VALUE_NOT_COMPLETED = 'NotCompleted';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'UnsupportedValue'
     * @return string 'UnsupportedValue'
     */
    const VALUE_UNSUPPORTED_VALUE = 'UnsupportedValue';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_COMPLETED
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_UNSUPPORTED_VALUE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_COMPLETED,
            self::VALUE_COMPLETED,
            self::VALUE_UNSUPPORTED_VALUE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
