<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CatalogPropertyBase StructType
 * @subpackage Structs
 */
abstract class CatalogPropertyBase extends Entity
{
    /**
     * The LId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LId;
    /**
     * The LLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $LLevel;
    /**
     * The PrntNodeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $PrntNodeId;
    /**
     * The RootCatalogId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $RootCatalogId;
    /**
     * The AssActivities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var ArrayOfActivityCatalogs
     */
    public $AssActivities;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The LName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LName;
    /**
     * The LDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LDescription;
    /**
     * The NodeKeywords
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NodeKeywords;
    /**
     * The LImage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LImage;
    /**
     * The BaseCatalogId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BaseCatalogId;
    /**
     * The BaseCatalog
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Catalog
     */
    public $BaseCatalog;
    /**
     * The LUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LUrl;
    /**
     * Constructor method for CatalogPropertyBase
     * @uses CatalogPropertyBase::setLId()
     * @uses CatalogPropertyBase::setLLevel()
     * @uses CatalogPropertyBase::setPrntNodeId()
     * @uses CatalogPropertyBase::setRootCatalogId()
     * @uses CatalogPropertyBase::setAssActivities()
     * @uses CatalogPropertyBase::setId()
     * @uses CatalogPropertyBase::setLName()
     * @uses CatalogPropertyBase::setLDescription()
     * @uses CatalogPropertyBase::setNodeKeywords()
     * @uses CatalogPropertyBase::setLImage()
     * @uses CatalogPropertyBase::setBaseCatalogId()
     * @uses CatalogPropertyBase::setBaseCatalog()
     * @uses CatalogPropertyBase::setLUrl()
     * @param int $lId
     * @param NullableInt32 $lLevel
     * @param NullableInt32 $prntNodeId
     * @param NullableInt32 $rootCatalogId
     * @param ArrayOfActivityCatalogs $assActivities
     * @param string $id
     * @param string $lName
     * @param string $lDescription
     * @param string $nodeKeywords
     * @param string $lImage
     * @param string $baseCatalogId
     * @param Catalog $baseCatalog
     * @param string $lUrl
     */
    public function __construct($lId = null, NullableInt32 $lLevel = null, NullableInt32 $prntNodeId = null, NullableInt32 $rootCatalogId = null, ArrayOfActivityCatalogs $assActivities = null, $id = null, $lName = null, $lDescription = null, $nodeKeywords = null, $lImage = null, $baseCatalogId = null, Catalog $baseCatalog = null, $lUrl = null)
    {
        $this
            ->setLId($lId)
            ->setLLevel($lLevel)
            ->setPrntNodeId($prntNodeId)
            ->setRootCatalogId($rootCatalogId)
            ->setAssActivities($assActivities)
            ->setId($id)
            ->setLName($lName)
            ->setLDescription($lDescription)
            ->setNodeKeywords($nodeKeywords)
            ->setLImage($lImage)
            ->setBaseCatalogId($baseCatalogId)
            ->setBaseCatalog($baseCatalog)
            ->setLUrl($lUrl);
    }
    /**
     * Get LId value
     * @return int
     */
    public function getLId()
    {
        return $this->LId;
    }
    /**
     * Set LId value
     * @param int $lId
     * @return CatalogPropertyBase
     */
    public function setLId($lId = null)
    {
        // validation for constraint: int
        if (!is_null($lId) && !is_numeric($lId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lId)), __LINE__);
        }
        $this->LId = $lId;
        return $this;
    }
    /**
     * Get LLevel value
     * @return NullableInt32
     */
    public function getLLevel()
    {
        return $this->LLevel;
    }
    /**
     * Set LLevel value
     * @param NullableInt32 $lLevel
     * @return CatalogPropertyBase
     */
    public function setLLevel(NullableInt32 $lLevel = null)
    {
        $this->LLevel = $lLevel;
        return $this;
    }
    /**
     * Get PrntNodeId value
     * @return NullableInt32
     */
    public function getPrntNodeId()
    {
        return $this->PrntNodeId;
    }
    /**
     * Set PrntNodeId value
     * @param NullableInt32 $prntNodeId
     * @return CatalogPropertyBase
     */
    public function setPrntNodeId(NullableInt32 $prntNodeId = null)
    {
        $this->PrntNodeId = $prntNodeId;
        return $this;
    }
    /**
     * Get RootCatalogId value
     * @return NullableInt32
     */
    public function getRootCatalogId()
    {
        return $this->RootCatalogId;
    }
    /**
     * Set RootCatalogId value
     * @param NullableInt32 $rootCatalogId
     * @return CatalogPropertyBase
     */
    public function setRootCatalogId(NullableInt32 $rootCatalogId = null)
    {
        $this->RootCatalogId = $rootCatalogId;
        return $this;
    }
    /**
     * Get AssActivities value
     * @return ArrayOfActivityCatalogs
     */
    public function getAssActivities()
    {
        return $this->AssActivities;
    }
    /**
     * Set AssActivities value
     * @param ArrayOfActivityCatalogs $assActivities
     * @return CatalogPropertyBase
     */
    public function setAssActivities(ArrayOfActivityCatalogs $assActivities = null)
    {
        $this->AssActivities = $assActivities;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return CatalogPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get LName value
     * @return string|null
     */
    public function getLName()
    {
        return $this->LName;
    }
    /**
     * Set LName value
     * @param string $lName
     * @return CatalogPropertyBase
     */
    public function setLName($lName = null)
    {
        // validation for constraint: string
        if (!is_null($lName) && !is_string($lName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lName)), __LINE__);
        }
        $this->LName = $lName;
        return $this;
    }
    /**
     * Get LDescription value
     * @return string|null
     */
    public function getLDescription()
    {
        return $this->LDescription;
    }
    /**
     * Set LDescription value
     * @param string $lDescription
     * @return CatalogPropertyBase
     */
    public function setLDescription($lDescription = null)
    {
        // validation for constraint: string
        if (!is_null($lDescription) && !is_string($lDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lDescription)), __LINE__);
        }
        $this->LDescription = $lDescription;
        return $this;
    }
    /**
     * Get NodeKeywords value
     * @return string|null
     */
    public function getNodeKeywords()
    {
        return $this->NodeKeywords;
    }
    /**
     * Set NodeKeywords value
     * @param string $nodeKeywords
     * @return CatalogPropertyBase
     */
    public function setNodeKeywords($nodeKeywords = null)
    {
        // validation for constraint: string
        if (!is_null($nodeKeywords) && !is_string($nodeKeywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nodeKeywords)), __LINE__);
        }
        $this->NodeKeywords = $nodeKeywords;
        return $this;
    }
    /**
     * Get LImage value
     * @return string|null
     */
    public function getLImage()
    {
        return $this->LImage;
    }
    /**
     * Set LImage value
     * @param string $lImage
     * @return CatalogPropertyBase
     */
    public function setLImage($lImage = null)
    {
        // validation for constraint: string
        if (!is_null($lImage) && !is_string($lImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lImage)), __LINE__);
        }
        $this->LImage = $lImage;
        return $this;
    }
    /**
     * Get BaseCatalogId value
     * @return string|null
     */
    public function getBaseCatalogId()
    {
        return $this->BaseCatalogId;
    }
    /**
     * Set BaseCatalogId value
     * @param string $baseCatalogId
     * @return CatalogPropertyBase
     */
    public function setBaseCatalogId($baseCatalogId = null)
    {
        // validation for constraint: string
        if (!is_null($baseCatalogId) && !is_string($baseCatalogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseCatalogId)), __LINE__);
        }
        $this->BaseCatalogId = $baseCatalogId;
        return $this;
    }
    /**
     * Get BaseCatalog value
     * @return Catalog|null
     */
    public function getBaseCatalog()
    {
        return $this->BaseCatalog;
    }
    /**
     * Set BaseCatalog value
     * @param Catalog $baseCatalog
     * @return CatalogPropertyBase
     */
    public function setBaseCatalog(Catalog $baseCatalog = null)
    {
        $this->BaseCatalog = $baseCatalog;
        return $this;
    }
    /**
     * Get LUrl value
     * @return string|null
     */
    public function getLUrl()
    {
        return $this->LUrl;
    }
    /**
     * Set LUrl value
     * @param string $lUrl
     * @return CatalogPropertyBase
     */
    public function setLUrl($lUrl = null)
    {
        // validation for constraint: string
        if (!is_null($lUrl) && !is_string($lUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lUrl)), __LINE__);
        }
        $this->LUrl = $lUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return CatalogPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
