<?php
/**
 * This class stands for AssignmentType EnumType
 * @subpackage Enumerations
 */
class AssignmentType
{
    /**
     * Constant for value 'Recommended'
     * @return string 'Recommended'
     */
    const VALUE_RECOMMENDED = 'Recommended';
    /**
     * Constant for value 'Required'
     * @return string 'Required'
     */
    const VALUE_REQUIRED = 'Required';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RECOMMENDED
     * @uses self::VALUE_REQUIRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RECOMMENDED,
            self::VALUE_REQUIRED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
