<?php
/**
 * This class stands for AssignmentCompletionStatus EnumType
 * @subpackage Enumerations
 */
class AssignmentCompletionStatus
{
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'NotCompleted'
     * @return string 'NotCompleted'
     */
    const VALUE_NOT_COMPLETED = 'NotCompleted';
    /**
     * Constant for value 'Expired'
     * @return string 'Expired'
     */
    const VALUE_EXPIRED = 'Expired';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_NOT_COMPLETED
     * @uses self::VALUE_EXPIRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMPLETED,
            self::VALUE_NOT_COMPLETED,
            self::VALUE_EXPIRED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
