<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDomain ArrayType
 * @subpackage Arrays
 */
class ArrayOfDomain extends AbstractStructArrayBase
{
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var Domain[]
     */
    public $Domain;
    /**
     * Constructor method for ArrayOfDomain
     * @uses ArrayOfDomain::setDomain()
     * @param Domain[] $domain
     */
    public function __construct(array $domain = array())
    {
        $this
            ->setDomain($domain);
    }
    /**
     * Get Domain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Domain[]|null
     */
    public function getDomain()
    {
        return isset($this->Domain) ? $this->Domain : null;
    }
    /**
     * Set Domain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param Domain[] $domain
     * @return ArrayOfDomain
     */
    public function setDomain(array $domain = array())
    {
        foreach ($domain as $arrayOfDomainDomainItem) {
            // validation for constraint: itemType
            if (!$arrayOfDomainDomainItem instanceof Domain) {
                throw new \InvalidArgumentException(sprintf('The Domain property can only contain items of Domain, "%s" given', is_object($arrayOfDomainDomainItem) ? get_class($arrayOfDomainDomainItem) : gettype($arrayOfDomainDomainItem)), __LINE__);
            }
        }
        if (is_null($domain) || (is_array($domain) && empty($domain))) {
            unset($this->Domain);
        } else {
            $this->Domain = $domain;
        }
        return $this;
    }
    /**
     * Add item to Domain value
     * @throws \InvalidArgumentException
     * @param Domain $item
     * @return ArrayOfDomain
     */
    public function addToDomain(Domain $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof Domain) {
            throw new \InvalidArgumentException(sprintf('The Domain property can only contain items of Domain, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Domain[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return Domain|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return Domain|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return Domain|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return Domain|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return Domain|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Domain
     */
    public function getAttributeName()
    {
        return 'Domain';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfDomain
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
